/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: QuoteClientBean.java 16912 2009-03-19 07:55:23Z coqp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.tutorial.jaxws.client;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.xml.ws.WebServiceRef;

import org.ow2.jonas.tutorial.jaxws.quote.Quote;
import org.ow2.jonas.tutorial.jaxws.quote.QuoteReporter;
import org.ow2.jonas.tutorial.jaxws.quote.QuoteReporterService;

@Stateless
@Remote(QuoteClient.class)
public class QuoteClientBean implements QuoteClient {

    @WebServiceRef
	private QuoteReporterService service;

	public void doTenQuotes() {

		QuoteReporter reporter = service.getQuoteReporterPort();
		for (int i = 0; i < 10; i++) {
			Quote quote = reporter.getQuote("Ticker " + i);
			System.out.println("Quote[" + quote.getTicker() + ", " + quote.getValue());
		}
	}
}
