/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006 Bull S.A.S
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s):
 * --------------------------------------------------------------------------
 * $Id: ClientException.java 17023 2009-03-31 16:20:29Z eyindanga $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.examples.cluster.javaee5.client;

import javax.ejb.EJB;

import org.ow2.jonas.examples.cluster.javaee5.beans.samplecluster3.MyException;
import org.ow2.jonas.examples.cluster.javaee5.beans.samplecluster3.MyStateless;


/**
 * Fat client :
 * - get an exception
 */
public class ClientException {

    /**
     * Link to the SSB.
     */
    @EJB
    private static MyStateless myStateless = null;

    /**
     * Private constructor for utility class
     *
     */
    private ClientException() {
    }

    /**
     * Main method
     * @param args arguments of the client
     */
    public static int main(final String[] args) {

        System.out.println("------------------------------------------");
        System.out.println("Bean created -> " + myStateless);
        System.out.println("------------------------------------------");

        try {
            System.out.println("Throw an exception at the server side");
            myStateless.throwMyException();
        } catch (MyException e) {
            System.out.println("MyException caught : invocation successful");
        }catch (Exception e) {
            System.out.println("Invocation failed because : " + e);
            System.out.println("Client KO. Exiting.");
            return -1;
        }
        System.out.println();
        System.out.println("Client OK. Exiting.");
        return 0;
    }
}

