/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.jms.JConnection;
import org.ow2.jonas.lib.jms.JSession;
import org.ow2.jonas.lib.jms.TraceJms;

public class JTopicSession
extends JSession
implements TopicSession {
    protected XATopicConnection xatc;
    protected TopicSession ts = null;
    protected XATopicSession xats = null;

    public JTopicSession(JConnection jconn, XATopicConnection xatc) {
        super(jconn);
        this.xatc = xatc;
    }

    protected Session getMOMSession() throws JMSException {
        return this.getMOMTopicSession();
    }

    protected TopicSession getMOMTopicSession() throws JMSException {
        Transaction tx = null;
        try {
            tx = tm.getTransaction();
        }
        catch (SystemException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"cannot get Transaction");
        }
        if (tx == null) {
            if (this.ts == null) {
                this.ts = this.xatc.createTopicSession(false, 1);
                this.jconn.sessionOpen(this);
            }
            return this.ts;
        }
        if (this.xats == null) {
            this.xats = this.xatc.createXATopicSession();
            if (this.currtx != null) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)"mixed transactions");
            }
            this.currtx = tx;
            this.xares = this.xats.getXAResource();
            try {
                tx.enlistResource(this.getXAResource());
                this.txover = false;
            }
            catch (SystemException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot enlist session:" + (Object)((Object)e)));
                throw new JMSException(e.toString());
            }
            catch (RollbackException e) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)"transaction rolled back");
                throw new JMSException(e.toString());
            }
        }
        return this.xats.getTopicSession();
    }

    protected void MOMSessionClose() {
        try {
            if (this.xats != null) {
                this.xats.close();
                this.xats = null;
            }
            if (this.ts != null) {
                this.ts.close();
                this.ts = null;
                this.jconn.sessionClose(this);
            }
        }
        catch (JMSException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("exception:" + (Object)((Object)e)));
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createSubscriber(topic, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createPublisher(topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMTopicSession().createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException, InvalidDestinationException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        this.getMOMTopicSession().unsubscribe(name);
    }
}

