/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import java.util.Vector;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.jms.JmsAdministration;
import org.ow2.jonas.lib.jms.TraceJms;

public class JmsAdminForWSMQ
implements JmsAdministration {
    private static String CONN_FACT_NAME = "JCF";
    private static String QUEUE_CONN_FACT_NAME = "JQCF";
    private static String TOPIC_CONN_FACT_NAME = "JTCF";
    private InitialContext ictx = null;
    private Vector namelist = new Vector();
    private XAConnectionFactory xacf = null;
    private XAQueueConnectionFactory xaqcf = null;
    private XATopicConnectionFactory xatcf = null;
    private ConnectionFactory jcf = null;
    private QueueConnectionFactory jqcf = null;
    private TopicConnectionFactory jtcf = null;

    public void start(boolean collocated, String url) throws Exception {
        this.ictx = new InitialContext();
        try {
            this.xacf = (XAConnectionFactory)this.ictx.lookup("wsmqXACF");
            this.ictx.unbind("wsmqXACF");
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ XAConnectionFactory could not be retrieved from JNDI");
        }
        try {
            this.xaqcf = (XAQueueConnectionFactory)this.ictx.lookup("wsmqXAQCF");
            this.ictx.unbind("wsmqXAQCF");
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ XAQueueConnectionFactory could not be retrieved from JNDI");
        }
        try {
            this.xatcf = (XATopicConnectionFactory)this.ictx.lookup("wsmqXATCF");
            this.ictx.unbind("wsmqXATCF");
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ XATopicConnectionFactory could not be retrieved from JNDI");
        }
        try {
            this.ictx.lookup(CONN_FACT_NAME);
            this.namelist.addElement(CONN_FACT_NAME);
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ ConnectionFactory could not be retrieved from JNDI");
        }
        try {
            this.ictx.lookup(QUEUE_CONN_FACT_NAME);
            this.namelist.addElement(QUEUE_CONN_FACT_NAME);
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ QueueConnectionFactory could not be retrieved from JNDI");
        }
        try {
            this.ictx.lookup(TOPIC_CONN_FACT_NAME);
            this.namelist.addElement(TOPIC_CONN_FACT_NAME);
        }
        catch (NamingException exc) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"WebSphere MQ TopicConnectionFactory could not be retrieved from JNDI");
        }
    }

    public void stop() {
        try {
            this.ictx.unbind(CONN_FACT_NAME);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.ictx.unbind(QUEUE_CONN_FACT_NAME);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.ictx.unbind(TOPIC_CONN_FACT_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceJms.isDebug()) {
            TraceJms.logger.log(BasicLevel.DEBUG, (Object)"connection factories unbound");
        }
    }

    public XAConnectionFactory getXAConnectionFactory() {
        return this.xacf;
    }

    public XATopicConnectionFactory getXATopicConnectionFactory() {
        return this.xatcf;
    }

    public XAQueueConnectionFactory getXAQueueConnectionFactory() {
        return this.xaqcf;
    }

    public Queue createQueue(String name) throws Exception {
        throw new Exception("WebSphere MQ Queue creation impossible from JOnAS");
    }

    public Topic createTopic(String name) throws Exception {
        throw new Exception("WebSphere MQ Topic creation impossible from JOnAS");
    }

    public void deleteDestination(String name) throws Exception {
        throw new Exception("WebSphere MQ destination deletion impossible from JOnAS");
    }

    public int getPendingMessages(Queue queue) throws Exception {
        return -1;
    }

    public int getPendingRequests(Queue queue) throws Exception {
        return -1;
    }

    public int getSubscriptions(Topic topic) throws Exception {
        return -1;
    }
}

