/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.Handle;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.Field;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.MethodCmp2Desc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.MethodJdbcCmp1Desc;
import org.ow2.jonas.generators.genic.GenIC;
import org.ow2.jonas.generators.genic.VcParam;
import org.ow2.jonas.generators.genic.VcParamWhere;
import org.ow2.jonas.lib.ejb21.JavaType;
import org.ow2.jonas.lib.ejb21.sql.EjbqlQueryTreeHolder;
import org.ow2.jonas.lib.util.BeanNaming;

public class VcMethod {
    static final byte METHOD_CREATE = 0;
    static final byte METHOD_EJB_CREATE = 1;
    static final byte METHOD_EJB_POST_CREATE = 2;
    static final byte METHOD_REMOVE_THIS = 10;
    static final byte METHOD_REMOVE_PK = 11;
    static final byte METHOD_REMOVE_HANDLE = 12;
    static final byte METHOD_EJB_REMOVE = 13;
    static final byte METHOD_FINDER_BY_PK = 20;
    static final byte METHOD_FINDER_ALL = 21;
    static final byte METHOD_FINDER_SIMPLE = 22;
    static final byte METHOD_FINDER_ENUM = 23;
    static final byte METHOD_FINDER_COL = 24;
    static final byte METHOD_EJB_SELECT_SIMPLE = 30;
    static final byte METHOD_EJB_SELECT_COL = 31;
    static final byte METHOD_EJB_SELECT_SET = 32;
    static final byte METHOD_EJB_LOAD = 40;
    static final byte METHOD_EJB_STORE = 41;
    static final byte METHOD_EJB_SET_ENTITY_CONTEXT = 42;
    static final byte METHOD_EJB_ACTIVATE = 43;
    private byte mKind = (byte)-1;
    private String mName = null;
    private String mCapName = null;
    private StringBuffer mFormalParameters = null;
    private StringBuffer mActualParameters = null;
    private StringBuffer mArrayObjectParameters = null;
    private StringBuffer mExceptionList = null;
    private String mSecuritySignature;
    private int mTxAttribute = -1;
    private String mReturnType;
    private String mDefaultValue;
    private String mWrapperType;
    private Method mMethod = null;
    private int methodIndex = -1;
    private BeanDesc beanDesc = null;
    private Manager manager = null;
    private String mSqlStmt = null;
    private ArrayList mParamWhereList = null;
    private boolean isEjbqlReturnRemoteBean = false;
    private boolean isEjbqlReturnLocalBean = false;
    private Field resFieldOfEjbql = null;
    private ArrayList mParamList = null;
    private Class[] parameterTypes = null;
    private boolean canThrowCreate = false;
    protected EjbqlQueryTreeHolder queryTreeHolder = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    VcMethod(Method method, MethodDesc methodDesc, BeanDesc dd, Manager mgr) {
        boolean isRemove;
        if (methodDesc != null) {
            this.methodIndex = methodDesc.getIndex();
        }
        this.beanDesc = dd;
        this.manager = mgr;
        Class<?> declClass = method.getDeclaringClass();
        Class<?>[] params = method.getParameterTypes();
        this.parameterTypes = params;
        Class<?>[] exceptions = method.getExceptionTypes();
        this.mMethod = method;
        this.mName = method.getName();
        this.mCapName = BeanNaming.firstToUpperCase((String)this.mName);
        this.mFormalParameters = new StringBuffer();
        this.mActualParameters = new StringBuffer();
        this.mArrayObjectParameters = new StringBuffer();
        String var = null;
        for (int p = 1; p <= params.length; ++p) {
            var = "p" + p;
            this.mFormalParameters.append(JavaType.getName(params[p - 1]) + " " + var);
            this.mActualParameters.append(var);
            this.mArrayObjectParameters.append(JavaType.toStringObject((String)var, params[p - 1]));
            if (p >= params.length) continue;
            this.mFormalParameters.append(", ");
            this.mActualParameters.append(", ");
            this.mArrayObjectParameters.append(", ");
        }
        this.mExceptionList = new StringBuffer();
        for (int e = 0; e < exceptions.length; ++e) {
            Class<?> ecl = exceptions[e];
            if (CreateException.class.isAssignableFrom(ecl)) {
                this.canThrowCreate = true;
            }
            this.mExceptionList.append(JavaType.getName(ecl));
            if (e >= exceptions.length - 1) continue;
            this.mExceptionList.append(", ");
        }
        if (methodDesc != null) {
            this.mSecuritySignature = "";
            if (methodDesc.getRoleName().length > 0 || methodDesc.isExcluded()) {
                this.mSecuritySignature = BeanNaming.getSignature((String)dd.getEjbName(), (Method)method);
            }
        }
        if (methodDesc != null) {
            this.mTxAttribute = methodDesc.getTxAttribute();
        }
        this.mReturnType = JavaType.getName(method.getReturnType());
        if (!this.mReturnType.equals("void")) {
            this.mDefaultValue = JavaType.getDefaultValue(method.getReturnType());
            this.mWrapperType = JavaType.getWrapperType(method.getReturnType());
        }
        boolean isFinder = false;
        if (this.mName.startsWith("find") && (EJBHome.class.isAssignableFrom(declClass) || EJBLocalHome.class.isAssignableFrom(declClass))) {
            isFinder = true;
        }
        if (isFinder) {
            this.mKind = "findByPrimaryKey".equals(this.mName) ? (byte)20 : (Enumeration.class.equals(method.getReturnType()) ? (byte)23 : (Collection.class.equals(method.getReturnType()) ? (byte)24 : (byte)22));
        }
        if (this.mName.startsWith("create") && (EJBHome.class.isAssignableFrom(declClass) || EJBLocalHome.class.isAssignableFrom(declClass))) {
            this.mKind = 0;
        }
        if (this.mName.startsWith("ejbCreate") && EnterpriseBean.class.isAssignableFrom(declClass)) {
            this.mKind = 1;
        }
        if (this.mName.startsWith("ejbPostCreate") && EnterpriseBean.class.isAssignableFrom(declClass)) {
            this.mKind = (byte)2;
        }
        if (isRemove = "remove".equals(this.mName)) {
            if (declClass.equals(EJBObject.class) || declClass.equals(EJBLocalObject.class)) {
                this.mKind = (byte)10;
            } else if (declClass.equals(EJBHome.class) || declClass.equals(EJBLocalHome.class)) {
                this.mKind = params[0].equals(Handle.class) ? (byte)12 : (byte)11;
            }
        }
        if (EnterpriseBean.class.isAssignableFrom(declClass) && params.length == 0) {
            if ("ejbRemove".equals(this.mName)) {
                this.mKind = (byte)13;
            } else if ("ejbLoad".equals(this.mName)) {
                this.mKind = (byte)40;
            } else if ("ejbStore".equals(this.mName)) {
                this.mKind = (byte)41;
            }
        }
        if (EnterpriseBean.class.isAssignableFrom(declClass) && "setEntityContext".equals(this.mName) && params.length == 1 && EntityContext.class.equals(params[0])) {
            this.mKind = (byte)42;
        }
        if (EnterpriseBean.class.isAssignableFrom(declClass) && "ejbActivate".equals(this.mName) && params.length == 0) {
            this.mKind = (byte)43;
        }
        if (dd instanceof EntityJdbcCmp1Desc) {
            EntityJdbcCmp1Desc edd = (EntityJdbcCmp1Desc)dd;
            StringBuffer lf = new StringBuffer();
            StringBuffer lv = new StringBuffer();
            boolean firstLf = true;
            boolean firstLv = true;
            if (this.mKind == 1) {
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (firstLv) {
                        firstLv = false;
                    } else {
                        lf.append(", ");
                        lv.append(", ");
                    }
                    lf.append(fd.getJdbcFieldName());
                    lv.append("?");
                }
                this.mSqlStmt = "insert into " + edd.getJdbcTableName() + " (" + lf + ") values (" + lv + ")";
                return;
            } else if (this.mKind == 20) {
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    if (firstLv) {
                        firstLv = false;
                    } else {
                        lf.append(", ");
                        lv.append(" and ");
                    }
                    lf.append(fd.getJdbcFieldName());
                    lv.append(fd.getJdbcFieldName() + "=?");
                }
                this.mSqlStmt = "select " + lf + " from " + edd.getJdbcTableName() + " where " + lv;
                return;
            } else if (this.mKind == 22 || this.mKind == 23 || this.mKind == 24) {
                if (!((MethodJdbcCmp1Desc)methodDesc).hasWhereClause()) {
                    throw new Error("No WHERE clause defined for the finder method '" + method.toString() + "'");
                }
                ArrayList posParams = new ArrayList();
                String clauseWhere = this.parseWhere(((MethodJdbcCmp1Desc)methodDesc).getWhereClause(), posParams);
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    if (firstLf) {
                        firstLf = false;
                    } else {
                        lf.append(", ");
                    }
                    lf.append(fd.getJdbcFieldName());
                }
                this.mSqlStmt = "select " + lf + " from " + edd.getJdbcTableName() + " " + clauseWhere;
                this.mParamWhereList = new ArrayList();
                for (int i2 = 0; i2 < posParams.size(); ++i2) {
                    int pos = (Integer)posParams.get(i2);
                    if (pos >= params.length) {
                        throw new Error("Wrong parameters number between the method definition and the WHERE clause of the method '" + method + "'");
                    }
                    VcParamWhere vpw = new VcParamWhere(params[pos], pos + 1);
                    this.mParamWhereList.add(vpw);
                }
                return;
            } else if (this.mKind == 13) {
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    if (firstLv) {
                        firstLv = false;
                    } else {
                        lv.append(" and ");
                    }
                    lv.append(fd.getJdbcFieldName() + "=?");
                }
                this.mSqlStmt = "delete from " + edd.getJdbcTableName() + " where " + lv;
                return;
            } else if (this.mKind == 40) {
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (firstLf) {
                        firstLf = false;
                    } else {
                        lf.append(", ");
                    }
                    lf.append(fd.getJdbcFieldName());
                    if (!fd.isPrimaryKey()) continue;
                    if (firstLv) {
                        firstLv = false;
                    } else {
                        lv.append(" and ");
                    }
                    lv.append(fd.getJdbcFieldName() + "=?");
                }
                this.mSqlStmt = "select " + lf + " from " + edd.getJdbcTableName() + " where " + lv;
                return;
            } else {
                if (this.mKind != 41) return;
                Iterator i = edd.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (fd.isPrimaryKey()) {
                        if (firstLv) {
                            firstLv = false;
                        } else {
                            lv.append(" and ");
                        }
                        lv.append(fd.getJdbcFieldName() + "=?");
                        continue;
                    }
                    if (firstLf) {
                        firstLf = false;
                    } else {
                        lf.append(", ");
                    }
                    lf.append(fd.getJdbcFieldName() + "=?");
                }
                this.mSqlStmt = "update " + edd.getJdbcTableName() + " set " + lf + " where " + lv;
            }
            return;
        } else {
            if (!(dd instanceof EntityJdbcCmp2Desc)) return;
            boolean isEjbSelect = false;
            if (this.mName.startsWith("ejbSelect") && EntityBean.class.isAssignableFrom(declClass)) {
                isEjbSelect = true;
            }
            if (isEjbSelect) {
                this.mKind = Collection.class.equals(method.getReturnType()) ? (byte)31 : (Set.class.equals(method.getReturnType()) ? (byte)32 : (byte)30);
            }
            if (!isFinder && !isEjbSelect) return;
            this.mParamList = new ArrayList();
            for (int p = 0; p < params.length; ++p) {
                this.mParamList.add(new VcParam(params[p], dd));
            }
            if (isEjbSelect) {
                try {
                    this.resFieldOfEjbql = this.getResField((MethodCmp2Desc)methodDesc);
                    if (this.resFieldOfEjbql.getType().getTypeCode() != 23) return;
                    if (((MethodCmp2Desc)methodDesc).isResultTypeMappingRemote()) {
                        this.isEjbqlReturnRemoteBean = true;
                        return;
                    }
                    this.isEjbqlReturnLocalBean = true;
                    return;
                }
                catch (DeploymentDescException e) {
                    throw new Error("Error while the EJB-QL parsing of '" + method.toString() + "': " + e.getMessage());
                }
            } else {
                if (this.isFinderByPk()) return;
                try {
                    this.getResField((MethodCmp2Desc)methodDesc);
                    return;
                }
                catch (DeploymentDescException ignore) {
                    GenIC.warning("Warning: Error while the EJB-QL parsing of '" + method.toString() + "': " + ignore.getMessage());
                }
            }
        }
    }

    private Field getResField(MethodCmp2Desc md) throws DeploymentDescException {
        if (this.queryTreeHolder == null) {
            try {
                this.queryTreeHolder = new EjbqlQueryTreeHolder(md, md.getQueryNode(), null, this.manager);
            }
            catch (Exception e) {
                throw new DeploymentDescException("ejbql query does not map to the persistent schema", (Throwable)e);
            }
        }
        return this.queryTreeHolder.getResField();
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    private String parseWhere(String fragment, List pos) {
        StringTokenizer parseWhere = new StringTokenizer(fragment, "?\n", true);
        int numpos = pos.size();
        String newWhere = "";
        while (parseWhere.hasMoreTokens()) {
            String tok = parseWhere.nextToken();
            String numVar = "";
            if (Character.isDigit(tok.charAt(0))) {
                for (int i = 0; tok.length() > i && Character.isDigit(tok.charAt(i)); ++i) {
                    numVar = numVar + tok.charAt(i);
                }
                if (numVar.length() <= 0) continue;
                newWhere = newWhere + tok.substring(numVar.length(), tok.length());
                pos.set(numpos - 1, new Integer(Integer.parseInt(numVar) - 1));
                continue;
            }
            newWhere = newWhere + tok;
            if (tok.charAt(0) != '?') continue;
            pos.add(new Integer(numpos++));
        }
        return newWhere;
    }

    public String getName() {
        return this.mName;
    }

    public String getCapName() {
        return this.mCapName;
    }

    public String getFormalParameters() {
        return this.mFormalParameters.toString();
    }

    public String getActualParameters() {
        return this.mActualParameters.toString();
    }

    public String getExceptionList() {
        return this.mExceptionList.toString();
    }

    public boolean canThrowCreate() {
        return this.canThrowCreate;
    }

    public String getSecuritySignature() {
        if (this.mSecuritySignature == null) {
            throw new Error("VcMethod.getSecuritySignature() not available for the method '" + this.mMethod.toString() + "'");
        }
        return this.mSecuritySignature;
    }

    public int getTxAttribute() {
        if (this.mTxAttribute == -1) {
            throw new Error("VcMethod.getTxAttribute() not available for the method '" + this.mMethod.toString() + "'");
        }
        return this.mTxAttribute;
    }

    public String getReturnType() {
        return this.mReturnType;
    }

    public String getWrapperType() {
        return this.mWrapperType;
    }

    public boolean isFinderAll() {
        return false;
    }

    public boolean isFinderByPk() {
        return this.mKind == 20;
    }

    public boolean isFinderSimple() {
        return this.mKind == 22;
    }

    public boolean isFinderEnum() {
        return this.mKind == 23;
    }

    public boolean isFinderCol() {
        return this.mKind == 24;
    }

    public boolean isEjbSelectSimple() {
        return this.mKind == 30;
    }

    public boolean isEjbSelectSet() {
        return this.mKind == 32;
    }

    public boolean isEjbSelectCol() {
        return this.mKind == 31;
    }

    public boolean isEjbqlReturnRemoteBean() {
        return this.isEjbqlReturnRemoteBean;
    }

    public boolean isEjbqlReturnLocalBean() {
        return this.isEjbqlReturnLocalBean;
    }

    public boolean isCreate() {
        return this.mKind == 0;
    }

    public boolean isEjbCreate() {
        return this.mKind == 1;
    }

    public boolean isEjbPostCreate() {
        return this.mKind == 2;
    }

    public boolean isRemoveThis() {
        return this.mKind == 10;
    }

    public boolean isRemovePk() {
        return this.mKind == 11;
    }

    public boolean isRemoveHandle() {
        return this.mKind == 12;
    }

    public boolean isEjbRemove() {
        return this.mKind == 13;
    }

    public boolean isEjbLoad() {
        return this.mKind == 40;
    }

    public boolean isEjbStore() {
        return this.mKind == 41;
    }

    public boolean isEjbSetEntityContext() {
        return this.mKind == 42;
    }

    public boolean isEjbActivate() {
        return this.mKind == 43;
    }

    public String getSqlStmt() {
        if (this.mSqlStmt == null) {
            throw new Error("VcMethod.getSqlStmt() not available for the method '" + this.mMethod.toString() + "'");
        }
        return this.mSqlStmt;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getParametersNumber() {
        return this.parameterTypes.length;
    }

    public Vector getParamWhereList() {
        if (this.mParamWhereList == null) {
            throw new Error("VcMethod.getParamWhereList() not available for the method '" + this.mMethod.toString() + "'");
        }
        return new Vector(this.mParamWhereList);
    }

    public Vector getParamList() {
        if (this.mParamList == null) {
            throw new Error("VcMethod.getParamList() not available for the method '" + this.mMethod.toString() + "'");
        }
        return new Vector(this.mParamList);
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public Field getResFieldOfEjbql() {
        return this.resFieldOfEjbql;
    }

    public String getTupleGetter() {
        PType type = this.resFieldOfEjbql.getType();
        switch (type.getTypeCode()) {
            case 0: {
                return "getBoolean";
            }
            case 2: {
                return "getByte";
            }
            case 1: {
                return "getChar";
            }
            case 17: {
                return "getDate";
            }
            case 7: {
                return "getDouble";
            }
            case 6: {
                return "getFloat";
            }
            case 4: {
                return "getInt";
            }
            case 5: {
                return "getLong";
            }
            case 20: {
                return "getObject";
            }
            case 3: {
                return "getShort";
            }
            case 16: {
                return "getString";
            }
        }
        return "getObject";
    }

    public boolean isTupleGetterPrimitive() {
        PType type = this.resFieldOfEjbql.getType();
        switch (type.getTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public String getTupleGetterObjectClass() {
        PType type = this.resFieldOfEjbql.getType();
        switch (type.getTypeCode()) {
            case 0: {
                return "Boolean";
            }
            case 2: {
                return "Byte";
            }
            case 1: {
                return "Char";
            }
            case 7: {
                return "Double";
            }
            case 6: {
                return "Float";
            }
            case 4: {
                return "Integer";
            }
            case 5: {
                return "Long";
            }
            case 3: {
                return "Short";
            }
        }
        return "Object";
    }

    String[] splitPath(String path) {
        StringTokenizer st = new StringTokenizer(path, ".");
        String[] ret = new String[st.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = st.nextToken();
        }
        return ret;
    }

    public String getArrayObjectParameters() {
        if (this.mArrayObjectParameters.length() == 0) {
            return "new Object[0]";
        }
        return "new Object[] {" + this.mArrayObjectParameters.toString() + "}";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n    Name                  = " + this.getName());
        ret.append("\n    CapName               = " + this.getCapName());
        ret.append("\n    FormalParameters      = " + this.getFormalParameters());
        ret.append("\n    ActualParameters      = " + this.getActualParameters());
        ret.append("\n    ExceptionList         = " + this.getExceptionList());
        if (this.mSecuritySignature != null) {
            ret.append("\n    SecuritySignature     = " + this.getSecuritySignature());
        }
        if (this.mTxAttribute != -1) {
            ret.append("\n    TxAttribute           = " + this.getTxAttribute());
        }
        ret.append("\n    ReturnType            = " + this.getReturnType());
        ret.append("\n    isFinderByPk          = " + this.isFinderByPk());
        ret.append("\n    isFinderSimple        = " + this.isFinderSimple());
        ret.append("\n    isFinderEnum          = " + this.isFinderEnum());
        ret.append("\n    isFinderCol           = " + this.isFinderCol());
        ret.append("\n    isCreate              = " + this.isCreate());
        ret.append("\n    isEjbCreate           = " + this.isEjbCreate());
        ret.append("\n    isRemoveThis          = " + this.isRemoveThis());
        ret.append("\n    isRemovePk            = " + this.isRemovePk());
        ret.append("\n    isRemoveHandle        = " + this.isRemoveHandle());
        ret.append("\n    isEjbRemove           = " + this.isEjbRemove());
        ret.append("\n    isEjbLoad             = " + this.isEjbLoad());
        ret.append("\n    isEjbStore            = " + this.isEjbStore());
        ret.append("\n    isEjbSetEntityContext = " + this.isEjbSetEntityContext());
        ret.append("\n    isEjbActivate         = " + this.isEjbActivate());
        ret.append("\n    isEjbSelectSimple     = " + this.isEjbSelectSimple());
        ret.append("\n    isEjbSelectSet        = " + this.isEjbSelectSet());
        ret.append("\n    isEjbSelectCol        = " + this.isEjbSelectCol());
        if (this.mSqlStmt != null) {
            ret.append("\n    SqlStmt               = " + this.getSqlStmt());
        }
        if (this.mParamWhereList != null) {
            ret.append("\n    ParamWhereList        = " + this.getParamWhereList());
        }
        return ret.toString();
    }
}

