/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.CompositeHandler;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.composite.CompositeServiceContext;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CompositeManager
implements ComponentInstance,
InstanceStateListener {
    private BundleContext m_context;
    private ComponentFactory m_factory;
    private HandlerManager[] m_handlers = new HandlerManager[0];
    private List m_instanceListeners = new ArrayList();
    private CompositeServiceContext m_internalContext;
    private String m_name;
    private int m_state = 0;
    static /* synthetic */ Class class$org$apache$felix$ipojo$architecture$Architecture;

    public CompositeManager(ComponentFactory factory, BundleContext bc, HandlerManager[] handlers) {
        this.m_factory = factory;
        this.m_context = bc;
        this.m_internalContext = new CompositeServiceContext(this.m_context, this);
        this.m_handlers = handlers;
    }

    public synchronized void addCompositeHandler(HandlerManager h) {
        if (this.m_handlers.length > 0) {
            HandlerManager[] newInstances = new HandlerManager[this.m_handlers.length + 1];
            System.arraycopy(this.m_handlers, 0, newInstances, 0, this.m_handlers.length);
            newInstances[this.m_handlers.length] = h;
            this.m_handlers = newInstances;
        } else {
            this.m_handlers = new HandlerManager[]{h};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceStateListener(InstanceStateListener listener) {
        List list = this.m_instanceListeners;
        synchronized (list) {
            this.m_instanceListeners.add(listener);
        }
    }

    public void configure(Element cm, Dictionary configuration) throws ConfigurationException {
        this.m_name = (String)configuration.get("name");
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].init(this, cm, configuration);
        }
    }

    public void dispose() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        for (i = 0; i < this.m_instanceListeners.size(); ++i) {
            ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, -1);
        }
        this.m_factory.disposed(this);
        this.m_state = -1;
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        this.m_handlers = new HandlerManager[0];
        this.m_instanceListeners.clear();
    }

    public CompositeHandler getCompositeHandler(String name) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            HandlerFactory fact = (HandlerFactory)this.m_handlers[i].getFactory();
            if (!fact.getHandlerName().equals(name) && !fact.getComponentClassName().equals(name)) continue;
            return (CompositeHandler)this.m_handlers[i].getHandler();
        }
        return null;
    }

    public BundleContext getContext() {
        return this.m_context;
    }

    public ComponentFactory getFactory() {
        return this.m_factory;
    }

    public BundleContext getGlobalContext() {
        IPojoContext c = (IPojoContext)this.m_context;
        return c.getGlobalContext();
    }

    public InstanceDescription getInstanceDescription() {
        InstanceDescription instanceDescription = new InstanceDescription(this.m_name, this.m_state, this.getContext().getBundle().getBundleId(), this.m_factory.getComponentDescription());
        CompositeHandler[] handlers = this.getRegistredCompositeHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            instanceDescription.addHandler(handlers[i].getDescription());
        }
        try {
            ServiceReference[] refs = this.m_internalContext.getServiceReferences((class$org$apache$felix$ipojo$architecture$Architecture == null ? (class$org$apache$felix$ipojo$architecture$Architecture = CompositeManager.class$("org.apache.felix.ipojo.architecture.Architecture")) : class$org$apache$felix$ipojo$architecture$Architecture).getName(), null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    Architecture arch = (Architecture)this.m_internalContext.getService(refs[i]);
                    instanceDescription.addInstance(arch.getInstanceDescription());
                    this.m_internalContext.ungetService(refs[i]);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return instanceDescription;
    }

    public String getInstanceName() {
        return this.m_name;
    }

    public ServiceContext getParentServiceContext() {
        IPojoContext c = (IPojoContext)this.m_context;
        return c.getServiceContext();
    }

    public CompositeHandler[] getRegistredCompositeHandlers() {
        CompositeHandler[] h = new CompositeHandler[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            h[i] = (CompositeHandler)this.m_handlers[i].getHandler();
        }
        return h;
    }

    public ServiceContext getServiceContext() {
        return this.m_internalContext;
    }

    public int getState() {
        return this.m_state;
    }

    public boolean isStarted() {
        return this.m_state > 0;
    }

    public void reconfigure(Dictionary configuration) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].reconfigure(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceStateListener(InstanceStateListener listener) {
        List list = this.m_instanceListeners;
        synchronized (list) {
            this.m_instanceListeners.remove(listener);
        }
    }

    public void setState(int state) {
        block5: {
            int i;
            if (this.m_state == state) break block5;
            if (state > this.m_state) {
                this.m_state = state;
                for (i = 0; i < this.m_handlers.length; ++i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            } else {
                this.m_state = state;
                for (i = this.m_handlers.length - 1; i > -1; --i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            }
            for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, state);
            }
        }
    }

    public synchronized void start() {
        int i;
        if (this.m_state > 0) {
            return;
        }
        this.m_state = 1;
        this.m_internalContext.start();
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].start();
            this.m_handlers[i].addInstanceStateListener(this);
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getState() == 2) continue;
            this.setState(1);
            return;
        }
        this.setState(2);
    }

    public synchronized void stateChanged(ComponentInstance instance, int newState) {
        if (this.m_state <= 0) {
            return;
        }
        if (newState == 1 && this.m_state == 2) {
            this.setState(1);
            return;
        }
        if (newState == 2 && this.m_state == 1) {
            boolean isValid = true;
            for (int i = 0; i < this.m_handlers.length; ++i) {
                isValid = isValid && this.m_handlers[i].getState() == 2;
            }
            if (isValid) {
                this.setState(2);
            }
        }
        if (newState == -1) {
            this.kill();
        }
    }

    public synchronized void stop() {
        int i;
        if (this.m_state <= 0) {
            return;
        }
        this.setState(1);
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener(this);
            this.m_handlers[i].stop();
        }
        this.m_internalContext.stop();
        this.m_state = 0;
        for (i = 0; i < this.m_instanceListeners.size(); ++i) {
            ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, 0);
        }
    }

    protected synchronized void kill() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        for (i = 0; i < this.m_instanceListeners.size(); ++i) {
            ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, -1);
        }
        this.m_state = -1;
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        this.m_handlers = new HandlerManager[0];
        this.m_instanceListeners.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

