/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;

public class ManipulationMetadata {
    private String[] m_interfaces = new String[0];
    private FieldMetadata[] m_fields = new FieldMetadata[0];
    private MethodMetadata[] m_methods = new MethodMetadata[0];
    private String m_super;

    public ManipulationMetadata(Element metadata) {
        Element manip = metadata.getElements("manipulation", "")[0];
        this.m_super = manip.getAttribute("super");
        Element[] fields = manip.getElements("field");
        for (int i = 0; i < fields.length; ++i) {
            FieldMetadata fm = new FieldMetadata(fields[i]);
            this.addField(fm);
        }
        Element[] methods = manip.getElements("method");
        for (int i = 0; i < methods.length; ++i) {
            MethodMetadata fm = new MethodMetadata(methods[i]);
            this.addMethod(fm);
        }
        Element[] itfs = manip.getElements("interface");
        for (int i = 0; i < itfs.length; ++i) {
            this.addInterface(itfs[i].getAttribute("name"));
        }
    }

    public MethodMetadata[] getMethods() {
        return this.m_methods;
    }

    public FieldMetadata[] getFields() {
        return this.m_fields;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public FieldMetadata getField(String name) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public FieldMetadata getField(String name, String type) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name) || !this.m_fields[i].getFieldType().equalsIgnoreCase(type)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public boolean isInterfaceImplemented(String itf) {
        for (int i = 0; i < this.m_interfaces.length; ++i) {
            if (!this.m_interfaces[i].equals(itf)) continue;
            return true;
        }
        return false;
    }

    public MethodMetadata getMethod(String name) {
        for (int i = 0; i < this.m_methods.length; ++i) {
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name)) continue;
            return this.m_methods[i];
        }
        return null;
    }

    public MethodMetadata[] getMethods(String name) {
        MethodMetadata[] mms = new MethodMetadata[]{};
        for (int i = 0; i < this.m_methods.length; ++i) {
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name)) continue;
            if (mms.length > 0) {
                MethodMetadata[] newInstances = new MethodMetadata[mms.length + 1];
                System.arraycopy(mms, 0, newInstances, 0, mms.length);
                newInstances[mms.length] = this.m_methods[i];
                mms = newInstances;
                continue;
            }
            mms = new MethodMetadata[]{this.m_methods[i]};
        }
        return mms;
    }

    public MethodMetadata getMethod(String name, String[] types) {
        for (int i = 0; i < this.m_methods.length; ++i) {
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name) || this.m_methods[i].getMethodArguments().length != types.length) continue;
            boolean ok = true;
            for (int j = 0; ok && j < types.length; ++j) {
                if (types[j].equals(this.m_methods[i].getMethodArguments()[j])) continue;
                ok = false;
            }
            if (!ok) continue;
            return this.m_methods[i];
        }
        return null;
    }

    private void addMethod(MethodMetadata mm) {
        for (int i = 0; this.m_methods != null && i < this.m_methods.length; ++i) {
            if (this.m_methods[i] != mm) continue;
            return;
        }
        if (this.m_methods.length > 0) {
            MethodMetadata[] newInstances = new MethodMetadata[this.m_methods.length + 1];
            System.arraycopy(this.m_methods, 0, newInstances, 0, this.m_methods.length);
            newInstances[this.m_methods.length] = mm;
            this.m_methods = newInstances;
        } else {
            this.m_methods = new MethodMetadata[]{mm};
        }
    }

    private void addField(FieldMetadata mm) {
        for (int i = 0; this.m_fields != null && i < this.m_fields.length; ++i) {
            if (this.m_fields[i] != mm) continue;
            return;
        }
        if (this.m_fields.length > 0) {
            FieldMetadata[] newInstances = new FieldMetadata[this.m_fields.length + 1];
            System.arraycopy(this.m_fields, 0, newInstances, 0, this.m_fields.length);
            newInstances[this.m_fields.length] = mm;
            this.m_fields = newInstances;
        } else {
            this.m_fields = new FieldMetadata[]{mm};
        }
    }

    private void addInterface(String mm) {
        for (int i = 0; this.m_interfaces != null && i < this.m_interfaces.length; ++i) {
            if (this.m_interfaces[i] != mm) continue;
            return;
        }
        if (this.m_interfaces.length > 0) {
            String[] newInstances = new String[this.m_interfaces.length + 1];
            System.arraycopy(this.m_interfaces, 0, newInstances, 0, this.m_interfaces.length);
            newInstances[this.m_interfaces.length] = mm;
            this.m_interfaces = newInstances;
        } else {
            this.m_interfaces = new String[]{mm};
        }
    }

    public String getSuperClass() {
        return this.m_super;
    }
}

