/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import org.ow2.jonas.properties.ServerProperties;

public class JProp
implements ServerProperties {
    public static final String JONAS_VERSIONS = "VERSIONS";
    public static final String JONASPREFIX = "jonas";
    public static final String DOMAIN_NAME = "domain.name";
    public static final String JONAS_NAME = "jonas.name";
    public static final String JONAS_DEF_NAME = "jonas";
    public static final String JONAS_BASE = "jonas.base";
    public static final String JONAS_MASTER = "jonas.master";
    private static final String CONFIG_DIR = "conf";
    private static Properties systEnv = System.getProperties();
    private static String jonasBase = systEnv.getProperty("jonas.base");
    private static String installRoot = systEnv.getProperty("install.root");
    private static String fileSeparator = systEnv.getProperty("file.separator");
    private String configFileXml = null;
    private String versionFileContent = null;
    private Properties configFileEnv = new Properties();
    private Properties allEnv = null;
    private String propFileName = null;
    private static JProp unique = null;
    private static Hashtable multiple = new Hashtable();
    private boolean isOSGi = false;
    private boolean master = false;

    private JProp(String fileName) {
        this.readFile(fileName);
    }

    public JProp() {
        this.readFile("jonas");
    }

    private JProp(String fileName, Properties props) {
        this.writePropsToFile(fileName, props);
    }

    private JProp(String fileName, String txt) {
        this.writeXmlToFile(fileName, txt);
    }

    public static JProp getInstance() {
        if (unique == null) {
            unique = new JProp();
        }
        return unique;
    }

    public static JProp getInstance(String fileName) {
        if (!multiple.containsKey(fileName)) {
            multiple.put(fileName, new JProp(fileName));
        }
        return (JProp)multiple.get(fileName);
    }

    public static JProp getInstance(String fileName, Properties props) {
        if (!multiple.containsKey(fileName)) {
            multiple.put(fileName, new JProp(fileName, props));
        }
        return (JProp)multiple.get(fileName);
    }

    public static void removeInstance(String fileName) {
        if (multiple.containsKey(fileName)) {
            multiple.remove(fileName);
        }
    }

    public static void deleteInstance(String fileName) {
        if (multiple.containsKey(fileName)) {
            multiple.remove(fileName);
            if (jonasBase == null) {
                return;
            }
            jonasBase = jonasBase.trim();
            String propFileName = jonasBase + fileSeparator + CONFIG_DIR + fileSeparator + fileName + ".properties";
            File del = new File(propFileName);
            del.delete();
        }
    }

    private void writePropsToFile(String fileName, Properties props) {
        if (jonasBase == null) {
            throw new RuntimeException("JOnAS configuration error: environment property jonas.base not set!");
        }
        if ((jonasBase = jonasBase.trim()).length() <= 0) {
            throw new RuntimeException("JOnAS configuration error: jonas.base is null");
        }
        this.propFileName = jonasBase + fileSeparator + CONFIG_DIR + fileSeparator + fileName + ".properties";
        try {
            FileOutputStream os = new FileOutputStream(this.propFileName);
            props.store(os, "This file is generated by JOnAS");
            os.close();
        }
        catch (FileNotFoundException e) {
            this.propFileName = null;
            throw new RuntimeException("Cannot write config file :" + e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write config file :" + e);
        }
        this.allEnv = this.configFileEnv = (Properties)props.clone();
    }

    private void writeXmlToFile(String fileName, String txt) {
        if (jonasBase == null) {
            throw new RuntimeException("JOnAS configuration error: environment property jonas.base not set!");
        }
        jonasBase = jonasBase.trim();
        this.propFileName = jonasBase + fileSeparator + CONFIG_DIR + fileSeparator + fileName + ".properties";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.propFileName)));
            out.write(txt);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            this.propFileName = null;
            throw new RuntimeException("Cannot write xml configuration file:" + e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write xml configuration file:" + e);
        }
    }

    private void readFile(String fileName) {
        if (jonasBase == null) {
            throw new RuntimeException("JOnAS configuration error: environment property jonas.base not set!");
        }
        if ((jonasBase = jonasBase.trim()).length() <= 0) {
            throw new RuntimeException("JOnAS configuration error: jonas.base is null");
        }
        if (fileName.equals(JONAS_VERSIONS)) {
            this.readVersionFile();
            return;
        }
        String fileFullPathname = jonasBase + fileSeparator + CONFIG_DIR + fileSeparator + fileName;
        if (fileFullPathname.toLowerCase().endsWith(".xml")) {
            this.readXmlFile(fileFullPathname);
        } else {
            this.readPropsFile(fileFullPathname);
        }
    }

    private void readVersionFile() {
        String fileFullPathname = installRoot + fileSeparator + JONAS_VERSIONS;
        try {
            File f = new File(fileFullPathname);
            int length = (int)f.length();
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[length];
            fis.read(buffer);
            fis.close();
            this.versionFileContent = new String(buffer);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find file " + fileFullPathname);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file " + fileFullPathname);
        }
    }

    private void readPropsFile(String fileName) {
        this.propFileName = fileName;
        if (!fileName.endsWith(".properties")) {
            this.propFileName = this.propFileName + ".properties";
        }
        File f = null;
        try {
            f = new File(this.propFileName);
            FileInputStream is = new FileInputStream(f);
            this.configFileEnv.load(is);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find properties for " + this.propFileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties for " + this.propFileName);
        }
        this.allEnv = (Properties)this.configFileEnv.clone();
        if (f.getName().equalsIgnoreCase("jonas.properties")) {
            Enumeration<Object> e = systEnv.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                String value = ((String)systEnv.get(key)).trim();
                this.allEnv.put(key, value);
            }
            if (!systEnv.containsKey(JONAS_NAME)) {
                this.allEnv.put(JONAS_NAME, "jonas");
            }
            String serverName = ((String)this.allEnv.get(JONAS_NAME)).trim();
            if (!this.allEnv.containsKey(DOMAIN_NAME) && !systEnv.containsKey(DOMAIN_NAME)) {
                this.allEnv.put(DOMAIN_NAME, serverName);
            }
        }
        if (this.allEnv.containsKey(JONAS_MASTER) && Boolean.parseBoolean(this.allEnv.getProperty(JONAS_MASTER))) {
            this.setMaster(true);
        }
    }

    private void readXmlFile(String fileName) {
        this.propFileName = fileName;
        try {
            File f = new File(this.propFileName);
            int length = (int)f.length();
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[length];
            fis.read(buffer);
            fis.close();
            this.configFileXml = new String(buffer);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find file " + this.propFileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file " + this.propFileName);
        }
    }

    public static String getInstallRoot() {
        if (installRoot == null) {
            throw new RuntimeException("JOnAS configuration error: System property install.root not set!");
        }
        return installRoot;
    }

    public static String getJonasBase() {
        return jonasBase;
    }

    public static String getWorkDir() {
        return jonasBase + File.separator + "work";
    }

    public static String getConfDir() {
        return jonasBase + File.separator + CONFIG_DIR;
    }

    public String getPropFile() {
        return this.propFileName;
    }

    public Properties getEnv() {
        return this.allEnv;
    }

    public Properties getConfigFileEnv() {
        return this.configFileEnv;
    }

    public String getConfigFileXml() {
        return this.configFileXml;
    }

    public String getVersionFile() {
        return this.versionFileContent;
    }

    public String getValue(String key, String defaultVal) {
        String retProperty = this.allEnv.getProperty(key, defaultVal);
        return retProperty.trim();
    }

    public String getValue(String key) {
        String retProperty = this.allEnv.getProperty(key);
        if (retProperty != null) {
            retProperty = retProperty.trim();
        }
        return retProperty;
    }

    public boolean getValueAsBoolean(String key, boolean def) {
        boolean ret = def;
        String value = this.getValue(key);
        if (value != null && value.equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    public String[] getValueAsArray(String key) {
        String[] res = null;
        String value = this.getValue(key);
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ",");
            res = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                res[i++] = st.nextToken().trim();
            }
        }
        return res;
    }

    public String toString() {
        String s = new String();
        Enumeration<Object> e = this.configFileEnv.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = this.configFileEnv.get(key);
            s = s.concat("   " + key + " = " + value + "\n");
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void env2Ctx(Context ctx) throws Exception {
        Enumeration<?> e = this.configFileEnv.propertyNames();
        String key = null;
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            ctx.bind(key, (Object)this.configFileEnv.getProperty(key, ""));
        }
    }

    public static void main(String[] args) {
        JProp jonasProperties = null;
        try {
            jonasProperties = JProp.getInstance();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(2);
        }
        Enumeration<Object> e = jonasProperties.configFileEnv.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = jonasProperties.configFileEnv.get(key);
            System.out.println(key.toString() + "=" + value.toString());
        }
    }

    public String getDomainName() {
        return this.getValue(DOMAIN_NAME, null);
    }

    public String getServerName() {
        return this.getValue(JONAS_NAME, null);
    }

    public boolean isOSGi() {
        return this.isOSGi;
    }

    public void setOSGi(boolean isOSGi) {
        this.isOSGi = isOSGi;
    }

    public String getVersionsFile() {
        JProp jp = JProp.getInstance(JONAS_VERSIONS);
        return jp.versionFileContent;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }
}

