/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.util.Enumeration;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.work.AbsCleanTask;
import org.ow2.jonas.lib.work.CleanerException;

public class WorkCleaner
extends Thread {
    private static Logger logger = Log.getLogger("org.ow2.jonas.work");
    private static final int SLEEP_TIME = 300000;
    private static WorkCleaner unique = null;
    private Vector taskList = null;

    private WorkCleaner() {
        super("WorkCleaner");
        this.setPriority(1);
        this.taskList = new Vector();
    }

    protected static Logger getLogger() {
        return logger;
    }

    public static synchronized WorkCleaner getInstance() {
        if (unique == null) {
            unique = new WorkCleaner();
        }
        if (WorkCleaner.getLogger().isLoggable(BasicLevel.DEBUG)) {
            WorkCleaner.getLogger().log(BasicLevel.DEBUG, (Object)("getInstance : ->" + unique));
        }
        return unique;
    }

    public synchronized void registerTask(AbsCleanTask absCleanTask) throws CleanerException {
        if (WorkCleaner.getLogger().isLoggable(BasicLevel.DEBUG)) {
            WorkCleaner.getLogger().log(BasicLevel.DEBUG, (Object)"registerTask : called");
        }
        if (this.taskList == null) {
            throw new CleanerException("Can not add an entry, the vector is null");
        }
        if (absCleanTask == null) {
            throw new CleanerException("Can not add a null entry");
        }
        if (!this.taskList.contains(absCleanTask)) {
            this.taskList.add(absCleanTask);
        }
    }

    public synchronized void executeTasks() {
        try {
            AbsCleanTask absCleanTask = null;
            if (WorkCleaner.getLogger().isLoggable(BasicLevel.DEBUG)) {
                WorkCleaner.getLogger().log(BasicLevel.DEBUG, (Object)"executeTasks : wake up");
            }
            Enumeration e = this.taskList.elements();
            while (e.hasMoreElements()) {
                absCleanTask = (AbsCleanTask)e.nextElement();
                absCleanTask.execute();
            }
        }
        catch (CleanerException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (true) {
            this.executeTasks();
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread fail to sleep");
            }
        }
    }
}

