/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleContextImpl;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.ExportedPackageImpl;
import org.apache.felix.framework.ExtensionManager;
import org.apache.felix.framework.FakeURLStreamHandler;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.FindEntriesEnumeration;
import org.apache.felix.framework.GetEntryPathsEnumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.PackageAdminActivator;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StartLevelActivator;
import org.apache.felix.framework.StartLevelImpl;
import org.apache.felix.framework.SystemBundleArchive;
import org.apache.felix.framework.URLHandlersActivator;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.framework.searchpolicy.ModuleDefinition;
import org.apache.felix.framework.searchpolicy.R4SearchPolicy;
import org.apache.felix.framework.searchpolicy.R4SearchPolicyCore;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.ResolveListener;
import org.apache.felix.framework.searchpolicy.URLPolicyImpl;
import org.apache.felix.framework.util.EventDispatcher;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4LibraryClause;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleFactory;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ModuleEvent;
import org.apache.felix.moduleloader.ModuleFactoryImpl;
import org.apache.felix.moduleloader.ModuleImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.startlevel.StartLevel;

public class Felix
extends FelixBundle {
    static SecureAction m_secureAction = new SecureAction();
    private ExtensionManager m_extensionManager;
    private Logger m_logger = null;
    private Map m_configMap = null;
    private Map m_configMutableMap = null;
    private IModuleFactory m_factory = null;
    private R4SearchPolicyCore m_policyCore = null;
    private Object[] m_bundleLock = new Object[0];
    private Map m_installRequestMap = new HashMap();
    private Object[] m_installRequestLock_Priority1 = new Object[0];
    private HashMap m_installedBundleMap = new HashMap();
    private Object[] m_installedBundleLock_Priority2 = new Object[0];
    private FelixBundle[] m_uninstalledBundles = null;
    private Object[] m_uninstalledBundlesLock_Priority3 = new Object[0];
    private int m_activeStartLevel = 0;
    private BundleCache m_cache = null;
    private BundleInfo m_systemBundleInfo = null;
    List m_activatorList = null;
    Map m_activatorContextMap = null;
    private long m_nextId = 1L;
    private Object m_nextIdLock = new Object[0];
    private EventDispatcher m_dispatcher = null;
    private ServiceRegistry m_registry = null;
    private URLStreamHandler m_bundleStreamHandler = null;
    private String m_executionEnvironment = "";
    private Set m_executionEnvironmentCache = new HashSet();
    private Thread m_shutdownThread = null;
    private Comparator m_comparator = null;

    public Felix(Map configMutableMap, List activatorList) {
        this.m_configMutableMap = configMutableMap == null ? new StringMap(false) : configMutableMap;
        this.m_configMap = this.createUnmodifiableMap(this.m_configMutableMap);
        this.m_activatorList = activatorList;
        Object loggerObject = this.m_configMutableMap.get("felix.log.logger");
        this.m_logger = loggerObject instanceof Logger ? (Logger)loggerObject : new Logger((String)this.m_configMutableMap.get("felix.log.level"));
        this.initializeFrameworkProperties();
        try {
            this.m_cache = new BundleCache(this.m_logger, this.m_configMap);
        }
        catch (Exception ex) {
            boolean isEmbedded;
            System.err.println("Error creating bundle cache:");
            ex.printStackTrace();
            String embedded = (String)this.m_configMap.get("felix.embedded.execution");
            boolean bl = isEmbedded = embedded == null ? false : embedded.equals("true");
            if (!isEmbedded) {
                m_secureAction.exit(-1);
            }
            throw new RuntimeException(ex.toString());
        }
        this.m_factory = new ModuleFactoryImpl(this.m_logger);
        this.m_systemBundleInfo = new BundleInfo(this.m_logger, new SystemBundleArchive(this.m_cache), null);
        this.m_extensionManager = new ExtensionManager(this.m_logger, this.m_configMap, this.m_systemBundleInfo);
        this.m_systemBundleInfo.addModule(this.m_factory.createModule("0", this.m_extensionManager));
    }

    private Map createUnmodifiableMap(Map mutableMap) {
        Map result = Collections.unmodifiableMap(mutableMap);
        try {
            result.keySet().iterator();
        }
        catch (NoClassDefFoundError ex) {
            return mutableMap;
        }
        return result;
    }

    BundleInfo getInfo() {
        return this.m_systemBundleInfo;
    }

    public BundleContext getBundleContext() {
        if (this.m_systemBundleInfo != null) {
            return this.m_systemBundleInfo.getBundleContext();
        }
        return null;
    }

    public long getBundleId() {
        return 0L;
    }

    public URL getEntry(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getBundleEntry(this, name);
    }

    public Enumeration getEntryPaths(String path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getBundleEntryPaths(this, path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.findBundleEntries(this, path, filePattern, recurse);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String locale) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this.getBundleHeaders(this, locale);
    }

    public long getLastModified() {
        if (this.m_systemBundleInfo != null) {
            return this.m_systemBundleInfo.getLastModified();
        }
        return -1L;
    }

    public String getLocation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return "System Bundle";
    }

    public URL getResource(String name) {
        return this.getBundleResource(this, name);
    }

    public Enumeration getResources(String name) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getBundleResources(this, name);
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getBundleRegisteredServices(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getBundleServicesInUse(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            block2: for (int i = 0; i < refs.length; ++i) {
                String[] objectClass = (String[])refs[i].getProperty("objectClass");
                if (objectClass == null) continue;
                for (int j = 0; j < objectClass.length; ++j) {
                    try {
                        sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                        result.add(refs[i]);
                        continue block2;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getBundleServicesInUse(this);
    }

    public int getState() {
        return this.m_systemBundleInfo.getState();
    }

    public String getSymbolicName() {
        return "System Bundle";
    }

    public boolean hasPermission(Object obj) {
        return true;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception e) {
                throw new ClassNotFoundException("No permission.", e);
            }
        }
        return this.loadBundleClass(this, name);
    }

    public synchronized void start() throws BundleException {
        if (this.getState() == 32) {
            return;
        }
        if (this.m_systemBundleInfo.getState() != 2) {
            throw new IllegalStateException("Invalid framework state: " + this.m_systemBundleInfo.getState());
        }
        this.m_systemBundleInfo.setState(8);
        this.m_bundleStreamHandler = new URLHandlersBundleStreamHandler(this);
        this.m_registry = new ServiceRegistry(this.m_logger);
        this.m_registry.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                Felix.this.fireServiceEvent(event);
            }
        });
        this.m_policyCore = new R4SearchPolicyCore(this.m_logger, this.m_configMap);
        this.m_policyCore.addResolverListener(new ResolveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleResolved(ModuleEvent event) {
                block8: {
                    FelixBundle bundle = null;
                    try {
                        long id = Util.getBundleIdFromModuleId(event.getModule().getId());
                        if (id <= 0L) break block8;
                        bundle = (FelixBundle)Felix.this.getBundle(id);
                        try {
                            Felix.this.acquireBundleLock(bundle);
                            if (bundle.getInfo().getCurrentModule() == event.getModule()) {
                                if (bundle.getInfo().getState() != 2) {
                                    Felix.this.m_logger.log(2, "Received a resolve event for a bundle that has already been resolved.");
                                } else {
                                    bundle.getInfo().setState(4);
                                    Felix.this.fireBundleEvent(32, bundle);
                                }
                            }
                        }
                        finally {
                            Felix.this.releaseBundleLock(bundle);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            public void moduleUnresolved(ModuleEvent event) {
            }
        });
        this.m_policyCore.setModuleFactory(this.m_factory);
        this.m_dispatcher = EventDispatcher.start(this.m_logger);
        try {
            ExtensionManager cl = this.m_extensionManager;
            cl.setSearchPolicy(new R4SearchPolicy(this.m_policyCore, this.m_systemBundleInfo.getCurrentModule()));
            this.m_factory.setContentLoader(this.m_systemBundleInfo.getCurrentModule(), cl);
            this.m_factory.setSecurityContext(this.m_systemBundleInfo.getCurrentModule(), this.getClass().getProtectionDomain());
            this.m_installedBundleMap.put(this.m_systemBundleInfo.getLocation(), this);
            try {
                this.m_policyCore.resolve(this.m_systemBundleInfo.getCurrentModule());
            }
            catch (ResolveException ex) {
                throw new BundleException("Unresolved package in System Bundle:" + ex.getRequirement());
            }
            this.m_systemBundleInfo.setActivator(new SystemBundleActivator());
            this.m_systemBundleInfo.setBundleContext(new BundleContextImpl(this.m_logger, this, this));
            m_secureAction.startActivator(this.m_systemBundleInfo.getActivator(), this.m_systemBundleInfo.getBundleContext());
        }
        catch (Throwable ex) {
            this.m_factory = null;
            EventDispatcher.shutdown();
            this.m_logger.log(1, "Unable to start system bundle.", ex);
            throw new RuntimeException("Unable to start system bundle.");
        }
        this.m_logger.setSystemBundleContext(this.m_systemBundleInfo.getBundleContext());
        BundleArchive[] archives = null;
        try {
            archives = this.m_cache.getArchives();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Unable to list saved bundles.", ex);
            archives = null;
        }
        FelixBundle bundle = null;
        for (int i = 0; archives != null && i < archives.length; ++i) {
            try {
                this.m_nextId = Math.max(this.m_nextId, archives[i].getId() + 1L);
                if (archives[i].getPersistentState() == 1) {
                    this.m_cache.remove(archives[i]);
                    continue;
                }
                bundle = (FelixBundle)this.installBundle(archives[i].getId(), archives[i].getLocation(), null);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.fireFrameworkEvent(2, this, ex);
                try {
                    this.m_logger.log(1, "Unable to re-install " + archives[i].getLocation(), ex);
                    continue;
                }
                catch (Exception ex2) {
                    this.m_logger.log(1, "Unable to re-install cached bundle.", ex);
                }
            }
        }
        this.m_nextId = Math.max(this.m_nextId, this.loadNextId());
        int startLevel = 1;
        String s = (String)this.m_configMap.get("felix.startlevel.framework");
        if (s != null) {
            try {
                startLevel = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                startLevel = 1;
            }
        }
        this.processAutoProperties();
        try {
            StartLevel sl = (StartLevel)this.getService(this.getBundle(0L), this.getServiceReferences((FelixBundle)this.getBundle(0L), StartLevel.class.getName(), null, true)[0]);
            if (sl instanceof StartLevelImpl) {
                ((StartLevelImpl)sl).setStartLevelAndWait(startLevel);
            } else {
                sl.setStartLevel(startLevel);
            }
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        this.m_systemBundleInfo.setState(32);
        this.fireBundleEvent(2, this);
        this.fireFrameworkEvent(1, this, null);
    }

    public void stop() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.stopBundle(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndWait() {
        Felix felix = this;
        synchronized (felix) {
            if (this.m_systemBundleInfo.getState() == 32) {
                try {
                    this.getBundle(0L).stop();
                }
                catch (BundleException ex) {
                    this.fireFrameworkEvent(2, this, ex);
                    this.m_logger.log(1, "Error stopping system bundle.", ex);
                }
            }
            while (this.m_systemBundleInfo.getState() != 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void uninstall() throws BundleException {
        throw new BundleException("Cannot uninstall the system bundle.");
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        throw new BundleException("System bundle update not implemented yet.");
    }

    public String toString() {
        return this.getSymbolicName() + " [" + this.getBundleId() + "]";
    }

    protected int getStartLevel() {
        return this.m_activeStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFrameworkStartLevel(int requestedLevel) {
        Bundle[] bundles = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            boolean lowering = requestedLevel < this.m_activeStartLevel;
            this.m_activeStartLevel = requestedLevel;
            bundles = this.getBundles();
            Comparator comparator = null;
            comparator = lowering ? new Comparator(){

                public int compare(Object o1, Object o2) {
                    FelixBundle b1 = (FelixBundle)o1;
                    FelixBundle b2 = (FelixBundle)o2;
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) < b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return 1;
                    }
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) > b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return -1;
                    }
                    if (b1.getInfo().getBundleId() < b2.getInfo().getBundleId()) {
                        return 1;
                    }
                    return -1;
                }
            } : new Comparator(){

                public int compare(Object o1, Object o2) {
                    FelixBundle b1 = (FelixBundle)o1;
                    FelixBundle b2 = (FelixBundle)o2;
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) > b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return 1;
                    }
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) < b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return -1;
                    }
                    if (b1.getInfo().getBundleId() > b2.getInfo().getBundleId()) {
                        return 1;
                    }
                    return -1;
                }
            };
            Arrays.sort(bundles, comparator);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                FelixBundle impl = (FelixBundle)bundles[i];
                if (impl.getInfo().getBundleId() == 0L) continue;
                this.acquireBundleLock(impl);
                try {
                    if (impl.getInfo().getPersistentState() == 32 && impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) {
                        try {
                            this.startBundle(impl, false);
                        }
                        catch (Throwable th) {
                            this.fireFrameworkEvent(2, impl, th);
                            this.m_logger.log(1, "Error starting " + impl.getInfo().getLocation(), th);
                        }
                        continue;
                    }
                    if (impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) continue;
                    try {
                        this.stopBundle(impl, false);
                    }
                    catch (Throwable th) {
                        this.fireFrameworkEvent(2, impl, th);
                        this.m_logger.log(1, "Error stopping " + impl.getInfo().getLocation(), th);
                    }
                    continue;
                }
                finally {
                    this.releaseBundleLock(impl);
                }
            }
            if (this.m_systemBundleInfo.getState() == 32) {
                this.fireFrameworkEvent(8, this, null);
            }
            return;
        }
    }

    protected int getInitialBundleStartLevel() {
        String s = (String)this.m_configMap.get("felix.startlevel.bundle");
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return i > 0 ? i : 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void setInitialBundleStartLevel(int startLevel) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be greater than zero.");
        }
        this.m_configMutableMap.put("felix.startlevel.bundle", Integer.toString(startLevel));
    }

    protected int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((FelixBundle)bundle).getInfo().getStartLevel(this.getInitialBundleStartLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleStartLevel(Bundle bundle, int startLevel) {
        Throwable rethrow;
        block11: {
            this.acquireBundleLock((FelixBundle)bundle);
            rethrow = null;
            try {
                if (bundle.getState() == 1) {
                    throw new IllegalArgumentException("Bundle is uninstalled.");
                }
                if (startLevel >= 1) {
                    FelixBundle impl = (FelixBundle)bundle;
                    impl.getInfo().setStartLevel(startLevel);
                    try {
                        if (impl.getInfo().getPersistentState() == 32 && impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) {
                            this.startBundle(impl, false);
                        } else if (impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) > this.m_activeStartLevel) {
                            this.stopBundle(impl, false);
                        }
                        break block11;
                    }
                    catch (Throwable th) {
                        rethrow = th;
                        this.m_logger.log(1, "Error starting/stopping bundle.", th);
                    }
                    break block11;
                }
                this.m_logger.log(2, "Bundle start level must be greater than zero.");
            }
            finally {
                this.releaseBundleLock((FelixBundle)bundle);
            }
        }
        if (rethrow != null) {
            this.fireFrameworkEvent(2, bundle, rethrow);
        }
    }

    protected boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((FelixBundle)bundle).getInfo().getPersistentState() == 32;
    }

    protected String getBundleSymbolicName(FelixBundle bundle) {
        return (String)bundle.getInfo().getCurrentHeader().get("Bundle-SymbolicName");
    }

    protected Dictionary getBundleHeaders(FelixBundle bundle, String locale) {
        return new MapToDictionary(bundle.getInfo().getCurrentLocalizedHeader(locale));
    }

    protected String getBundleLocation(FelixBundle bundle) {
        return bundle.getInfo().getLocation();
    }

    protected URL getBundleResource(FelixBundle bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getResource(name);
    }

    protected Enumeration getBundleResources(FelixBundle bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getResources(name);
    }

    protected URL getBundleEntry(FelixBundle bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getContentLoader().getResourceFromContent(name);
    }

    protected Enumeration getBundleEntryPaths(FelixBundle bundle, String path) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        GetEntryPathsEnumeration enumeration = new GetEntryPathsEnumeration(bundle, path);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    protected Enumeration findBundleEntries(FelixBundle bundle, String path, String filePattern, boolean recurse) {
        this.resolveBundles(new Bundle[]{bundle});
        FindEntriesEnumeration enumeration = new FindEntriesEnumeration(bundle, path, filePattern, recurse);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    protected ServiceReference[] getBundleRegisteredServices(FelixBundle bundle) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        ServiceReference[] refs = this.m_registry.getRegisteredServices(bundle);
        return refs;
    }

    protected ServiceReference[] getBundleServicesInUse(Bundle bundle) {
        ServiceReference[] refs = this.m_registry.getServicesInUse(bundle);
        return refs;
    }

    protected boolean bundleHasPermission(FelixBundle bundle, Object obj) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (System.getSecurityManager() != null) {
            try {
                return obj instanceof Permission ? ((ProtectionDomain)bundle.getInfo().getCurrentModule().getSecurityContext()).implies((Permission)obj) : false;
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Exception while evaluating the permission.", ex);
                return false;
            }
        }
        return true;
    }

    protected Class loadBundleClass(FelixBundle bundle, String name) throws ClassNotFoundException {
        Class clazz = bundle.getInfo().getCurrentModule().getClass(name);
        if (clazz == null) {
            ClassNotFoundException ex = new ClassNotFoundException(name);
            this.fireFrameworkEvent(2, bundle, new BundleException(ex.getMessage()));
            throw ex;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBundle(FelixBundle bundle, boolean record) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._startBundle(bundle, record);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void _startBundle(FelixBundle bundle, boolean record) throws BundleException {
        BundleInfo info;
        if (bundle.getInfo().isExtension()) {
            return;
        }
        if (record) {
            bundle.getInfo().setPersistentStateActive();
        }
        if ((info = bundle.getInfo()).getPersistentState() != 32 || info.getStartLevel(this.getInitialBundleStartLevel()) > this.getStartLevel()) {
            return;
        }
        switch (info.getState()) {
            case 1: {
                throw new IllegalStateException("Cannot start an uninstalled bundle.");
            }
            case 8: 
            case 16: {
                throw new BundleException("Starting a bundle that is starting or stopping is currently not supported.");
            }
            case 32: {
                return;
            }
            case 2: {
                this._resolveBundle(bundle);
            }
            case 4: {
                info.setState(8);
                this.fireBundleEvent(128, bundle);
            }
        }
        try {
            info.setBundleContext(new BundleContextImpl(this.m_logger, this, bundle));
            info.setActivator(this.createBundleActivator(bundle.getInfo()));
            if (bundle.getInfo().getActivator() != null) {
                m_secureAction.startActivator(info.getActivator(), info.getBundleContext());
            }
            info.setState(32);
            this.fireBundleEvent(2, bundle);
        }
        catch (Throwable th2) {
            Exception th2;
            info.setState(4);
            ((BundleContextImpl)info.getBundleContext()).invalidate();
            info.setBundleContext(null);
            this.m_registry.unregisterServices(bundle);
            this.m_registry.ungetServices(bundle);
            this.m_dispatcher.removeListeners(bundle);
            if (th2 instanceof BundleException) {
                throw (BundleException)th2;
            }
            if (th2 instanceof SecurityException) {
                throw (SecurityException)th2;
            }
            if (System.getSecurityManager() != null && th2 instanceof PrivilegedActionException) {
                th2 = ((PrivilegedActionException)th2).getException();
            }
            throw new BundleException("Activator start error.", th2);
        }
    }

    protected void _resolveBundle(FelixBundle bundle) throws BundleException {
        if (System.getSecurityManager() != null) {
            ProtectionDomain pd = (ProtectionDomain)bundle.getInfo().getCurrentModule().getSecurityContext();
            IRequirement[] imports = bundle.getInfo().getCurrentModule().getDefinition().getRequirements();
            ICapability[] exports = bundle.getInfo().getCurrentModule().getDefinition().getCapabilities();
            for (int i = 0; i < exports.length; ++i) {
                PackagePermission perm;
                if (!exports[i].getNamespace().equals("package") || pd.implies(perm = new PackagePermission((String)exports[i].getProperties().get("package"), "export"))) continue;
                throw new AccessControlException("PackagePermission.EXPORT denied for export: " + exports[i].getProperties().get("package"), perm);
            }
        }
        this.verifyExecutionEnvironment(bundle);
        IModule module = bundle.getInfo().getCurrentModule();
        try {
            this.m_policyCore.resolve(module);
        }
        catch (ResolveException ex) {
            if (ex.getModule() != null) {
                throw new BundleException("Unresolved package in bundle " + Util.getBundleIdFromModuleId(ex.getModule().getId()) + ": " + ex.getRequirement());
            }
            throw new BundleException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBundle(FelixBundle bundle, InputStream is) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._updateBundle(bundle, is);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateBundle(FelixBundle bundle, InputStream is) throws BundleException {
        try {
            Throwable rethrow = null;
            BundleInfo info = bundle.getInfo();
            if (info.getState() == 1) {
                throw new IllegalStateException("The bundle is uninstalled.");
            }
            String updateLocation = (String)info.getCurrentHeader().get("Bundle-UpdateLocation");
            if (updateLocation == null) {
                updateLocation = info.getLocation();
            }
            this.stopBundle(bundle, false);
            try {
                BundleArchive archive = this.m_cache.getArchive(info.getBundleId());
                archive.revise(updateLocation, is);
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                    }
                    IModule module = this.createModule(info.getBundleId(), archive.getRevisionCount() - 1, info.getCurrentHeader(), this.createBundleProtectionDomain(archive), bundle.getInfo().isExtension() || this.m_extensionManager.isExtensionBundle(bundle.getInfo().getCurrentHeader()));
                    info.addModule(module);
                    if (!bundle.getInfo().isExtension() && this.m_extensionManager.isExtensionBundle(bundle.getInfo().getCurrentHeader())) {
                        this.m_extensionManager.addExtensionBundle(this, bundle);
                        this.m_factory.refreshModule(this.m_systemBundleInfo.getCurrentModule());
                        bundle.getInfo().setState(4);
                    } else if (bundle.getInfo().isExtension()) {
                        bundle.getInfo().setState(2);
                    }
                }
                catch (Throwable ex) {
                    try {
                        archive.undoRevise();
                    }
                    catch (Exception busted) {
                        this.m_logger.log(1, "Unable to rollback.", busted);
                    }
                    throw ex;
                }
            }
            catch (Throwable ex) {
                this.m_logger.log(1, "Unable to update the bundle.", ex);
                rethrow = ex;
            }
            if (rethrow == null) {
                info.setLastModified(System.currentTimeMillis());
                if (!info.isExtension()) {
                    info.setState(2);
                }
                this.fireBundleEvent(64, bundle);
                ((ModuleImpl)info.getModules()[info.getModules().length - 2]).setRemovalPending(true);
                this.fireBundleEvent(8, bundle);
                boolean used = false;
                IModule[] modules = info.getModules();
                for (int i = 0; !used && i < modules.length; ++i) {
                    IModule[] dependents = ((ModuleImpl)modules[i]).getDependents();
                    for (int j = 0; dependents != null && j < dependents.length && !used; ++j) {
                        if (dependents[j] == modules[i]) continue;
                        used = true;
                    }
                }
                if (!used) {
                    try {
                        this.refreshPackages(new Bundle[]{bundle});
                    }
                    catch (Exception ex) {
                        this.m_logger.log(1, "Unable to immediately purge the bundle revisions.", ex);
                    }
                }
            }
            this.startBundle(bundle, false);
            if (rethrow != null) {
                if (System.getSecurityManager() != null && rethrow instanceof SecurityException) {
                    throw (SecurityException)rethrow;
                }
                throw new BundleException("Update failed.", rethrow);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Unable to close input stream.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle(FelixBundle bundle, boolean record) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._stopBundle(bundle, record);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void _stopBundle(FelixBundle bundle, boolean record) throws BundleException {
        Throwable rethrow = null;
        if (record) {
            bundle.getInfo().setPersistentStateInactive();
        }
        BundleInfo info = bundle.getInfo();
        switch (info.getState()) {
            case 1: {
                throw new IllegalStateException("Cannot stop an uninstalled bundle.");
            }
            case 8: 
            case 16: {
                throw new BundleException("Stopping a bundle that is starting or stopping is currently not supported.");
            }
            case 2: 
            case 4: {
                return;
            }
            case 32: {
                info.setState(16);
                this.fireBundleEvent(256, bundle);
            }
        }
        try {
            String strict;
            boolean isStrict;
            if (info.getActivator() != null) {
                m_secureAction.stopActivator(info.getActivator(), info.getBundleContext());
            }
            boolean bl = isStrict = (strict = (String)this.m_configMap.get("felix.strict.osgi")) == null ? true : strict.equals("true");
            if (!isStrict) {
                try {
                    this.m_cache.getArchive(info.getBundleId()).setActivator(info.getActivator());
                }
                catch (Exception ex) {}
            }
        }
        catch (Throwable th) {
            this.m_logger.log(1, "Error stopping bundle.", th);
            rethrow = th;
        }
        if (info.getBundleId() != 0L) {
            ((BundleContextImpl)info.getBundleContext()).invalidate();
            info.setBundleContext(null);
            this.m_registry.unregisterServices(bundle);
            this.m_registry.ungetServices(bundle);
            this.m_dispatcher.removeListeners(bundle);
            info.setState(4);
            this.fireBundleEvent(4, bundle);
        }
        if (rethrow != null) {
            if (rethrow instanceof BundleException) {
                throw (BundleException)rethrow;
            }
            if (rethrow instanceof SecurityException) {
                throw (SecurityException)rethrow;
            }
            if (System.getSecurityManager() != null && rethrow instanceof PrivilegedActionException) {
                rethrow = ((PrivilegedActionException)rethrow).getException();
            }
            throw new BundleException("Activator stop error.", rethrow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallBundle(FelixBundle bundle) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._uninstallBundle(bundle);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _uninstallBundle(FelixBundle bundle) throws BundleException {
        BundleInfo info = bundle.getInfo();
        if (info.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (bundle.getInfo().isExtension()) {
            bundle.getInfo().setPersistentStateUninstalled();
            bundle.getInfo().setState(2);
            return;
        }
        try {
            this.stopBundle(bundle, true);
        }
        catch (BundleException ex) {
            this.fireFrameworkEvent(2, bundle, ex);
        }
        FelixBundle target = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            target = (FelixBundle)this.m_installedBundleMap.remove(info.getLocation());
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (target != null) {
                target.getInfo().setPersistentStateUninstalled();
                ((ModuleImpl)target.getInfo().getCurrentModule()).setRemovalPending(true);
                this.rememberUninstalledBundle(bundle);
            } else {
                this.m_logger.log(1, "Unable to remove bundle from installed map!");
            }
            info.setState(1);
            info.setLastModified(System.currentTimeMillis());
            this.fireBundleEvent(16, bundle);
            boolean used = false;
            IModule[] modules = info.getModules();
            for (int i = 0; !used && i < modules.length; ++i) {
                IModule[] dependents = ((ModuleImpl)modules[i]).getDependents();
                for (int j = 0; dependents != null && j < dependents.length && !used; ++j) {
                    if (dependents[j] == modules[i]) continue;
                    used = true;
                }
            }
            if (!used) {
                try {
                    this.refreshPackages(new Bundle[]{bundle});
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Unable to immediately garbage collect the bundle.", ex);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequirement(FelixBundle bundle, String s) throws BundleException {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IRequirement[] reqs = ManifestParser.parseImportHeader(s);
            IRequirement[] dynamics = bundle.getInfo().getCurrentModule().getDefinition().getDynamicRequirements();
            if (dynamics == null) {
                dynamics = reqs;
            } else {
                IRequirement[] tmp = new IRequirement[dynamics.length + reqs.length];
                System.arraycopy(dynamics, 0, tmp, 0, dynamics.length);
                System.arraycopy(reqs, 0, tmp, dynamics.length, reqs.length);
                dynamics = tmp;
            }
            ((ModuleDefinition)bundle.getInfo().getCurrentModule().getDefinition()).setDynamicRequirements(dynamics);
        }
    }

    protected String getProperty(String key) {
        String val = (String)this.m_configMap.get(key);
        return val == null ? System.getProperty(key) : val;
    }

    protected Bundle installBundle(String location, InputStream is) throws BundleException {
        return this.installBundle(-1L, location, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Bundle installBundle(long id, String location, InputStream is) throws BundleException {
        FelixBundle bundle;
        block43: {
            bundle = null;
            this.acquireInstallLock(location);
            try {
                boolean isNew;
                block42: {
                    if (this.getState() == 16) throw new BundleException("The framework has been shutdown.");
                    if (this.getState() == 1) {
                        throw new BundleException("The framework has been shutdown.");
                    }
                    bundle = (FelixBundle)this.getBundle(location);
                    if (bundle != null) {
                        FelixBundle felixBundle = bundle;
                        return felixBundle;
                    }
                    boolean bl = isNew = id < 0L;
                    if (isNew) {
                        id = this.getNextId();
                        try {
                            this.m_cache.create(id, location, is);
                        }
                        catch (Exception ex) {
                            throw new BundleException("Unable to cache bundle: " + location, ex);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ex) {
                                this.m_logger.log(1, "Unable to close input stream.", ex);
                            }
                        }
                    }
                    try {
                        if (this.m_cache.getArchive(id).getRevisionCount() > 1) {
                            this.m_cache.getArchive(id).purge();
                        }
                    }
                    catch (Exception ex) {
                        this.m_logger.log(1, "Could not purge bundle.", ex);
                    }
                    try {
                        BundleArchive archive = this.m_cache.getArchive(id);
                        bundle = new BundleImpl(this, this.createBundleInfo(archive, this.m_extensionManager.isExtensionBundle(archive.getRevision(archive.getRevisionCount() - 1).getManifestHeader())));
                        this.verifyExecutionEnvironment(bundle);
                        if (!bundle.getInfo().isExtension()) {
                            SecurityManager sm = System.getSecurityManager();
                            if (sm != null) {
                                sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                            }
                            break block42;
                        }
                        this.m_extensionManager.addExtensionBundle(this, bundle);
                        this.m_factory.refreshModule(this.m_systemBundleInfo.getCurrentModule());
                    }
                    catch (Throwable ex) {
                        if (isNew) {
                            try {
                                this.m_cache.remove(this.m_cache.getArchive(id));
                            }
                            catch (Exception ex1) {
                                this.m_logger.log(1, "Could not remove from cache.", ex1);
                            }
                        }
                        if (bundle != null) {
                            ((ModuleImpl)bundle.getInfo().getCurrentModule()).setRemovalPending(true);
                        }
                        if (System.getSecurityManager() != null && ex instanceof SecurityException) {
                            throw (SecurityException)ex;
                        }
                        ex.printStackTrace();
                        throw new BundleException("Could not create bundle object.", ex);
                    }
                }
                if (isNew) {
                    bundle.getInfo().setStartLevel(this.getInitialBundleStartLevel());
                    bundle.getInfo().setLastModified(System.currentTimeMillis());
                }
                Object[] ex = this.m_installedBundleLock_Priority2;
                // MONITORENTER : this.m_installedBundleLock_Priority2
                this.m_installedBundleMap.put(location, bundle);
                // MONITOREXIT : ex
                if (!bundle.getInfo().isExtension()) break block43;
                FelixBundle systemBundle = (FelixBundle)this.getBundle(0L);
                this.acquireBundleLock(systemBundle);
                try {
                    this.m_extensionManager.startExtensionBundle(this, bundle);
                }
                finally {
                    this.releaseBundleLock(systemBundle);
                }
            }
            finally {
                this.releaseInstallLock(location);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    this.m_logger.log(1, "Unable to close input stream.", ex);
                }
            }
        }
        this.fireBundleEvent(1, bundle);
        return bundle;
    }

    private void verifyExecutionEnvironment(FelixBundle bundle) throws BundleException {
        String bundleEnvironment = (String)bundle.getInfo().getCurrentHeader().get("Bundle-RequiredExecutionEnvironment");
        if (bundleEnvironment != null && !(bundleEnvironment = bundleEnvironment.trim()).equals("") && !this.isMatchingExecutionEnvironment(bundleEnvironment)) {
            throw new BundleException("Execution Environment not supported: " + bundleEnvironment);
        }
    }

    private boolean isMatchingExecutionEnvironment(String bundleEnvironment) {
        String frameworkEnvironment = this.getProperty("org.osgi.framework.executionenvironment");
        if (frameworkEnvironment == null) {
            return true;
        }
        if ("".equals(frameworkEnvironment = frameworkEnvironment.trim())) {
            return true;
        }
        if (!this.m_executionEnvironment.equals(frameworkEnvironment)) {
            this.updateFrameworkExecutionEnvironment(frameworkEnvironment);
        }
        StringTokenizer tokens = new StringTokenizer(bundleEnvironment, ",");
        while (tokens.hasMoreTokens()) {
            if (!this.m_executionEnvironmentCache.contains(tokens.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameworkExecutionEnvironment(String frameworkEnvironment) {
        StringTokenizer tokens = new StringTokenizer(frameworkEnvironment, ",");
        HashSet<String> newSet = new HashSet<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            newSet.add(tokens.nextToken().trim());
        }
        Set set = this.m_executionEnvironmentCache;
        synchronized (set) {
            this.m_executionEnvironment = frameworkEnvironment;
            this.m_executionEnvironmentCache = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle getBundle(String location) {
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (Bundle)this.m_installedBundleMap.get(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle getBundle(long id) {
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            FelixBundle bundle = null;
            Iterator i = this.m_installedBundleMap.values().iterator();
            while (i.hasNext()) {
                bundle = (FelixBundle)i.next();
                if (bundle.getInfo().getBundleId() != id) continue;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return bundle;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            objectArray = this.m_uninstalledBundlesLock_Priority3;
            synchronized (this.m_uninstalledBundlesLock_Priority3) {
                for (int i2 = 0; this.m_uninstalledBundles != null && i2 < this.m_uninstalledBundles.length; ++i2) {
                    if (this.m_uninstalledBundles[i2].getInfo().getBundleId() != id) continue;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return this.m_uninstalledBundles[i2];
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle[] getBundles() {
        if (this.m_comparator == null) {
            this.m_comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Bundle b1 = (Bundle)o1;
                    Bundle b2 = (Bundle)o2;
                    if (b1.getBundleId() > b2.getBundleId()) {
                        return 1;
                    }
                    if (b1.getBundleId() < b2.getBundleId()) {
                        return -1;
                    }
                    return 0;
                }
            };
        }
        Bundle[] bundles = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            if (this.m_installedBundleMap.size() == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            bundles = new Bundle[this.m_installedBundleMap.size()];
            int counter = 0;
            Iterator i = this.m_installedBundleMap.values().iterator();
            while (i.hasNext()) {
                bundles[counter++] = (Bundle)i.next();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Arrays.sort(bundles, this.m_comparator);
            return bundles;
        }
    }

    protected void addBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.addListener(bundle, BundleListener.class, l, null);
    }

    protected void removeBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.removeListener(bundle, BundleListener.class, l);
    }

    protected void addServiceListener(Bundle bundle, ServiceListener l, String f) throws InvalidSyntaxException {
        this.m_dispatcher.addListener(bundle, ServiceListener.class, l, f == null ? null : new FilterImpl(this.m_logger, f));
    }

    protected void removeServiceListener(Bundle bundle, ServiceListener l) {
        this.m_dispatcher.removeListener(bundle, ServiceListener.class, l);
    }

    protected void addFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.addListener(bundle, FrameworkListener.class, l, null);
    }

    protected void removeFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.removeListener(bundle, FrameworkListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistration registerService(FelixBundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        if (classNames == null) {
            throw new NullPointerException("Service class names cannot be null.");
        }
        if (svcObj == null) {
            throw new IllegalArgumentException("Service object cannot be null.");
        }
        this.acquireBundleLock(bundle);
        ServiceRegistration reg = null;
        try {
            BundleInfo info = bundle.getInfo();
            if ((info.getState() & 0x28) == 0) {
                throw new IllegalStateException("Can only register services while bundle is active or activating.");
            }
            if (!(svcObj instanceof ServiceFactory)) {
                for (int i = 0; i < classNames.length; ++i) {
                    Class clazz = Util.loadClassUsingClass(svcObj.getClass(), classNames[i]);
                    if (clazz == null) {
                        throw new IllegalArgumentException("Cannot cast service: " + classNames[i]);
                    }
                    if (clazz.isAssignableFrom(svcObj.getClass())) continue;
                    throw new IllegalArgumentException("Service object is not an instance of \"" + classNames[i] + "\".");
                }
            }
            reg = this.m_registry.registerService(bundle, classNames, svcObj, dict);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        return reg;
    }

    protected ServiceReference[] getServiceReferences(FelixBundle bundle, String className, String expr, boolean checkAssignable) throws InvalidSyntaxException {
        FilterImpl filter = null;
        if (expr != null) {
            filter = new FilterImpl(this.m_logger, expr);
        }
        List refList = this.m_registry.getServiceReferences(className, filter);
        if (checkAssignable) {
            for (int refIdx = 0; refList != null && refIdx < refList.size(); ++refIdx) {
                ServiceReference ref = (ServiceReference)refList.get(refIdx);
                if (Util.isServiceAssignable(bundle, ref)) continue;
                refList.remove(refIdx);
                --refIdx;
            }
        }
        if (refList.size() > 0) {
            return refList.toArray(new ServiceReference[refList.size()]);
        }
        return null;
    }

    protected ServiceReference[] getAllowedServiceReferences(FelixBundle bundle, String className, String expr, boolean checkAssignable) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getServiceReferences(bundle, className, expr, checkAssignable);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || refs == null) {
            return refs;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        block2: for (int i = 0; i < refs.length; ++i) {
            String[] objectClass = (String[])refs[i].getProperty("objectClass");
            if (objectClass == null) continue;
            for (int j = 0; j < objectClass.length; ++j) {
                try {
                    sm.checkPermission(new ServicePermission(objectClass[j], "get"));
                    result.add(refs[i]);
                    continue block2;
                }
                catch (Exception ex) {
                    continue;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    protected Object getService(Bundle bundle, ServiceReference ref) {
        String[] objectClass = (String[])ref.getProperty("objectClass");
        if (objectClass == null) {
            return null;
        }
        return this.m_registry.getService(bundle, ref);
    }

    protected boolean ungetService(Bundle bundle, ServiceReference ref) {
        return this.m_registry.ungetService(bundle, ref);
    }

    protected File getDataFile(FelixBundle bundle, String s) {
        if (bundle.getInfo().getState() != 32 && bundle.getInfo().getState() != 8 && bundle.getInfo().getState() != 16 && !bundle.getInfo().isExtension()) {
            throw new IllegalStateException("Only active bundles can create files.");
        }
        try {
            return this.m_cache.getArchive(bundle.getInfo().getBundleId()).getDataFile(s);
        }
        catch (Exception ex) {
            this.m_logger.log(1, ex.getMessage());
            return null;
        }
    }

    protected Bundle getBundle(Class clazz) {
        if (clazz.getClassLoader() instanceof ContentClassLoader) {
            IContentLoader contentLoader = ((ContentClassLoader)clazz.getClassLoader()).getContentLoader();
            IModule[] modules = this.m_factory.getModules();
            for (int i = 0; i < modules.length; ++i) {
                if (modules[i].getContentLoader() != contentLoader) continue;
                long id = Util.getBundleIdFromModuleId(modules[i].getId());
                return this.getBundle(id);
            }
        }
        return this.getInfo().getCurrentModule().getClass(clazz.getName()) == clazz ? this : null;
    }

    protected ExportedPackage[] getExportedPackages(String pkgName) {
        R4SearchPolicyCore.PackageSource[] exporters = this.m_policyCore.getInUseCandidates(new Requirement("package", null, null, new R4Attribute[]{new R4Attribute("package", pkgName, false)}));
        if (exporters != null) {
            ArrayList<ExportedPackageImpl> pkgs = new ArrayList<ExportedPackageImpl>();
            Requirement req = new Requirement("package", null, null, new R4Attribute[]{new R4Attribute("package", pkgName, false)});
            for (int pkgIdx = 0; pkgIdx < exporters.length; ++pkgIdx) {
                FelixBundle bundle = (FelixBundle)this.getBundle(Util.getBundleIdFromModuleId(exporters[pkgIdx].m_module.getId()));
                IModule[] modules = bundle.getInfo().getModules();
                for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
                    ICapability[] ec = modules[modIdx].getDefinition().getCapabilities();
                    for (int i = 0; ec != null && i < ec.length; ++i) {
                        if (!ec[i].getNamespace().equals(req.getNamespace()) || !req.isSatisfied(ec[i])) continue;
                        pkgs.add(new ExportedPackageImpl(this, bundle, modules[modIdx], (Capability)ec[i]));
                    }
                }
            }
            return pkgs.isEmpty() ? null : pkgs.toArray(new ExportedPackage[pkgs.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExportedPackage[] getExportedPackages(Bundle b) {
        ArrayList list = new ArrayList();
        if (b != null) {
            FelixBundle bundle = (FelixBundle)b;
            this.getExportedPackages(bundle, list);
            return list.toArray(new ExportedPackage[list.size()]);
        }
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            Object[] objectArray2 = this.m_uninstalledBundlesLock_Priority3;
            synchronized (this.m_uninstalledBundlesLock_Priority3) {
                FelixBundle bundle;
                int bundleIdx;
                for (bundleIdx = 0; this.m_uninstalledBundles != null && bundleIdx < this.m_uninstalledBundles.length; ++bundleIdx) {
                    bundle = this.m_uninstalledBundles[bundleIdx];
                    this.getExportedPackages(bundle, list);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                Bundle[] bundles = this.getBundles();
                for (bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                    bundle = (FelixBundle)bundles[bundleIdx];
                    this.getExportedPackages(bundle, list);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return list.toArray(new ExportedPackage[list.size()]);
            }
        }
    }

    private void getExportedPackages(FelixBundle bundle, List list) {
        IModule[] modules = bundle.getInfo().getModules();
        for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
            ICapability[] caps = modules[modIdx].getDefinition().getCapabilities();
            if (caps == null || caps.length <= 0) continue;
            for (int capIdx = 0; capIdx < caps.length; ++capIdx) {
                if (!caps[capIdx].getNamespace().equals("package")) continue;
                R4SearchPolicyCore.PackageSource[] inUseModules = this.m_policyCore.getInUseCandidates(new Requirement("package", null, null, new R4Attribute[]{new R4Attribute("package", ((Capability)caps[capIdx]).getPackageName(), false)}));
                for (int i = 0; inUseModules != null && i < inUseModules.length; ++i) {
                    if (inUseModules[i].m_module != modules[modIdx]) continue;
                    list.add(new ExportedPackageImpl(this, bundle, modules[modIdx], (Capability)caps[capIdx]));
                }
            }
        }
    }

    protected Bundle[] getDependentBundles(FelixBundle exporter) {
        BundleInfo exporterInfo = exporter.getInfo();
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        IModule[] modules = exporterInfo.getModules();
        for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
            IModule[] dependents = ((ModuleImpl)modules[modIdx]).getDependents();
            for (int depIdx = 0; dependents != null && depIdx < dependents.length; ++depIdx) {
                Bundle b = this.getBundle(Util.getBundleIdFromModuleId(dependents[depIdx].getId()));
                list.add(b);
            }
        }
        if (list.size() > 0) {
            return list.toArray(new Bundle[list.size()]);
        }
        return null;
    }

    protected Bundle[] getImportingBundles(ExportedPackage ep) {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        FelixBundle exporter = (FelixBundle)ep.getExportingBundle();
        IModule[] expModules = exporter.getInfo().getModules();
        for (int expIdx = 0; expModules != null && expIdx < expModules.length; ++expIdx) {
            IModule[] depModules = ((ModuleImpl)expModules[expIdx]).getDependents();
            for (int depIdx = 0; depModules != null && depIdx < depModules.length; ++depIdx) {
                IWire wire = Util.getWire(depModules[depIdx], ep.getName());
                if (wire == null || !expModules[expIdx].equals(wire.getExporter()) || !wire.getRequirement().isSatisfied(new Capability("package", null, new R4Attribute[]{new R4Attribute("package", ep.getName(), false), new R4Attribute("version", ep.getVersion(), false)}))) continue;
                list.add(this.getBundle(Util.getBundleIdFromModuleId(depModules[depIdx].getId())));
            }
        }
        if (list.size() > 0) {
            return list.toArray(new Bundle[list.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveBundles(Bundle[] targets) {
        FelixBundle[] bundles = this.acquireBundleResolveLocks(targets);
        try {
            boolean result = true;
            if (bundles != null) {
                for (int i = 0; i < bundles.length; ++i) {
                    try {
                        this._resolveBundle(bundles[i]);
                        continue;
                    }
                    catch (BundleException ex) {
                        result = false;
                        this.m_logger.log(2, "Unable to resolve bundle " + bundles[i].getBundleId(), ex);
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.releaseBundleLocks(bundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(Bundle[] targets) {
        int i;
        FelixBundle[] bundles = this.acquireBundleRefreshLocks(targets);
        boolean restart = false;
        Bundle systemBundle = this.getBundle(0L);
        for (i = 0; bundles != null && !restart && i < bundles.length; ++i) {
            if (bundles[i].getInfo().isExtension()) {
                restart = true;
                continue;
            }
            if (systemBundle != bundles[i]) continue;
            Bundle[] allBundles = this.getBundles();
            for (int j = 0; !restart && j < allBundles.length; ++j) {
                if (!((FelixBundle)allBundles[j]).getInfo().isExtension() || allBundles[j].getState() != 2) continue;
                restart = true;
            }
        }
        if (restart) {
            this.m_logger.log(2, "Framework restart not implemented.");
        }
        for (i = 0; bundles != null && i < bundles.length; ++i) {
            this.forgetUninstalledBundle(bundles[i]);
        }
        try {
            if (bundles != null) {
                int i2;
                RefreshHelper[] helpers = new RefreshHelper[bundles.length];
                for (i2 = 0; i2 < bundles.length; ++i2) {
                    if (bundles[i2].getInfo().isExtension()) continue;
                    helpers[i2] = new RefreshHelper(bundles[i2]);
                }
                for (i2 = 0; i2 < helpers.length; ++i2) {
                    if (helpers[i2] == null) continue;
                    helpers[i2].stop();
                    helpers[i2].purgeOrRemove();
                    helpers[i2].reinitialize();
                }
                for (i2 = 0; i2 < helpers.length; ++i2) {
                    if (helpers[i2] == null) continue;
                    helpers[i2].restart();
                }
            }
        }
        finally {
            this.releaseBundleLocks(bundles);
        }
        this.fireFrameworkEvent(4, this, null);
    }

    private void populateImportGraph(FelixBundle exporter, Map map) {
        Bundle[] importers = this.getDependentBundles(exporter);
        for (int impIdx = 0; importers != null && impIdx < importers.length; ++impIdx) {
            if (map.containsKey(importers[impIdx])) continue;
            map.put(importers[impIdx], importers[impIdx]);
            this.populateImportGraph((FelixBundle)importers[impIdx], map);
        }
    }

    private BundleInfo createBundleInfo(BundleArchive archive, boolean isExtension) throws Exception {
        Map headerMap = null;
        try {
            headerMap = archive.getRevision(archive.getRevisionCount() - 1).getManifestHeader();
        }
        catch (Exception ex) {
            throw new BundleException("Unable to read JAR manifest.", ex);
        }
        if (headerMap == null) {
            throw new BundleException("Unable to read JAR manifest header.");
        }
        IModule module = this.createModule(archive.getId(), archive.getRevisionCount() - 1, headerMap, this.createBundleProtectionDomain(archive), isExtension);
        BundleInfo info = new BundleInfo(this.m_logger, archive, module);
        info.setExtension(isExtension);
        return info;
    }

    private ProtectionDomain createBundleProtectionDomain(BundleArchive archive) throws Exception {
        FakeURLStreamHandler handler = new FakeURLStreamHandler();
        URL context = new URL(null, "location:", handler);
        CodeSource codesource = new CodeSource(m_secureAction.createURL(context, archive.getLocation(), handler), (Certificate[])null);
        Permissions allPerms = new Permissions();
        allPerms.add(new AllPermission());
        ProtectionDomain pd = new ProtectionDomain(codesource, allPerms);
        return pd;
    }

    private IModule createModule(long targetId, int revision, Map headerMap, Object securityContext, boolean isExtensionBundle) throws Exception {
        ManifestParser mp = new ManifestParser(this.m_logger, this.m_configMap, headerMap);
        if (mp.getManifestVersion().equals("2")) {
            Version bundleVersion = mp.getBundleVersion();
            bundleVersion = bundleVersion == null ? Version.emptyVersion : bundleVersion;
            String symName = mp.getSymbolicName();
            Bundle[] bundles = this.getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                long id = ((FelixBundle)bundles[i]).getInfo().getBundleId();
                String sym = (String)((FelixBundle)bundles[i]).getInfo().getCurrentHeader().get("Bundle-SymbolicName");
                Version ver = Version.parseVersion((String)((FelixBundle)bundles[i]).getInfo().getCurrentHeader().get("Bundle-Version"));
                if (!symName.equals(sym) || !bundleVersion.equals(ver) || targetId == id) continue;
                throw new BundleException("Bundle symbolic name and version are not unique.");
            }
        }
        ModuleDefinition md = new ModuleDefinition(isExtensionBundle ? null : mp.getCapabilities(), mp.getRequirements(), mp.getDynamicRequirements(), mp.getLibraries(this.m_cache.getArchive(targetId).getRevision(revision)));
        IModule module = this.m_factory.createModule(Long.toString(targetId) + "." + Integer.toString(revision), md);
        this.m_factory.setSecurityContext(module, securityContext);
        ContentLoaderImpl contentLoader = new ContentLoaderImpl(this.m_logger, this.m_cache.getArchive(targetId).getRevision(revision).getContent(), this.m_cache.getArchive(targetId).getRevision(revision).getContentPath(), (ProtectionDomain)module.getSecurityContext());
        contentLoader.setSearchPolicy(new R4SearchPolicy(this.m_policyCore, module));
        contentLoader.setURLPolicy(new URLPolicyImpl(this.m_logger, this.m_bundleStreamHandler, module));
        this.m_factory.setContentLoader(module, contentLoader);
        return module;
    }

    private BundleActivator createBundleActivator(BundleInfo info) throws Exception {
        BundleArchive ba;
        Map headerMap;
        String className;
        boolean isStrict;
        BundleActivator activator = null;
        String strict = (String)this.m_configMap.get("felix.strict.osgi");
        boolean bl = isStrict = strict == null ? true : strict.equals("true");
        if (!isStrict) {
            try {
                activator = this.m_cache.getArchive(info.getBundleId()).getActivator(info.getCurrentModule());
            }
            catch (Exception ex) {
                activator = null;
            }
        }
        if (activator == null && (className = (String)(headerMap = (ba = this.m_cache.getArchive(info.getBundleId())).getRevision(ba.getRevisionCount() - 1).getManifestHeader()).get("Bundle-Activator")) != null) {
            className = className.trim();
            Class clazz = info.getCurrentModule().getClass(className);
            if (clazz == null) {
                throw new BundleException("Not found: " + className, new ClassNotFoundException(className));
            }
            activator = (BundleActivator)clazz.newInstance();
        }
        return activator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeBundle(FelixBundle bundle) throws Exception {
        this.acquireBundleLock(bundle);
        try {
            BundleInfo info = bundle.getInfo();
            IModule[] modules = info.getModules();
            for (int i = 0; i < modules.length; ++i) {
                this.m_factory.removeModule(modules[i]);
            }
            this.m_cache.getArchive(info.getBundleId()).purge();
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void garbageCollectBundle(FelixBundle bundle) throws Exception {
        IModule[] modules = bundle.getInfo().getModules();
        for (int i = 0; i < modules.length; ++i) {
            this.m_factory.removeModule(modules[i]);
        }
        this.m_cache.remove(this.m_cache.getArchive(bundle.getInfo().getBundleId()));
    }

    private void fireFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        this.m_dispatcher.fireFrameworkEvent(new FrameworkEvent(type, bundle, throwable));
    }

    private void fireBundleEvent(int type, Bundle bundle) {
        this.m_dispatcher.fireBundleEvent(new BundleEvent(type, bundle));
    }

    private void fireServiceEvent(ServiceEvent event) {
        this.m_dispatcher.fireServiceEvent(event);
    }

    private void initializeFrameworkProperties() {
        this.m_configMutableMap.put("org.osgi.framework.version", "1.3");
        this.m_configMutableMap.put("org.osgi.framework.vendor", "Apache Software Foundation");
        this.m_configMutableMap.put("org.osgi.framework.language", System.getProperty("user.language"));
        this.m_configMutableMap.put("org.osgi.framework.os.version", System.getProperty("os.version"));
        String s = null;
        s = R4LibraryClause.normalizeOSName(System.getProperty("os.name"));
        this.m_configMutableMap.put("org.osgi.framework.os.name", s);
        s = R4LibraryClause.normalizeProcessor(System.getProperty("os.arch"));
        this.m_configMutableMap.put("org.osgi.framework.processor", s);
        this.m_configMutableMap.put("felix.version", Felix.getFrameworkVersion());
    }

    private static String getFrameworkVersion() {
        Properties props = new Properties();
        InputStream in = Felix.class.getResourceAsStream("Felix.properties");
        try {
            props.load(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        StringBuffer sb = new StringBuffer(props.getProperty("felix.version", "unknown"));
        if (sb.toString().indexOf("-") >= 0) {
            sb.setCharAt(sb.toString().indexOf("-"), '.');
        }
        return sb.toString();
    }

    private void processAutoProperties() {
        FelixBundle b;
        String location;
        StringTokenizer st;
        int startLevel;
        String key;
        Iterator i = this.m_configMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("felix.auto.install")) continue;
            startLevel = this.getInitialBundleStartLevel();
            if (!key.equals("felix.auto.install")) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    this.m_logger.log(1, "Invalid property: " + key);
                }
            }
            if ((st = new StringTokenizer((String)this.m_configMap.get(key), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = this.nextLocation(st)) == null) continue;
                try {
                    b = (FelixBundle)this.installBundle(location, null);
                    b.getInfo().setStartLevel(startLevel);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties install.", ex);
                }
            } while (location != null);
        }
        i = this.m_configMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("felix.auto.start")) continue;
            startLevel = this.getInitialBundleStartLevel();
            if (!key.equals("felix.auto.start")) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    this.m_logger.log(1, "Invalid property: " + key);
                }
            }
            if ((st = new StringTokenizer((String)this.m_configMap.get(key), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = this.nextLocation(st)) == null) continue;
                try {
                    b = (FelixBundle)this.installBundle(location, null);
                    b.getInfo().setStartLevel(startLevel);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties install.", ex);
                }
            } while (location != null);
        }
        i = this.m_configMap.keySet().iterator();
        while (i.hasNext()) {
            StringTokenizer st2;
            key = (String)i.next();
            if (!key.startsWith("felix.auto.start") || (st2 = new StringTokenizer((String)this.m_configMap.get(key), "\" ", true)).countTokens() <= 0) continue;
            String location2 = null;
            do {
                if ((location2 = this.nextLocation(st2)) == null) continue;
                try {
                    FelixBundle bundle = (FelixBundle)this.installBundle(location2, null);
                    if (bundle == null) continue;
                    this.startBundle(bundle, true);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties start.", ex);
                }
            } while (location2 != null);
        }
    }

    private String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            InputStream is = null;
            BufferedReader br = null;
            try {
                File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                is = m_secureAction.getFileInputStream(file);
                br = new BufferedReader(new InputStreamReader(is));
                long l = Long.parseLong(br.readLine());
                return l;
            }
            catch (FileNotFoundException ex) {
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Unable to initialize next bundle identifier from persistent storage.", ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", ex);
                }
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            long id = this.m_nextId++;
            OutputStream os = null;
            BufferedWriter bw = null;
            try {
                File file = this.m_cache.getSystemBundleDataFile("bundle.id");
                os = m_secureAction.getFileOutputStream(file);
                bw = new BufferedWriter(new OutputStreamWriter(os));
                String s = Long.toString(this.m_nextId);
                bw.write(s, 0, s.length());
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Unable to save next bundle identifier to persistent storage.", ex);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(2, "Unable to close next bundle identifier file.", ex);
                }
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberUninstalledBundle(FelixBundle bundle) {
        Object[] objectArray = this.m_uninstalledBundlesLock_Priority3;
        synchronized (this.m_uninstalledBundlesLock_Priority3) {
            for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.length; ++i) {
                if (this.m_uninstalledBundles[i] != bundle) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.m_uninstalledBundles != null) {
                FelixBundle[] newBundles = new FelixBundle[this.m_uninstalledBundles.length + 1];
                System.arraycopy(this.m_uninstalledBundles, 0, newBundles, 0, this.m_uninstalledBundles.length);
                newBundles[this.m_uninstalledBundles.length] = bundle;
                this.m_uninstalledBundles = newBundles;
            } else {
                this.m_uninstalledBundles = new FelixBundle[]{bundle};
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetUninstalledBundle(FelixBundle bundle) {
        Object[] objectArray = this.m_uninstalledBundlesLock_Priority3;
        synchronized (this.m_uninstalledBundlesLock_Priority3) {
            if (this.m_uninstalledBundles == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int idx = -1;
            for (int i = 0; i < this.m_uninstalledBundles.length; ++i) {
                if (this.m_uninstalledBundles[i] != bundle) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (this.m_uninstalledBundles.length - 1 == 0) {
                    this.m_uninstalledBundles = new FelixBundle[0];
                } else {
                    FelixBundle[] newBundles = new FelixBundle[this.m_uninstalledBundles.length - 1];
                    System.arraycopy(this.m_uninstalledBundles, 0, newBundles, 0, idx);
                    if (idx < newBundles.length) {
                        System.arraycopy(this.m_uninstalledBundles, idx + 1, newBundles, idx, newBundles.length - idx);
                    }
                    this.m_uninstalledBundles = newBundles;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireInstallLock(String location) throws BundleException {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            while (this.m_installRequestMap.get(location) != null) {
                try {
                    this.m_installRequestLock_Priority1.wait();
                }
                catch (InterruptedException ex) {
                    throw new BundleException("Unable to install, thread interrupted.");
                }
            }
            this.m_installRequestMap.put(location, location);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInstallLock(String location) {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            this.m_installRequestMap.remove(location);
            this.m_installRequestLock_Priority1.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireBundleLock(FelixBundle bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            while (!bundle.getInfo().isLockable()) {
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            bundle.getInfo().lock();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireBundleLockOrFail(FelixBundle bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            if (!bundle.getInfo().isLockable()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            bundle.getInfo().lock();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBundleLock(FelixBundle bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundle.getInfo().unlock();
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected FelixBundle[] acquireBundleResolveLocks(Bundle[] targets) {
        FelixBundle[] bundles = null;
        if (targets != null) {
            bundles = new FelixBundle[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                bundles[i] = (FelixBundle)targets[i];
            }
        }
        Object[] objectArray = this.m_bundleLock;
        // MONITORENTER : this.m_bundleLock
        boolean success = false;
        while (true) {
            if (success) {
                // MONITOREXIT : objectArray
                return bundles;
            }
            if (targets == null) {
                ArrayList<FelixBundle> list = new ArrayList<FelixBundle>();
                Object[] objectArray2 = this.m_installedBundleLock_Priority2;
                // MONITORENTER : this.m_installedBundleLock_Priority2
                Iterator iter = this.m_installedBundleMap.values().iterator();
                while (iter.hasNext()) {
                    FelixBundle bundle = (FelixBundle)iter.next();
                    if (bundle.getInfo().getState() != 2) continue;
                    list.add(bundle);
                }
                // MONITOREXIT : objectArray2
                if (list.size() > 0) {
                    bundles = list.toArray(new FelixBundle[list.size()]);
                }
            }
            boolean lockable = true;
            if (bundles != null) {
                int i;
                for (i = 0; lockable && i < bundles.length; ++i) {
                    lockable = bundles[i].getInfo().isLockable();
                }
                if (lockable) {
                    for (i = 0; i < bundles.length; ++i) {
                        bundles[i].getInfo().lock();
                    }
                    success = true;
                    continue;
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {}
                continue;
            }
            success = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected FelixBundle[] acquireBundleRefreshLocks(Bundle[] targets) {
        FelixBundle[] bundles = null;
        Object[] objectArray = this.m_bundleLock;
        // MONITORENTER : this.m_bundleLock
        boolean success = false;
        while (true) {
            if (success) {
                // MONITOREXIT : objectArray
                return bundles;
            }
            Bundle[] newTargets = targets;
            if (newTargets == null) {
                ArrayList<FelixBundle> list = new ArrayList<FelixBundle>();
                Object[] objectArray2 = this.m_uninstalledBundlesLock_Priority3;
                // MONITORENTER : this.m_uninstalledBundlesLock_Priority3
                for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.length; ++i) {
                    list.add(this.m_uninstalledBundles[i]);
                }
                // MONITOREXIT : objectArray2
                objectArray2 = this.m_installedBundleLock_Priority2;
                // MONITORENTER : this.m_installedBundleLock_Priority2
                Iterator iter = this.m_installedBundleMap.values().iterator();
                while (iter.hasNext()) {
                    FelixBundle bundle = (FelixBundle)iter.next();
                    if (bundle.getInfo().getArchive().getRevisionCount() <= 1) continue;
                    list.add(bundle);
                }
                // MONITOREXIT : objectArray2
                if (list.size() > 0) {
                    newTargets = list.toArray(new Bundle[list.size()]);
                }
            }
            if (newTargets != null) {
                HashMap<FelixBundle, FelixBundle> map = new HashMap<FelixBundle, FelixBundle>();
                for (int targetIdx = 0; targetIdx < newTargets.length; ++targetIdx) {
                    FelixBundle target = (FelixBundle)newTargets[targetIdx];
                    map.put(target, target);
                    this.populateImportGraph(target, map);
                }
                bundles = map.values().toArray(new FelixBundle[map.size()]);
            }
            boolean lockable = true;
            if (bundles != null) {
                int i;
                for (i = 0; lockable && i < bundles.length; ++i) {
                    lockable = bundles[i].getInfo().isLockable();
                }
                if (lockable) {
                    for (i = 0; i < bundles.length; ++i) {
                        bundles[i].getInfo().lock();
                    }
                    success = true;
                    continue;
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {}
                continue;
            }
            success = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBundleLocks(FelixBundle[] bundles) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                bundles[i].getInfo().unlock();
            }
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private class RefreshHelper {
        private FelixBundle m_bundle = null;

        public RefreshHelper(Bundle bundle) {
            this.m_bundle = (FelixBundle)bundle;
        }

        public void stop() {
            if (this.m_bundle.getInfo().getState() == 32) {
                try {
                    Felix.this.stopBundle(this.m_bundle, false);
                }
                catch (BundleException ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }

        public void purgeOrRemove() {
            try {
                BundleInfo info = this.m_bundle.getInfo();
                info.setStale();
                if (info.getState() == 1) {
                    Felix.this.garbageCollectBundle(this.m_bundle);
                    this.m_bundle = null;
                } else {
                    Felix.this.purgeBundle(this.m_bundle);
                }
            }
            catch (Exception ex) {
                Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
            }
        }

        public void reinitialize() {
            if (this.m_bundle != null) {
                try {
                    BundleInfo info = this.m_bundle.getInfo();
                    BundleInfo newInfo = Felix.this.createBundleInfo(info.getArchive(), info.isExtension());
                    newInfo.syncLock(info);
                    ((BundleImpl)this.m_bundle).setInfo(newInfo);
                    Felix.this.fireBundleEvent(64, this.m_bundle);
                }
                catch (Exception ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }

        public void restart() {
            if (this.m_bundle != null) {
                try {
                    Felix.this.startBundle(this.m_bundle, false);
                }
                catch (BundleException ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }
    }

    class SystemBundleActivator
    implements BundleActivator,
    Runnable {
        SystemBundleActivator() {
        }

        public void start(BundleContext context) throws Exception {
            if (Felix.this.m_activatorList == null) {
                Felix.this.m_activatorList = new ArrayList();
            }
            Felix.this.m_activatorList.add(new PackageAdminActivator(Felix.this));
            Felix.this.m_activatorList.add(new StartLevelActivator(Felix.this.m_logger, Felix.this));
            Felix.this.m_activatorList.add(new URLHandlersActivator(Felix.this.m_configMap, Felix.this));
            for (int i = 0; i < Felix.this.m_activatorList.size(); ++i) {
                m_secureAction.startActivator((BundleActivator)Felix.this.m_activatorList.get(i), context);
            }
        }

        public void stop(BundleContext context) {
            if (Felix.this.m_shutdownThread == null) {
                Felix.this.m_shutdownThread = new Thread((Runnable)this, "FelixShutdown");
                Felix.this.m_shutdownThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean isEmbedded;
            FelixBundle bundle;
            int i;
            Felix felix = Felix.this;
            synchronized (felix) {
                if (Felix.this.m_systemBundleInfo.getState() != 16) {
                    return;
                }
            }
            try {
                StartLevelImpl sl = (StartLevelImpl)Felix.this.getService(Felix.this, Felix.this.getServiceReferences(Felix.this, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = Felix.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null, true)[0]);
                sl.setStartLevelAndWait(0);
            }
            catch (InvalidSyntaxException ex) {
                // empty catch block
            }
            Bundle[] bundles = Felix.this.getBundles();
            for (i = 0; i < bundles.length; ++i) {
                bundle = (FelixBundle)bundles[i];
                if (bundle.getInfo().getArchive().getRevisionCount() <= 1) continue;
                try {
                    Felix.this.purgeBundle(bundle);
                    continue;
                }
                catch (Exception ex) {
                    Felix.this.fireFrameworkEvent(2, bundle, ex);
                    Felix.this.m_logger.log(1, "Unable to purge bundle " + bundle.getInfo().getLocation(), ex);
                }
            }
            for (i = 0; Felix.this.m_uninstalledBundles != null && i < Felix.this.m_uninstalledBundles.length; ++i) {
                try {
                    Felix.this.garbageCollectBundle(Felix.this.m_uninstalledBundles[i]);
                    continue;
                }
                catch (Exception ex) {
                    Felix.this.m_logger.log(1, "Unable to remove " + Felix.this.m_uninstalledBundles[i].getInfo().getLocation(), ex);
                }
            }
            EventDispatcher.shutdown();
            bundles = Felix.this.getBundles();
            for (i = 0; i < bundles.length; ++i) {
                bundle = (FelixBundle)bundles[i];
                IModule[] modules = bundle.getInfo().getModules();
                for (int j = 0; j < modules.length; ++j) {
                    try {
                        Felix.this.m_factory.removeModule(modules[j]);
                        continue;
                    }
                    catch (Exception ex) {
                        Felix.this.m_logger.log(1, "Unable to clean up " + bundle.getInfo().getLocation(), ex);
                    }
                }
            }
            if (Felix.this.m_activatorList != null) {
                for (i = 0; i < Felix.this.m_activatorList.size(); ++i) {
                    try {
                        if (Felix.this.m_activatorContextMap != null && Felix.this.m_activatorContextMap.containsKey(Felix.this.m_activatorList.get(i))) {
                            m_secureAction.stopActivator((BundleActivator)Felix.this.m_activatorList.get(i), (BundleContext)Felix.this.m_activatorContextMap.get(Felix.this.m_activatorList.get(i)));
                            continue;
                        }
                        m_secureAction.stopActivator((BundleActivator)Felix.this.m_activatorList.get(i), Felix.this.getInfo().getBundleContext());
                        continue;
                    }
                    catch (Throwable throwable) {
                        Felix.this.m_logger.log(2, "Exception stopping a system bundle activator.", throwable);
                    }
                }
            }
            if (Felix.this.m_extensionManager != null) {
                Felix.this.m_extensionManager.removeExtensions(Felix.this);
            }
            Felix i2 = Felix.this;
            synchronized (i2) {
                Felix.this.m_systemBundleInfo.setState(1);
                Felix.this.notifyAll();
            }
            String embedded = (String)Felix.this.m_configMap.get("felix.embedded.execution");
            boolean bl = isEmbedded = embedded == null ? false : embedded.equals("true");
            if (!isEmbedded) {
                m_secureAction.exit(0);
            }
        }
    }
}

