/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

public abstract class AbsSecurityContextHelper {
    private static JResource jResource = null;
    protected SecurityService securityService = null;

    protected abstract Logger getLogger();

    protected abstract String getRealmKey();

    protected abstract String getRealmDefault();

    public void setSecurityService(SecurityService sec) {
        this.securityService = sec;
    }

    public void login(String principalName, String credential) {
        if (principalName == null) {
            this.getLogger().log(BasicLevel.ERROR, (Object)"No username so no authentication");
            return;
        }
        JUser user = null;
        try {
            user = this.getJResource().findUser(principalName);
        }
        catch (Exception jre) {
            this.getLogger().log(BasicLevel.ERROR, (Object)("Can not find the user : " + jre.getMessage()));
            return;
        }
        if (user == null) {
            if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
                this.getLogger().log(BasicLevel.DEBUG, (Object)("User " + principalName + " not found."));
            }
            return;
        }
        boolean validated = this.getJResource().isValidUser(user, credential);
        if (!validated) {
            this.getLogger().log(BasicLevel.ERROR, (Object)("The password for the user " + principalName + " is not valid"));
            return;
        }
        ArrayList combinedRoles = null;
        try {
            combinedRoles = this.getJResource().getArrayListCombinedRoles(user);
        }
        catch (JResourceException jre) {
            this.getLogger().log(BasicLevel.ERROR, (Object)jre.getMessage());
            return;
        }
        SecurityContext ctx = new SecurityContext(principalName, (List)combinedRoles);
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("Login of principalName '" + principalName + "' succeeded."));
        }
    }

    private JResource getJResource() {
        if (jResource != null) {
            return jResource;
        }
        String resName = null;
        try {
            resName = JProp.getInstance().getValue(this.getRealmKey());
        }
        catch (Exception e) {
            this.getLogger().log(BasicLevel.ERROR, (Object)"Cannot read properties in jonas.properties file.");
        }
        if (resName == null) {
            if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
                this.getLogger().log(BasicLevel.DEBUG, (Object)("Cannot read property '" + this.getRealmKey() + "' in jonas.properties file. Use default value = '" + this.getRealmDefault() + "'."));
            }
            resName = this.getRealmDefault();
        }
        if ((jResource = this.securityService.getJResource(resName)) == null) {
            throw new IllegalStateException("Can't retrieve resource '" + resName + "' from the security service");
        }
        return jResource;
    }
}

