/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.internal.JResources;
import org.ow2.jonas.security.internal.JonasSecurityServiceImplMBean;
import org.ow2.jonas.security.internal.realm.factory.JResourceDS;
import org.ow2.jonas.security.internal.realm.factory.JResourceLDAP;
import org.ow2.jonas.security.internal.realm.factory.JResourceMemory;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemoteImpl;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.principal.Group;
import org.ow2.jonas.security.internal.realm.principal.Role;
import org.ow2.jonas.security.internal.realm.principal.User;
import org.ow2.jonas.security.lib.JResourceManager;
import org.ow2.jonas.security.lib.wrapper.JResourceManagerWrapper;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.service.ServiceException;

public class JonasSecurityServiceImpl
extends AbsServiceImpl
implements SecurityService,
JonasSecurityServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security");
    public static final String REMOTE_RESOUCE = "_remoteres";
    protected static final String CONFIG_FILE = "conf" + File.separator + "jonas-realm.xml";
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _FregistryService;
    private RegistryService registryService;
    private boolean _FjResources;
    private JResources jResources;
    private boolean _Fictx;
    private Context ictx;
    private boolean _FbindResourcesIntoJndi;
    private boolean bindResourcesIntoJndi;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetRealmJndiRegistrationboolean;
    private boolean _McheckRequirements;
    private boolean _MremoveJResourcejava_lang_String;
    private boolean _MsetRegistryServiceorg_ow2_jonas_registry_RegistryService;
    private boolean _MgetRegistryService;
    private boolean _MdoStart;
    private boolean _MregisterResourcesMBeans;
    private boolean _MdoStop;
    private boolean _MremoveJResources;
    private boolean _MgetJResourcejava_lang_String;
    private boolean _McreateRealm;
    private boolean _MgetConfigFile;
    private boolean _MtoXML;
    private boolean _MencryptPasswordjava_lang_Stringjava_lang_String;
    private boolean _MisValidAlgorithmjava_lang_String;
    private boolean _MaddResourcesjava_lang_String;
    private boolean _MaddJResourceMemoryjava_lang_String;
    private boolean _MaddJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MaddJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MbindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private RegistryService _getregistryService() {
        if (!this._FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this._cm.getterCallback("registryService");
    }

    private void _setregistryService(RegistryService registryService) {
        if (!this._FregistryService) {
            this.registryService = registryService;
            return;
        }
        this._cm.setterCallback("registryService", (Object)registryService);
    }

    private JResources _getjResources() {
        if (!this._FjResources) {
            return this.jResources;
        }
        return (JResources)this._cm.getterCallback("jResources");
    }

    private void _setjResources(JResources jResources) {
        if (!this._FjResources) {
            this.jResources = jResources;
            return;
        }
        this._cm.setterCallback("jResources", (Object)jResources);
    }

    private Context _getictx() {
        if (!this._Fictx) {
            return this.ictx;
        }
        return (Context)this._cm.getterCallback("ictx");
    }

    private void _setictx(Context context) {
        if (!this._Fictx) {
            this.ictx = context;
            return;
        }
        this._cm.setterCallback("ictx", (Object)context);
    }

    private boolean _getbindResourcesIntoJndi() {
        if (!this._FbindResourcesIntoJndi) {
            return this.bindResourcesIntoJndi;
        }
        Object object = this._cm.getterCallback("bindResourcesIntoJndi");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _setbindResourcesIntoJndi(boolean bl) {
        if (!this._FbindResourcesIntoJndi) {
            this.bindResourcesIntoJndi = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("bindResourcesIntoJndi", (Object)bl2);
    }

    public JonasSecurityServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setjmxService(null);
        this._setictx(null);
        this._setbindResourcesIntoJndi(false);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRealmJndiRegistration(boolean bl) {
        void register;
        if (this._MsetRealmJndiRegistrationboolean) {
            this._cm.entryCallback("setRealmJndiRegistrationboolean");
        }
        this._setbindResourcesIntoJndi((boolean)register);
        Object var2_2 = null;
        if (this._MsetRealmJndiRegistrationboolean) {
            this._cm.exitCallback("setRealmJndiRegistrationboolean", var2_2);
        }
    }

    public void checkRequirements() throws ServiceException {
        if (this._McheckRequirements) {
            this._cm.entryCallback("checkRequirements");
        }
        if (this._getjmxService() == null) {
            this.throwRequirementException("Missing reference on " + JmxService.class);
        }
        if (this._getregistryService() == null) {
            this.throwRequirementException("Missing reference on " + RegistryService.class);
        }
        Object var1_1 = null;
        if (this._McheckRequirements) {
            this._cm.exitCallback("checkRequirements", var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeJResource(String string) throws Exception {
        void resourceName;
        if (this._MremoveJResourcejava_lang_String) {
            this._cm.entryCallback("removeJResourcejava_lang_String");
        }
        JResource jResource = this._getjResources().remove((String)resourceName);
        if (this._getbindResourcesIntoJndi()) {
            try {
                this._getictx().unbind((String)resourceName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + (String)resourceName + " remove from the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot unbind the resource '" + (String)resourceName + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            jResource.removeMBeans();
            if (jResource instanceof JResourceMemory) {
                this._getjmxService().unregisterMBean(JonasObjectName.securityMemoryFactory((String)this.getDomainName(), (String)resourceName));
            } else if (jResource instanceof JResourceDS) {
                this._getjmxService().unregisterMBean(JonasObjectName.securityDatasourceFactory((String)this.getDomainName(), (String)resourceName));
            } else if (jResource instanceof JResourceLDAP) {
                this._getjmxService().unregisterMBean(JonasObjectName.securityLdapFactory((String)this.getDomainName(), (String)resourceName));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not unregister the MBean for the resource " + (String)resourceName + " : " + e.getMessage()));
            ServiceException serviceException = new ServiceException("Can not unregister the MBean for the resource " + (String)resourceName + " : " + e.getMessage());
            if (this._MremoveJResourcejava_lang_String) {
                this._cm.exitCallback("removeJResourcejava_lang_String", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var5_7 = null;
        if (this._MremoveJResourcejava_lang_String) {
            this._cm.exitCallback("removeJResourcejava_lang_String", var5_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRegistryService(RegistryService registryService) {
        void registry;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.entryCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService");
        }
        this._setregistryService((RegistryService)registry);
        Object var2_2 = null;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.exitCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService", var2_2);
        }
    }

    private RegistryService getRegistryService() {
        if (this._MgetRegistryService) {
            this._cm.entryCallback("getRegistryService");
        }
        RegistryService registryService = this._getregistryService();
        if (this._MgetRegistryService) {
            this._cm.exitCallback("getRegistryService", (Object)registryService);
        }
        return registryService;
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        try {
            final JonasSecurityServiceImpl ss = this;
            this._setjResources(new JResources(this));
            IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

                public InitialContext execute() throws Exception {
                    JResourceRemoteImpl jrri = new JResourceRemoteImpl(ss);
                    InitialContext ctx = JonasSecurityServiceImpl.this.getRegistryService().getRegistryContext();
                    ctx.rebind(JonasSecurityServiceImpl.this.getJonasServerName() + JonasSecurityServiceImpl.REMOTE_RESOUCE, (Object)jrri);
                    return ctx;
                }
            };
            ExecutionResult ictxResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)ictxGetter);
            if (ictxResult.hasException()) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Security service initializing");
                ServiceException serviceException = new ServiceException("Cannot create initial context when Security service initializing", (Throwable)ictxResult.getException());
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)serviceException);
                }
                throw serviceException;
            }
            this._setictx((Context)ictxResult.getResult());
            this._getjmxService().registerMBean((Object)this, JonasObjectName.securityService((String)this.getDomainName()));
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)("SecurityService: Cannot start the Security service:\n" + e));
            e.printStackTrace();
            ServiceException serviceException = new ServiceException("SecurityService: Cannot start the Security service", e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this.createRealm();
        try {
            this.registerResourcesMBeans();
        }
        catch (MalformedObjectNameException e) {
            ServiceException serviceException = new ServiceException("SecurityService: Cannot register mbeans", (Throwable)e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service Started");
        Object var7_10 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var7_10);
        }
    }

    private void registerResourcesMBeans() throws MalformedObjectNameException {
        if (this._MregisterResourcesMBeans) {
            this._cm.entryCallback("registerResourcesMBeans");
        }
        Enumeration resourcesEnum = this._getjResources().getResources();
        String domainName = this.getDomainName();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = (JResource)resourcesEnum.nextElement();
            if (!(aResource instanceof JResourceMemory)) continue;
            String resourceName = aResource.getName();
            JResourceMemory aResourceMemory = (JResourceMemory)aResource;
            aResourceMemory.setJmxService(this._getjmxService());
            aResourceMemory.setDomainName(domainName);
            Hashtable usersTable = aResourceMemory.getUsers();
            Enumeration userNames = usersTable.keys();
            while (userNames.hasMoreElements()) {
                String userName = (String)userNames.nextElement();
                User user = (User)usersTable.get(userName);
                this._getjmxService().registerMBean((Object)user, JonasObjectName.user((String)domainName, (String)resourceName, (String)userName));
            }
            Hashtable groupsTable = aResourceMemory.getGroups();
            Enumeration groupNames = groupsTable.keys();
            while (groupNames.hasMoreElements()) {
                String groupName = (String)groupNames.nextElement();
                Group group = (Group)groupsTable.get(groupName);
                this._getjmxService().registerMBean((Object)group, JonasObjectName.group((String)domainName, (String)resourceName, (String)groupName));
            }
            Hashtable rolesTable = aResourceMemory.getRoles();
            Enumeration roleNames = rolesTable.keys();
            while (roleNames.hasMoreElements()) {
                String roleName = (String)roleNames.nextElement();
                Role role = (Role)rolesTable.get(roleName);
                this._getjmxService().registerMBean((Object)role, JonasObjectName.role((String)domainName, (String)resourceName, (String)roleName));
            }
        }
        Object var14_14 = null;
        if (this._MregisterResourcesMBeans) {
            this._cm.exitCallback("registerResourcesMBeans", var14_14);
        }
    }

    public void doStop() {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        if (this._getjmxService() != null) {
            try {
                this.removeJResources();
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot remove JResources", (Throwable)e);
            }
            this._getjmxService().unregisterMBean(JonasObjectName.securityService((String)this.getDomainName()));
        }
        try {
            this._getictx().unbind(this.getJonasServerName() + REMOTE_RESOUCE);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind remote resource for security access", (Throwable)e);
            ServiceException serviceException = new ServiceException("Cannot unbind remote resource for security access", (Throwable)e);
            if (this._MdoStop) {
                this._cm.exitCallback("doStop", (Object)serviceException);
            }
            throw serviceException;
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service Stopped");
        Object var3_4 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_4);
        }
    }

    private void removeJResources() throws Exception {
        if (this._MremoveJResources) {
            this._cm.entryCallback("removeJResources");
        }
        Enumeration resourcesEnum = this._getjResources().getResources();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = (JResource)resourcesEnum.nextElement();
            this.removeJResource(aResource.getName());
        }
        Object var3_3 = null;
        if (this._MremoveJResources) {
            this._cm.exitCallback("removeJResources", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JResource getJResource(String string) {
        void name;
        if (this._MgetJResourcejava_lang_String) {
            this._cm.entryCallback("getJResourcejava_lang_String");
        }
        JResource jResource = this._getjResources().getJResource((String)name);
        if (this._MgetJResourcejava_lang_String) {
            this._cm.exitCallback("getJResourcejava_lang_String", (Object)jResource);
        }
        return jResource;
    }

    private void createRealm() throws ServiceException {
        if (this._McreateRealm) {
            this._cm.entryCallback("createRealm");
        }
        File configFile = null;
        FileReader reader = null;
        try {
            configFile = this.getConfigFile();
            reader = new FileReader(configFile);
        }
        catch (FileNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot find config file " + configFile));
            ServiceException serviceException = new ServiceException(e.getMessage(), (Throwable)e);
            if (this._McreateRealm) {
                this._cm.exitCallback("createRealm", (Object)serviceException);
            }
            throw serviceException;
        }
        try {
            JResourceManager resourceManager = JResourceManager.getInstance();
            resourceManager.addResources(this._getjResources(), reader, configFile.getPath());
        }
        catch (Throwable e) {
            String err = "Cannot add security resource from '" + configFile + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            ServiceException serviceException = new ServiceException(err, e);
            if (this._McreateRealm) {
                this._cm.exitCallback("createRealm", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var7_9 = null;
        if (this._McreateRealm) {
            this._cm.exitCallback("createRealm", var7_9);
        }
    }

    protected File getConfigFile() throws FileNotFoundException {
        if (this._MgetConfigFile) {
            this._cm.entryCallback("getConfigFile");
        }
        String fileName = System.getProperty("jonas.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            String err = "Can't find configuration file : " + fileName;
            FileNotFoundException fileNotFoundException = new FileNotFoundException(err);
            if (this._MgetConfigFile) {
                this._cm.exitCallback("getConfigFile", (Object)fileNotFoundException);
            }
            throw fileNotFoundException;
        }
        File file2 = file;
        if (this._MgetConfigFile) {
            this._cm.exitCallback("getConfigFile", (Object)file2);
        }
        return file2;
    }

    public String toXML() {
        if (this._MtoXML) {
            this._cm.entryCallback("toXML");
        }
        String string = this._getjResources().toXML();
        if (this._MtoXML) {
            this._cm.exitCallback("toXML", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String encryptPassword(String string, String string2) throws NoSuchAlgorithmException {
        void algo;
        void string3;
        if (this._MencryptPasswordjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("encryptPasswordjava_lang_Stringjava_lang_String");
        }
        String encrypt = HashHelper.hashPassword((String)string3, (String)algo);
        String string4 = "{" + algo.toUpperCase() + "}" + encrypt;
        if (this._MencryptPasswordjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("encryptPasswordjava_lang_Stringjava_lang_String", (Object)string4);
        }
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValidAlgorithm(String string) {
        if (this._MisValidAlgorithmjava_lang_String) {
            this._cm.entryCallback("isValidAlgorithmjava_lang_String");
        }
        boolean b = true;
        try {
            void algo;
            this.encryptPassword("test", (String)algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            b = false;
        }
        Boolean bl = new Boolean(b);
        if (this._MisValidAlgorithmjava_lang_String) {
            this._cm.exitCallback("isValidAlgorithmjava_lang_String", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void addResources(String string) throws Exception {
        void xml;
        if (this._MaddResourcesjava_lang_String) {
            this._cm.entryCallback("addResourcesjava_lang_String");
        }
        try {
            if (this.isOSGi()) {
                JResourceManager.getInstance().addResources(this._getjResources(), new StringReader((String)xml), "");
            } else {
                JResourceManagerWrapper.addResources(this._getjResources(), new StringReader((String)xml), "");
            }
        }
        catch (Exception e1) {
            String err = "Cannot add security resource from xml '" + (String)xml + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            ServiceException serviceException = new ServiceException(err, (Throwable)e1);
            if (this._MaddResourcesjava_lang_String) {
                this._cm.exitCallback("addResourcesjava_lang_String", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var5_5 = null;
        if (this._MaddResourcesjava_lang_String) {
            this._cm.exitCallback("addResourcesjava_lang_String", var5_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addJResourceMemory(String string) throws Exception {
        void name;
        if (this._MaddJResourceMemoryjava_lang_String) {
            this._cm.entryCallback("addJResourceMemoryjava_lang_String");
        }
        JResourceMemory jResourceMemory = new JResourceMemory();
        jResourceMemory.setSecurityService(this);
        jResourceMemory.setJmxService(this._getjmxService());
        jResourceMemory.setDomainName(this.getDomainName());
        jResourceMemory.setName((String)name);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-memoryrealm>");
        xml.append(jResourceMemory.toXML());
        xml.append("</jonas-memoryrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
        Object var4_4 = null;
        if (this._MaddJResourceMemoryjava_lang_String) {
            this._cm.exitCallback("addJResourceMemoryjava_lang_String", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addJResourceDS(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws Exception {
        void algorithm;
        void roleTableRolenameCol;
        void roleTableUsernameCol;
        void roleTable;
        void userTablePasswordCol;
        void userTableUsernameCol;
        void userTable;
        void dsName;
        void name;
        if (this._MaddJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("addJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        JResourceDS jResourceDS = new JResourceDS();
        jResourceDS.setSecurityService(this);
        jResourceDS.setJmxService(this._getjmxService());
        jResourceDS.setDomainName(this.getDomainName());
        jResourceDS.setName((String)name);
        jResourceDS.setDsName((String)dsName);
        jResourceDS.setUserTable((String)userTable);
        jResourceDS.setUserTableUsernameCol((String)userTableUsernameCol);
        jResourceDS.setUserTablePasswordCol((String)userTablePasswordCol);
        jResourceDS.setRoleTable((String)roleTable);
        jResourceDS.setRoleTableUsernameCol((String)roleTableUsernameCol);
        jResourceDS.setRoleTableRolenameCol((String)roleTableRolenameCol);
        jResourceDS.setAlgorithm((String)algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-dsrealm>");
        xml.append(jResourceDS.toXML());
        xml.append("</jonas-dsrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
        Object var12_12 = null;
        if (this._MaddJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("addJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String", var12_12);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addJResourceLDAP(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20) throws Exception {
        void algorithm;
        void roleSearchFilter;
        void roleDN;
        void userSearchFilter;
        void userDN;
        void baseDN;
        void roleNameAttribute;
        void userRolesAttribute;
        void userPasswordAttribute;
        void authenticationMode;
        void stateFactories;
        void referral;
        void language;
        void securityProtocol;
        void securityCredentials;
        void securityPrincipal;
        void securityAuthentication;
        void providerUrl;
        void initialContextFactory;
        void name;
        if (this._MaddJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("addJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        JResourceLDAP jResourceLDAP = new JResourceLDAP();
        jResourceLDAP.setSecurityService(this);
        jResourceLDAP.setJmxService(this._getjmxService());
        jResourceLDAP.setDomainName(this.getDomainName());
        jResourceLDAP.setName((String)name);
        jResourceLDAP.setInitialContextFactory((String)initialContextFactory);
        jResourceLDAP.setProviderUrl((String)providerUrl);
        jResourceLDAP.setSecurityAuthentication((String)securityAuthentication);
        jResourceLDAP.setSecurityPrincipal((String)securityPrincipal);
        jResourceLDAP.setSecurityCredentials((String)securityCredentials);
        jResourceLDAP.setSecurityProtocol((String)securityProtocol);
        jResourceLDAP.setLanguage((String)language);
        jResourceLDAP.setReferral((String)referral);
        jResourceLDAP.setStateFactories((String)stateFactories);
        jResourceLDAP.setAuthenticationMode((String)authenticationMode);
        jResourceLDAP.setUserPasswordAttribute((String)userPasswordAttribute);
        jResourceLDAP.setUserRolesAttribute((String)userRolesAttribute);
        jResourceLDAP.setRoleNameAttribute((String)roleNameAttribute);
        jResourceLDAP.setBaseDN((String)baseDN);
        jResourceLDAP.setUserDN((String)userDN);
        jResourceLDAP.setUserSearchFilter((String)userSearchFilter);
        jResourceLDAP.setRoleDN((String)roleDN);
        jResourceLDAP.setRoleSearchFilter((String)roleSearchFilter);
        jResourceLDAP.setAlgorithm((String)algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-ldaprealm>");
        xml.append(jResourceLDAP.toXML());
        xml.append("</jonas-ldaprealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
        Object var23_23 = null;
        if (this._MaddJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("addJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String", var23_23);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void bindResource(String string, JResource jResource) {
        void jResource2;
        if (this._MbindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource) {
            this._cm.entryCallback("bindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource");
        }
        if (this._getbindResourcesIntoJndi()) {
            try {
                this._getictx().rebind(jResource2.getName(), (Object)jResource2);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + jResource2.getName() + " bound into the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot bind the resource '" + jResource2.getName() + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            if (jResource2 instanceof JResourceMemory) {
                this._getjmxService().registerMBean((Object)jResource2, JonasObjectName.securityMemoryFactory((String)this.getDomainName(), (String)jResource2.getName()));
            } else if (jResource2 instanceof JResourceDS) {
                this._getjmxService().registerMBean((Object)jResource2, JonasObjectName.securityDatasourceFactory((String)this.getDomainName(), (String)jResource2.getName()));
            } else if (jResource2 instanceof JResourceLDAP) {
                this._getjmxService().registerMBean((Object)jResource2, JonasObjectName.securityLdapFactory((String)this.getDomainName(), (String)jResource2.getName()));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not register the MBean for the resource " + jResource2.getName() + " : " + e.getMessage()));
            ServiceException serviceException = new ServiceException("Can not register the MBean for the resource " + jResource2.getName() + " : " + e.getMessage());
            if (this._MbindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource) {
                this._cm.exitCallback("bindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var5_7 = null;
        if (this._MbindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource) {
            this._cm.exitCallback("bindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource", var5_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("ictx")) {
                this._Fictx = true;
            }
            if (set.contains("jResources")) {
                this._FjResources = true;
            }
            if (set.contains("CONFIG_FILE")) {
                this._FCONFIG_FILE = true;
            }
            if (set.contains("bindResourcesIntoJndi")) {
                this._FbindResourcesIntoJndi = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("registryService")) {
                this._FregistryService = true;
            }
            if (set.contains("REMOTE_RESOUCE")) {
                this._FREMOTE_RESOUCE = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setRealmJndiRegistrationboolean")) {
                this._MsetRealmJndiRegistrationboolean = true;
            }
            if (set.contains("checkRequirements")) {
                this._McheckRequirements = true;
            }
            if (set.contains("removeJResourcejava_lang_String")) {
                this._MremoveJResourcejava_lang_String = true;
            }
            if (set.contains("setRegistryServiceorg_ow2_jonas_registry_RegistryService")) {
                this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this._MgetRegistryService = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("registerResourcesMBeans")) {
                this._MregisterResourcesMBeans = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("removeJResources")) {
                this._MremoveJResources = true;
            }
            if (set.contains("getJResourcejava_lang_String")) {
                this._MgetJResourcejava_lang_String = true;
            }
            if (set.contains("createRealm")) {
                this._McreateRealm = true;
            }
            if (set.contains("getConfigFile")) {
                this._MgetConfigFile = true;
            }
            if (set.contains("toXML")) {
                this._MtoXML = true;
            }
            if (set.contains("encryptPasswordjava_lang_Stringjava_lang_String")) {
                this._MencryptPasswordjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("isValidAlgorithmjava_lang_String")) {
                this._MisValidAlgorithmjava_lang_String = true;
            }
            if (set.contains("addResourcesjava_lang_String")) {
                this._MaddResourcesjava_lang_String = true;
            }
            if (set.contains("addJResourceMemoryjava_lang_String")) {
                this._MaddJResourceMemoryjava_lang_String = true;
            }
            if (set.contains("addJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MaddJResourceDSjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("addJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MaddJResourceLDAPjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("bindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource")) {
                this._MbindResourcejava_lang_Stringorg_ow2_jonas_security_realm_factory_JResource = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

