/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.client.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.client.AppClientDTDs;
import org.ow2.jonas.deployment.client.AppClientSchemas;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDescException;
import org.ow2.jonas.deployment.client.JonasAppClientDTDs;
import org.ow2.jonas.deployment.client.JonasAppClientSchemas;
import org.ow2.jonas.deployment.client.rules.ApplicationClientRuleSet;
import org.ow2.jonas.deployment.client.rules.JonasClientRuleSet;
import org.ow2.jonas.deployment.client.xml.ApplicationClient;
import org.ow2.jonas.deployment.client.xml.JonasClient;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.lib.loader.WebappClassLoader;

public class ClientDeploymentDescManager
extends AbsDeploymentDescManager {
    private static ClientDeploymentDescManager unique;
    private EjbDeploymentDescManager ejbDDManager = EjbDeploymentDescManager.getInstance();
    private Hashtable earCLAltDDBindings = new Hashtable();
    public static final String CLIENT_FILE_NAME = "META-INF/application-client.xml";
    public static final String JONAS_CLIENT_FILE_NAME = "META-INF/jonas-client.xml";
    private static JDigester appClientDigester;
    private static JDigester jonasAppClientDigester;
    private static boolean parsingWithValidation;
    private static ApplicationClientRuleSet appClientRuleSet;
    private static JonasClientRuleSet jonasAppClientRuleSet;

    private ClientDeploymentDescManager() {
    }

    public static ClientDeploymentDescManager getInstance() {
        if (unique == null) {
            unique = new ClientDeploymentDescManager();
        }
        return unique;
    }

    public ClientContainerDeploymentDesc getDeploymentDesc(URL url, ClassLoader loaderForCls, ClassLoader earLoader) throws DeploymentDescException {
        if (!new File(url.getFile()).exists()) {
            String err = "Cannot get the deployment descriptor for ";
            err = err + "'" + url.getFile() + "'. The file doesn't exist.";
            throw new ClientContainerDeploymentDescException(err);
        }
        URL altDDUrl = null;
        Hashtable urlAltddBindings = null;
        if (earLoader != null) {
            urlAltddBindings = (Hashtable)this.earCLAltDDBindings.get(earLoader);
            if (urlAltddBindings == null) {
                String err = "Cannot find if there is alt-dd for '" + url.getFile() + "', the setAltDD function was badly called";
                throw new ClientContainerDeploymentDescException(err);
            }
            altDDUrl = (URL)urlAltddBindings.get(url);
        }
        ClientContainerDeploymentDesc clientDD = null;
        try {
            clientDD = altDDUrl != null ? ClientDeploymentDescManager.getInstance(url.getFile(), loaderForCls, altDDUrl.getFile()) : ClientDeploymentDescManager.getInstance(url.getFile(), loaderForCls);
        }
        catch (DeploymentDescException dde) {
            throw new ClientContainerDeploymentDescException(dde);
        }
        EjbRefDesc[] ejbRef = clientDD.getEjbRefDesc();
        for (int i = 0; i < ejbRef.length; ++i) {
            if (ejbRef[i].getJndiName() != null) continue;
            String ejbLink = ejbRef[i].getEjbLink();
            String ejbRefType = ejbRef[i].getEjbRefType();
            if (ejbLink == null) continue;
            if (earLoader == null) {
                throw new ClientContainerDeploymentDescException("Ejb-link is not authorized from a single client jar. The client jar must be in an ear.");
            }
            String jndiName = this.getJndiName(url, ejbLink, earLoader, ejbRefType);
            ejbRef[i].setJndiName(jndiName);
        }
        IServiceRefDesc[] serviceRef = clientDD.getServiceRefDesc();
        for (int i = 0; i < serviceRef.length; ++i) {
            List pcRefs = serviceRef[i].getPortComponentRefs();
            for (int j = 0; j < pcRefs.size(); ++j) {
                PortComponentRefDesc pcr = (PortComponentRefDesc)pcRefs.get(j);
                String pclink = pcr.getPortComponentLink();
                if (pclink == null) continue;
                PortComponentDesc pcDesc = this.getPCDesc(url, pclink, earLoader);
                pcr.setPortComponentDesc(pcDesc);
            }
        }
        MessageDestinationRefDesc[] mdRef = clientDD.getMessageDestinationRefDesc();
        for (int i = 0; i < mdRef.length; ++i) {
            if (mdRef[i].getJndiName() != null) continue;
            String jndiName = mdRef[i].getJndiName();
            String mdLink = mdRef[i].getMessageDestinationLink();
            String mdType = mdRef[i].getMessageDestinationType();
            String mdUsage = mdRef[i].getMessageDestinationUsage();
            if (mdLink == null) continue;
            if (earLoader == null) {
                throw new ClientContainerDeploymentDescException("Message-destination-link is not authorized from a single client jar. The client jar must be in an ear.");
            }
            String mdName = this.getMDJndiName(url, mdLink, mdType, mdUsage, earLoader);
            mdRef[i].setJndiName(jndiName);
        }
        return clientDD;
    }

    private PortComponentDesc getPCDesc(URL warURL, String pcLink, ClassLoader earLoader) throws DeploymentDescException {
        String moduleLink = null;
        String pcNameLink = null;
        if (pcLink.toLowerCase().indexOf(".war#") == -1 && pcLink.toLowerCase().indexOf(".jar#") == -1) {
            String err = "PC-link " + pcLink + " has a bad format. Correct format :  filename.(jar|war)#portComponentName";
            throw new DeploymentDescException(err);
        }
        StringTokenizer st = new StringTokenizer(pcLink, "#");
        if (st.countTokens() != 2 || pcLink.startsWith("#") || pcLink.endsWith("#")) {
            String err = "PC-link " + pcLink + " has a bad format. Correct format :  filename.[jar or war]#portComponentName";
            throw new DeploymentDescException(err);
        }
        moduleLink = st.nextToken();
        pcNameLink = st.nextToken();
        URL moduleLinkUrl = null;
        try {
            moduleLinkUrl = new File(new File(warURL.getFile()).getParent() + File.separator + moduleLink).getCanonicalFile().toURL();
        }
        catch (MalformedURLException mue) {
            String err = "Error when creating an url for the module filename. Error :" + mue.getMessage();
            throw new DeploymentDescException(err);
        }
        catch (IOException ioe) {
            String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
            throw new DeploymentDescException(err);
        }
        if (!new File(moduleLinkUrl.getFile()).exists()) {
            String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'. The file doesn't exist.";
            throw new DeploymentDescException(err);
        }
        ClassLoader loaderForCls = null;
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (moduleLink.toLowerCase().endsWith(".war")) {
            try {
                loaderForCls = new WebappClassLoader(moduleLinkUrl, current);
            }
            catch (IOException ioe) {
                throw new DeploymentDescException("Unable to create Web ClassLoader", ioe);
            }
        } else {
            loaderForCls = current;
        }
        WSDeploymentDesc wsDD = null;
        try {
            wsDD = WSDeploymentDescManager.getInstance().getDeploymentDesc(moduleLinkUrl, loaderForCls, earLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'.";
            throw new DeploymentDescException(err, e);
        }
        if (wsDD == null) {
            String err = "Port component link " + pcNameLink + " not found in " + moduleLinkUrl.getFile();
            throw new DeploymentDescException(err);
        }
        List sdl = wsDD.getServiceDescs();
        boolean isFound = false;
        PortComponentDesc pcd = null;
        for (int i = 0; i < sdl.size() && !isFound; ++i) {
            if (sdl.get(i) == null) continue;
            pcd = ((ServiceDesc)sdl.get(i)).getPortComponent(pcNameLink);
            isFound = pcd != null;
        }
        if (!isFound) {
            String err = "the port component link " + pcNameLink + " doesn't exist in " + moduleLinkUrl.getFile();
            throw new DeploymentDescException(err);
        }
        return pcd;
    }

    public static ClientContainerDeploymentDesc getInstance(String clientFileName, ClassLoader classLoaderForCls) throws DeploymentDescException {
        return ClientDeploymentDescManager.getInstance(clientFileName, classLoaderForCls, null);
    }

    public static ClientContainerDeploymentDesc getInstance(String clientFileName, ClassLoader classLoaderForCls, String altClientXmlFilename) throws DeploymentDescException {
        JonasClient jonasClient;
        JarFile clientFile = null;
        InputStream applicationClientInputStream = null;
        InputStream jonasClientInputStream = null;
        ZipEntry applicationClientZipEntry = null;
        ZipEntry jonasClientZipEntry = null;
        String xmlContent = "";
        String jonasXmlContent = "";
        File fClient = new File(clientFileName);
        if (!fClient.exists()) {
            String err = "' " + clientFileName + "' was not found.";
            throw new ClientContainerDeploymentDescException(err);
        }
        if (altClientXmlFilename != null && !new File(altClientXmlFilename).exists()) {
            String err = "The file for the altdd tag for the EAR case '" + altClientXmlFilename + "' was not found.";
            throw new ClientContainerDeploymentDescException(err);
        }
        if (altClientXmlFilename == null) {
            try {
                clientFile = new JarFile(clientFileName);
                applicationClientZipEntry = clientFile.getEntry(CLIENT_FILE_NAME);
                if (applicationClientZipEntry == null) {
                    throw new ClientContainerDeploymentDescException("The entry 'META-INF/application-client.xml' was not found in the file '" + clientFileName + "'.");
                }
                applicationClientInputStream = clientFile.getInputStream(applicationClientZipEntry);
                xmlContent = ClientDeploymentDescManager.xmlContent(applicationClientInputStream);
                applicationClientInputStream = clientFile.getInputStream(applicationClientZipEntry);
            }
            catch (Exception e) {
                if (clientFile != null) {
                    try {
                        clientFile.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw new ClientContainerDeploymentDescException("Can not read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
            }
        }
        try {
            applicationClientInputStream = new FileInputStream(altClientXmlFilename);
            xmlContent = ClientDeploymentDescManager.xmlContent(applicationClientInputStream);
            applicationClientInputStream = new FileInputStream(altClientXmlFilename);
        }
        catch (FileNotFoundException ioe) {
            throw new ClientContainerDeploymentDescException("The altDD file '" + altClientXmlFilename + "' was not found.");
        }
        catch (Exception e) {
            if (applicationClientInputStream != null) {
                try {
                    ((InputStream)applicationClientInputStream).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            throw new ClientContainerDeploymentDescException("Cannot read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
        }
        ApplicationClient applicationClient = ClientDeploymentDescManager.loadApplicationClient(new InputStreamReader(applicationClientInputStream), CLIENT_FILE_NAME);
        try {
            clientFile = new JarFile(clientFileName);
            jonasClientZipEntry = clientFile.getEntry(JONAS_CLIENT_FILE_NAME);
            if (jonasClientZipEntry != null) {
                jonasClientInputStream = clientFile.getInputStream(jonasClientZipEntry);
                jonasXmlContent = ClientDeploymentDescManager.xmlContent(jonasClientInputStream);
                jonasClientInputStream = clientFile.getInputStream(jonasClientZipEntry);
            }
        }
        catch (Exception e) {
            if (clientFile != null) {
                try {
                    clientFile.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            throw new ClientContainerDeploymentDescException("Can not read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
        }
        if (jonasClientInputStream != null) {
            jonasClient = ClientDeploymentDescManager.loadJonasClient(new InputStreamReader(jonasClientInputStream), JONAS_CLIENT_FILE_NAME);
            try {
                jonasClientInputStream.close();
            }
            catch (IOException e) {}
        } else {
            jonasClient = new JonasClient();
        }
        ClientContainerDeploymentDesc clientDD = new ClientContainerDeploymentDesc(classLoaderForCls, applicationClient, jonasClient);
        clientDD.setXmlContent(xmlContent);
        clientDD.setJOnASXmlContent(jonasXmlContent);
        return clientDD;
    }

    public static ApplicationClient loadApplicationClient(Reader reader, String fileName) throws DeploymentDescException {
        ApplicationClient appc = new ApplicationClient();
        if (appClientDigester == null) {
            appClientDigester = new JDigester(appClientRuleSet, ClientDeploymentDescManager.getParsingWithValidation(), true, new AppClientDTDs(), new AppClientSchemas());
        }
        try {
            appClientDigester.parse(reader, fileName, appc);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            appClientDigester.push(null);
        }
        return appc;
    }

    public static JonasClient loadJonasClient(Reader reader, String fileName) throws DeploymentDescException {
        JonasClient jc = new JonasClient();
        if (jonasAppClientDigester == null) {
            jonasAppClientDigester = new JDigester(jonasAppClientRuleSet, ClientDeploymentDescManager.getParsingWithValidation(), true, new JonasAppClientDTDs(), new JonasAppClientSchemas());
        }
        try {
            jonasAppClientDigester.parse(reader, fileName, jc);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            jonasAppClientDigester.push(null);
        }
        return jc;
    }

    private String getJndiName(URL clientURL, String ejbLink, ClassLoader earLoader, String ejbType) throws DeploymentDescException {
        return this.ejbDDManager.getJndiName(clientURL, ejbLink, earLoader, ejbType, null, true);
    }

    private String getMDJndiName(URL clientURL, String mdLink, String mdType, String mdUsage, ClassLoader earLoader) throws ClientContainerDeploymentDescException {
        String ejbJarLink = null;
        String destNameLink = null;
        DeploymentDesc dd = null;
        if (mdLink.toLowerCase().indexOf(".jar#") == -1) {
            String err = "Message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar#messageDestinationName";
            throw new ClientContainerDeploymentDescException(err);
        }
        StringTokenizer st = new StringTokenizer(mdLink, "#");
        if (st.countTokens() != 2 || mdLink.startsWith("#") || mdLink.endsWith("#")) {
            String err = "Message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar#messageDestinationName.";
            throw new ClientContainerDeploymentDescException(err);
        }
        ejbJarLink = st.nextToken();
        destNameLink = st.nextToken();
        if (!ejbJarLink.endsWith(".jar")) {
            String err = "Ejbjar filename " + ejbJarLink + " from the message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar";
            throw new ClientContainerDeploymentDescException(err);
        }
        URL ejbJarLinkUrl = null;
        try {
            ejbJarLinkUrl = new File(new File(clientURL.getFile()).getParent() + File.separator + ejbJarLink).getCanonicalFile().toURL();
        }
        catch (MalformedURLException mue) {
            String err = "Error when creating an url for the ejb jar filename. Error :" + mue.getMessage();
            throw new ClientContainerDeploymentDescException(err);
        }
        catch (IOException ioe) {
            String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
            throw new ClientContainerDeploymentDescException(err);
        }
        if (!new File(ejbJarLinkUrl.getFile()).exists()) {
            String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'. The file doesn't exist.";
            throw new ClientContainerDeploymentDescException(err);
        }
        URL[] ddURL = new URL[]{ejbJarLinkUrl};
        URLClassLoader loaderForClsEjb = new URLClassLoader(ddURL, earLoader);
        try {
            dd = this.ejbDDManager.getDeploymentDesc(ejbJarLinkUrl, loaderForClsEjb, earLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'.";
            throw new ClientContainerDeploymentDescException(err, e);
        }
        JonasMessageDestination md = dd.getJonasMessageDestination(mdLink);
        if (md == null) {
            String err = "No message-destination-link was found for '" + mdLink + "' in the file " + clientURL.getFile() + " specified.";
            throw new ClientContainerDeploymentDescException(err);
        }
        return md.getJndiName();
    }

    public void removeCache(ClassLoader earClassLoader) {
        this.earCLAltDDBindings.remove(earClassLoader);
        this.ejbDDManager.removeCache(earClassLoader);
    }

    public void setAltDD(ClassLoader earClassLoader, URL[] urls, URL[] altDDs) {
        Hashtable<URL, URL> urlAltddBindings = new Hashtable<URL, URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (altDDs[i] == null) continue;
            urlAltddBindings.put(urls[i], altDDs[i]);
        }
        this.earCLAltDDBindings.put(earClassLoader, urlAltddBindings);
    }

    public int getCacheSize() {
        int bufferSize = 0;
        Enumeration keys = this.earCLAltDDBindings.keys();
        while (keys.hasMoreElements()) {
            ClassLoader loader = (ClassLoader)keys.nextElement();
            Hashtable hashtab = (Hashtable)this.earCLAltDDBindings.get(loader);
            bufferSize += hashtab.size();
        }
        return bufferSize;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }

    static {
        appClientDigester = null;
        jonasAppClientDigester = null;
        parsingWithValidation = true;
        appClientRuleSet = new ApplicationClientRuleSet();
        jonasAppClientRuleSet = new JonasClientRuleSet();
    }
}

