/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common;

import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.Handler;
import org.ow2.jonas.deployment.common.xml.InitParam;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.Qname;

public class HandlerDesc {
    private String name;
    private String className;
    private Class clazz;
    private Properties params = new Properties();
    private List headers = new Vector();
    private List roles = new Vector();
    private List portNames = new Vector();

    public HandlerDesc(ClassLoader classLoader, Handler handler) throws DeploymentDescException {
        this.name = handler.getHandlerName();
        this.className = handler.getHandlerClass();
        try {
            this.clazz = classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentDescException("handler class not found", e);
        }
        JLinkedList iparams = handler.getInitParamList();
        try {
            for (int i = 0; i < iparams.size(); ++i) {
                InitParam p = (InitParam)iparams.get(i);
                if (p == null) continue;
                this.params.put(p.getParamName(), p.getParamValue());
            }
        }
        catch (NullPointerException e) {
            throw new DeploymentDescException("parameter name missing", e);
        }
        JLinkedList shl = handler.getSoapHeaderList();
        for (int i = 0; i < shl.size(); ++i) {
            Qname sh = (Qname)shl.get(i);
            if (sh == null) continue;
            QName qn = sh.getQName();
            this.headers.add(qn);
        }
        JLinkedList srl = handler.getSoapRoleList();
        for (int i = 0; i < srl.size(); ++i) {
            String role = (String)srl.get(i);
            if (role == null) continue;
            this.roles.add(role);
        }
        JLinkedList pnl = handler.getPortNameList();
        for (int i = 0; i < pnl.size(); ++i) {
            String pn = (String)pnl.get(i);
            if (pn == null) continue;
            this.portNames.add(pn);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHandlerClassName() {
        return this.className;
    }

    public Class getHandlerClass() {
        return this.clazz;
    }

    public Properties getInitParams() {
        return this.params;
    }

    public String getInitParam(String pname) {
        return this.params.getProperty(pname);
    }

    public List getSOAPHeaders() {
        return this.headers;
    }

    public List getSOAPRoles() {
        return this.roles;
    }

    public List getPortNames() {
        return this.portNames;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof HandlerDesc)) {
            return false;
        }
        HandlerDesc ref = (HandlerDesc)other;
        if (!this.name.equals(ref.getName())) {
            return false;
        }
        if (!this.clazz.getName().equals(ref.getHandlerClass().getName())) {
            return false;
        }
        if (!this.params.equals(ref.getInitParams())) {
            return false;
        }
        if (!((Object)this.headers).equals(ref.getSOAPHeaders())) {
            return false;
        }
        if (!((Object)this.roles).equals(ref.getSOAPRoles())) {
            return false;
        }
        return ((Object)this.portNames).equals(ref.getPortNames());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.getClass().getName());
        sb.append("\ngetName()=" + this.getName());
        sb.append("\ngetClassname()=" + this.getHandlerClassName());
        sb.append("\ngetSOAPRoles()=" + this.getSOAPRoles());
        sb.append("\ngetSOAPHeaders()=" + this.getSOAPHeaders());
        sb.append("\ngetInitParams()=" + this.getInitParams());
        sb.append("\ngetPortNames()=" + this.getPortNames());
        return sb.toString();
    }
}

