/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common;

import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JonasResourceEnv;
import org.ow2.jonas.deployment.common.xml.ResourceEnvRef;

public class ResourceEnvRefDesc
implements IResourceEnvRefDesc {
    private String name;
    private Class type;
    private String jndiName;

    public ResourceEnvRefDesc(ClassLoader classLoader, ResourceEnvRef res, JonasResourceEnv jRes) throws DeploymentDescException {
        this.name = res.getResourceEnvRefName();
        try {
            this.type = classLoader.loadClass(res.getResourceEnvRefType());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentDescException("resource-env-ref-type class not found for resource-env-ref " + this.name, e);
        }
        this.jndiName = jRes.getJndiName();
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetName()=" + this.getName());
        ret.append("\ngetType()=" + this.getType());
        ret.append("\ngetJndiName()=" + this.getJndiName());
        return ret.toString();
    }
}

