/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.lib.bootstrap.JClassLoader;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.util.Log;

public class WebManagerWrapper {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ear");
    private static final String WEBMANAGER_CLASSNAME = "org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager";

    private WebManagerWrapper() {
    }

    public static WebContainerDeploymentDesc getDeploymentDesc(URL url, ClassLoader moduleCL, ClassLoader earCL) throws WebContainerDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        WebContainerDeploymentDesc webDD = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(WEBMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("getDeploymentDesc", URL.class, ClassLoader.class, ClassLoader.class);
            webDD = (WebContainerDeploymentDesc)m.invoke(instance, url, moduleCL, earCL);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WebContainerDeploymentDescException.class.isInstance(t)) {
                throw (WebContainerDeploymentDescException)ite.getTargetException();
            }
            throw new WebContainerDeploymentDescException("WebDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new WebContainerDeploymentDescException("Problems when using reflection on WebDeploymentDescManager", e);
        }
        return webDD;
    }

    public static void setAltDD(URLClassLoader earClassLoader, URL[] warUrls, URL[] warsAltDDs) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(WEBMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("setAltDD", ClassLoader.class, URL[].class, URL[].class);
            m.invoke(instance, earClassLoader, warUrls, warsAltDDs);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(WEBMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", Boolean.TYPE);
            m.invoke(null, new Boolean(b));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static void removeCache(ClassLoader classLoader) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(WEBMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("removeCache", ClassLoader.class);
            m.invoke(instance, classLoader);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static WebContainerDeploymentDesc getDeploymentDesc(String warName, ClassLoader cl) throws WebContainerDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        WebContainerDeploymentDesc desc = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(WEBMANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getDeploymentDesc", String.class, ClassLoader.class);
            desc = (WebContainerDeploymentDesc)m.invoke(null, warName, cl);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WebContainerDeploymentDescException.class.isInstance(t)) {
                throw (WebContainerDeploymentDescException)ite.getTargetException();
            }
            throw new WebContainerDeploymentDescException("WebDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new WebContainerDeploymentDescException("Problems when using reflection on WebDeploymentDescManager", e);
        }
        return desc;
    }
}

