/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.List;
import java.util.Properties;
import javax.ejb.TimerService;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.TimerComponent;
import org.ow2.easybeans.component.quartz.QuartzTimerService;
import org.ow2.easybeans.component.util.Property;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzComponent
implements TimerComponent {
    private Scheduler scheduler = null;
    private List<Property> quartzProperties = null;
    private SchedulerFactory schedulerFactory = null;

    public void init() throws EZBComponentException {
        Properties schedulerProperties = new Properties();
        if (this.quartzProperties != null) {
            for (Property property : this.quartzProperties) {
                schedulerProperties.put(property.getName(), property.getValue());
            }
        }
        this.schedulerFactory = null;
        try {
            this.schedulerFactory = new StdSchedulerFactory(schedulerProperties);
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot initialize the Scheduler factory", (Throwable)e);
        }
    }

    public void start() throws EZBComponentException {
        try {
            this.scheduler = this.schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot get a scheduler from the factory", (Throwable)e);
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot start the scheduler", (Throwable)e);
        }
    }

    public void stop() throws EZBComponentException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot stop the scheduler", (Throwable)e);
        }
    }

    public TimerService getTimerService(Factory factory) {
        return new QuartzTimerService(factory, this.scheduler);
    }

    public List<Property> getProperties() {
        return this.quartzProperties;
    }

    public void setProperties(List<Property> quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

