/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.comm.handler;

import java.io.IOException;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommHandlerImpl;
import org.ow2.jonas.discovery.jgroups.utils.Data;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.lib.util.Log;

public class DiscCommGreetingHandler
extends DiscCommHandlerImpl {
    public DiscCommGreetingHandler(Address hostAddress) {
        super(hostAddress);
    }

    public void receive(Message msg) {
        if (this.logger == null) {
            this.logger = Log.getLogger((String)"org.ow2.jonas.discovery");
        }
        Object objReceived = null;
        Data data = null;
        this.logger.log(BasicLevel.DEBUG, (Object)(" Object received from " + msg.getSrc()));
        Address senderAddress = msg.getSrc();
        if (!senderAddress.equals(JGroupsDiscoveryUtils.getInstance().getLocalAddress())) {
            data = (Data)msg.getObject();
            try {
                objReceived = JGroupsDiscoveryUtils.bytesToObject(data);
            }
            catch (IOException e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" IOException occured in DiscCommGreetingHandler. Unable to cast data received on network into Object. Received packet content must not be the expected one \n" + e));
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" Following Exception occurred in DiscCommGreetingHandler. Unable to cast data received on network into Object. Received packet content must not be the expected one \n" + e));
            }
            if (objReceived != null && objReceived instanceof DiscGreeting) {
                DiscGreeting message = (DiscGreeting)objReceived;
                try {
                    this.handleGreeting(message, senderAddress);
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.DEBUG, (Object)(" Exception occurend while handling Greeting: " + e));
                }
            }
        } else {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Ignore Message Received from " + msg.getSrc() + ". My Address is: " + JGroupsDiscoveryUtils.getInstance().getLocalAddress()));
        }
    }

    private void handleGreeting(DiscGreeting message, Address add2Reply) throws Exception {
        this.logger.log(BasicLevel.ERROR, (Object)(" Received Greeting from " + message.getSourceAddress()));
        if (message.getState().equals("starting up")) {
            if (message.getDomainName().equals(JGroupsDiscoveryUtils.getInstance().getDomainName()) && message.getServerName().equals(JGroupsDiscoveryUtils.getInstance().getJonasName())) {
                this.logger.log(BasicLevel.ERROR, (Object)("Received Greeting from: " + message.getSourceAddress() + " Named:  " + message.getServerName() + " from domain: " + message.getDomainName() + " with serverId: " + message.getServerId() + "\n"));
                this.logger.log(BasicLevel.ERROR, (Object)"A duplicate name notification will be sent to this server \n");
                DiscGreeting duplicateNameNotif = JGroupsDiscoveryUtils.createDiscGreeting(false);
                JGroupsDiscoveryUtils.send(add2Reply, JGroupsDiscoveryUtils.objectToBytes((Serializable)duplicateNameNotif));
            }
        } else if (message.getState().equals("duplicate server name found")) {
            JGroupsDiscoveryUtils.duplicateExceptionName = true;
            this.logger.log(BasicLevel.DEBUG, (Object)(" Received duplicate name notification from " + message.getSourceAddress() + "Named:  " + message.getServerName() + " on domain:" + message.getDomainName() + " with serverId: " + message.getServerId() + "\n"));
            Thread.interrupted();
        }
    }
}

