/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public abstract class BootstrapTask
extends Task {
    private static final String BOOTSTRAP_CLASS = "org.ow2.jonas.lib.bootstrap.Bootstrap";
    private static final String DEFAULT_SERVER_NAME = "jonas";
    private String taskName = "JOnAS";
    private File jonasRoot = null;
    private String serverName = "jonas";
    private String domainName = null;
    private File jonasBase = null;
    private String catalinaHome = null;
    private String jettyHome = null;
    private String jvmOpts = null;
    private Path classpath = null;

    public void setJonasRoot(File jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public void setJonasbase(File jonasBase) {
        this.jonasBase = jonasBase;
    }

    public void setJvmopts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
    }

    public Path createClasspath() {
        return new Path(this.getProject());
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Java getBootstraptask(String definedClass) {
        String jonasConfigDir;
        File javaPolicyFile;
        if (this.jonasRoot == null) {
            String jr = this.getProject().getProperty("jonas.root");
            this.jonasRoot = new File(jr);
            if (jr == null) {
                throw new BuildException("attribute jonasroot is necessary.");
            }
        }
        if (this.jonasBase == null) {
            this.jonasBase = this.jonasRoot;
        }
        Java bootstrapTask = (Java)this.getProject().createTask("java");
        bootstrapTask.setTaskName(this.taskName);
        bootstrapTask.setFork(true);
        bootstrapTask.setFailonerror(true);
        bootstrapTask.createJvmarg().setValue("-Djonas.name=" + this.serverName);
        if (this.domainName != null) {
            bootstrapTask.createJvmarg().setValue("-Ddomain.name=" + this.domainName);
        }
        bootstrapTask.createJvmarg().setValue("-Dinstall.root=" + this.jonasRoot);
        bootstrapTask.createJvmarg().setValue("-Djonas.base=" + this.jonasBase);
        bootstrapTask.createJvmarg().setValue("-Djava.awt.headless=true");
        bootstrapTask.createJvmarg().setValue("-Djonas.default.classloader=true");
        bootstrapTask.createJvmarg().setValue("-Djonas.classpath=");
        bootstrapTask.createJvmarg().setValue("-Djava.naming.factory.initial=org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        bootstrapTask.createJvmarg().setValue("-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB");
        bootstrapTask.createJvmarg().setValue("-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton");
        bootstrapTask.createJvmarg().setValue("-Dorg.omg.PortableInterceptor.ORBInitializerClass.standard_init=org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        File jonasLibDir = new File(this.jonasRoot, "lib");
        File jonasLibEndorsedDir = new File(jonasLibDir, "endorsed");
        bootstrapTask.createJvmarg().setValue("-Djavax.rmi.CORBA.PortableRemoteObjectClass=org.ow2.carol.rmi.multi.MultiPRODelegate");
        bootstrapTask.createJvmarg().setValue("-Djava.naming.factory.initial=org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        bootstrapTask.createJvmarg().setValue("-Djava.endorsed.dirs=" + jonasLibEndorsedDir.getPath());
        bootstrapTask.createJvmarg().setValue("-Djava.rmi.server.RMIClassLoaderSpi=org.ow2.jonas.lib.bootstrap.RemoteClassLoaderSpi");
        if (this.catalinaHome != null) {
            bootstrapTask.createJvmarg().setValue("-Dcatalina.home=" + this.catalinaHome);
        }
        bootstrapTask.createJvmarg().setValue("-Dcatalina.base=" + this.jonasBase);
        if (this.jettyHome != null) {
            bootstrapTask.createJvmarg().setValue("-Djetty.home=" + this.jettyHome);
        }
        if ((javaPolicyFile = new File(jonasConfigDir = this.jonasBase + File.separator + "conf", "java.policy")).exists()) {
            bootstrapTask.createJvmarg().setValue("-Djava.security.policy=" + javaPolicyFile.getPath());
        }
        File javaAuthLoginFile = new File(jonasConfigDir, "jaas.config");
        bootstrapTask.createJvmarg().setValue("-Djava.security.auth.login.config=" + javaAuthLoginFile.getPath());
        bootstrapTask.createArg().setValue(definedClass);
        this.classpath = new Path(this.getProject(), jonasConfigDir);
        String bootJar = this.jonasRoot + File.separator + "lib" + File.separator + "common" + File.separator + "ow_jonas_bootstrap.jar";
        this.classpath.append(new Path(this.getProject(), bootJar));
        String toolsJar = System.getProperty("java.home") + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
        this.classpath.append(new Path(this.getProject(), toolsJar));
        bootstrapTask.setClasspath(this.classpath);
        bootstrapTask.setClassname(BOOTSTRAP_CLASS);
        if (this.jvmOpts != null && !this.jvmOpts.equals("")) {
            bootstrapTask.createJvmarg().setLine(this.jvmOpts);
        }
        if (this.serverName != null) {
            bootstrapTask.createArg().setValue("-n");
            bootstrapTask.createArg().setValue(this.getServerName());
        }
        return bootstrapTask;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getCatalinaHome() {
        return this.catalinaHome;
    }

    public void setCatalinaHome(String catalinaHome) {
        this.catalinaHome = catalinaHome;
    }

    public String getJettyHome() {
        return this.jettyHome;
    }

    public void setJettyHome(String jettyHome) {
        this.jettyHome = jettyHome;
    }

    public File getJonasRoot() {
        return this.jonasRoot;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }
}

