/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.ns;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ow2.carol.jndi.ns.NameService;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.TraceCarol;

public final class NameServiceManager {
    private static final int SLEEP_VALUE = 10000;
    private Map<String, NameService> nsTable;
    private static NameServiceManager singleton = null;

    private NameServiceManager() {
        ProtocolConfiguration[] protocolConfigurations;
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.NameServiceManager()");
        }
        this.nsTable = new LinkedHashMap<String, NameService>();
        for (ProtocolConfiguration protocolConfiguration : protocolConfigurations = ConfigurationRepository.getConfigurations()) {
            String configurationName = protocolConfiguration.getName();
            Protocol protocol = protocolConfiguration.getProtocol();
            NameService nsC = null;
            try {
                nsC = (NameService)Class.forName(protocol.getRegistryClassName()).newInstance();
            }
            catch (Exception e) {
                String msg = "Cannot instantiate registry class '" + protocol.getRegistryClassName() + "'";
                TraceCarol.error(msg, e);
            }
            nsC.setPort(protocolConfiguration.getPort());
            nsC.setHost(protocolConfiguration.getHost());
            nsC.setConfigProperties(protocolConfiguration.getProperties());
            this.nsTable.put(configurationName, nsC);
        }
    }

    public static NameServiceManager getNameServiceManager() {
        if (singleton == null) {
            singleton = new NameServiceManager();
        }
        return singleton;
    }

    public void startNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNS()");
        }
        for (String k : this.nsTable.keySet()) {
            NameService currentNS = this.nsTable.get(k);
            if (!currentNS.isStarted()) continue;
            throw new NameServiceException("The " + k + " name service is already started");
        }
        this.startNonStartedNS();
    }

    public void startNonStartedNS() {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS()");
        }
        for (String k : this.nsTable.keySet()) {
            NameService currentNS = this.nsTable.get(k);
            ProtocolConfiguration pc = ConfigurationRepository.getConfiguration(k);
            ConfigurationRepository.setCurrentConfiguration(pc);
            try {
                currentNS.start();
                if (!TraceCarol.isInfoCarol()) continue;
                TraceCarol.infoCarol("Name service for " + k + " is started on port " + currentNS.getPort());
            }
            catch (NameServiceException nse) {
                if (!TraceCarol.isDebugJndiCarol()) continue;
                TraceCarol.debugJndiCarol("NameServiceManager.startNonStartedNS() can not start name service: " + k);
            }
        }
    }

    public void stopNS() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("NameServiceManager.stopNS()");
        }
        for (String k : this.nsTable.keySet()) {
            NameService currentNS = this.nsTable.get(k);
            currentNS.stop();
        }
    }

    public boolean isStarted() {
        for (String k : this.nsTable.keySet()) {
            NameService currentNS = this.nsTable.get(k);
            if (!currentNS.isStarted()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        TraceCarol.configure();
        final NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
        try {
            nameServiceManager.startNonStartedNS();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        nameServiceManager.stopNS();
                    }
                    catch (Exception e) {
                        TraceCarol.error("Carol Naming ShutdownHook problem", e);
                    }
                }
            });
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

