/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class StructType
extends TypeDeclaration
implements Scope {
    private boolean written = false;
    public boolean exc;
    public MemberList memberlist = null;
    private boolean parsed = false;
    private ScopeData scopeData;

    public StructType(int n) {
        super(n);
        this.pack_name = "";
    }

    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public boolean isException() {
        return this.exc;
    }

    public Object clone() {
        StructType structType = new StructType(StructType.new_num());
        structType.pack_name = this.pack_name;
        structType.name = this.name;
        structType.memberlist = this.memberlist;
        structType.included = this.included;
        structType.token = this.token;
        structType.exc = this.exc;
        structType.scopeData = this.scopeData;
        structType.enclosing_symbol = this.enclosing_symbol;
        return structType;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String getJavaTypeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String getIDLTypeName() {
        return this.getJavaTypeName();
    }

    public boolean basic() {
        return false;
    }

    public void set_memberlist(MemberList memberList) {
        memberList.setContainingType(this);
        this.memberlist = memberList;
        this.memberlist.setPackage(this.name);
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? string + "." + this.pack_name : string;
        if (this.memberlist != null) {
            this.memberlist.setPackage(string);
        }
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            this.logger.error("was " + this.enclosing_symbol.getClass().getName() + " now: " + idlSymbol.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
        boolean bl = false;
        if (this.parsed) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parsing Struct " + this.name);
        }
        this.escapeName();
        ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(StructType.new_num());
        try {
            ScopedName.definePseudoScope(this.full_name());
            constrTypeSpec.c_type_spec = this;
            NameTable.define(this.full_name(), "type-struct");
            TypeMap.typedef(this.full_name(), constrTypeSpec);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            if (this.exc) {
                parser.error("Struct " + this.getJavaTypeName() + " already defined", this.token);
            }
            if (parser.get_pending(this.full_name()) != null) {
                if (this.memberlist != null) {
                    bl = true;
                }
                if (!this.full_name().equals("org.omg.CORBA.TypeCode") && this.memberlist != null) {
                    TypeMap.replaceForwardDeclaration(this.full_name(), constrTypeSpec);
                }
            }
            parser.error("Struct " + this.getJavaTypeName() + " already defined", this.token);
        }
        if (this.memberlist != null) {
            ScopedName.addRecursionScope(this.getJavaTypeName());
            this.memberlist.parse();
            ScopedName.removeRecursionScope(this.getJavaTypeName());
            if (!this.exc) {
                NameTable.parsed_interfaces.put(this.full_name(), "");
                parser.remove_pending(this.full_name());
            }
        } else if (!bl && !this.exc) {
            parser.set_pending(this.full_name());
        }
        this.parsed = true;
    }

    public String className() {
        String string = this.getJavaTypeName();
        if (string.indexOf(46) > 0) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    public String printReadExpression(String string) {
        return this.toString() + "Helper.read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        return this.toString() + "Helper.write(" + string2 + "," + string + ");";
    }

    public String holderName() {
        return this.getJavaTypeName() + "Holder";
    }

    public String getTypeCodeExpression() {
        return this.full_name() + "Helper.type()";
    }

    public String getTypeCodeExpression(Set set) {
        if (set.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        return this.getTypeCodeExpression();
    }

    private void printClassComment(String string, PrintWriter printWriter) {
        printWriter.println("/**");
        printWriter.println(" *\tGenerated from IDL definition of " + (this.exc ? "exception " : "struct ") + "\"" + string + "\"");
        printWriter.println(" *\t@author JacORB IDL compiler ");
        printWriter.println(" */\n");
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + string + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        this.printImport(printWriter);
        this.printClassComment(string, printWriter);
        printWriter.println("public" + parser.getFinalString() + " class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + this.getJavaTypeName() + " value;\n");
        printWriter.println("\tpublic " + string + "Holder ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder(final " + this.getJavaTypeName() + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.getJavaTypeName() + "Helper.type ();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(final org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + this.getJavaTypeName() + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(final org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + this.getJavaTypeName() + "Helper.write(_out, value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        Declarator declarator;
        IdlSymbol idlSymbol;
        Enumeration enumeration;
        Object object;
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + string + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        this.printImport(printWriter);
        this.printClassComment(string, printWriter);
        printWriter.println("public" + parser.getFinalString() + " class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = null;");
        printWriter.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        printWriter.println("\t{");
        printWriter.println("\t\tif (_type == null)");
        printWriter.println("\t\t{");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("org.omg.CORBA.ORB.init().create_" + (this.exc ? "exception" : "struct") + "_tc(" + this.getJavaTypeName() + "Helper.id(),\"" + this.className() + "\",");
        if (this.memberlist != null) {
            stringBuffer.append("new org.omg.CORBA.StructMember[]{");
            object = this.memberlist.v.elements();
            while (object.hasMoreElements()) {
                enumeration = (Member)object.nextElement();
                idlSymbol = ((Member)((Object)enumeration)).declarator;
                stringBuffer.append("new org.omg.CORBA.StructMember(\"" + idlSymbol.name() + "\", ");
                stringBuffer.append(((Member)((Object)enumeration)).type_spec.typeSpec().getTypeCodeExpression());
                stringBuffer.append(", null)");
                if (!object.hasMoreElements()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("new org.omg.CORBA.StructMember[0]");
        }
        stringBuffer.append(")");
        printWriter.println("\t\t\t_type = " + stringBuffer.toString() + ";");
        printWriter.println("\t\t}");
        printWriter.println("\t\treturn _type;");
        printWriter.println("\t}\n");
        object = this.getJavaTypeName();
        TypeSpec.printInsertExtractMethods(printWriter, (String)object);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + (String)object + " read (final org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + (String)object + " result = new " + (String)object + "();");
        if (this.exc) {
            printWriter.println("\t\tif (!in.read_string().equals(id())) throw new org.omg.CORBA.MARSHAL(\"wrong id\");");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                idlSymbol = (Member)enumeration.nextElement();
                declarator = ((Member)idlSymbol).declarator;
                printWriter.println("\t\t" + ((Member)idlSymbol).type_spec.typeSpec().printReadStatement("result." + declarator.name(), "in"));
            }
        }
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + (String)object + " s)");
        printWriter.println("\t{");
        if (this.exc) {
            printWriter.println("\t\tout.write_string(id());");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                idlSymbol = (Member)enumeration.nextElement();
                declarator = ((Member)idlSymbol).declarator;
                printWriter.println("\t\t" + ((Member)idlSymbol).type_spec.typeSpec().printWriteStatement("s." + declarator.name(), "out"));
            }
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printStructClass(String string, PrintWriter printWriter) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + string + " - illegal in JDK1.4", this.token);
        }
        String string2 = string;
        if (!this.pack_name.equals("")) {
            string2 = this.pack_name + "." + string;
            printWriter.println("package " + this.pack_name + ";");
        }
        this.printImport(printWriter);
        this.printClassComment(string, printWriter);
        printWriter.println("public" + parser.getFinalString() + " class " + string);
        if (this.exc) {
            printWriter.println("\textends org.omg.CORBA.UserException");
        } else {
            printWriter.println("\timplements org.omg.CORBA.portable.IDLEntity");
        }
        printWriter.println("{");
        if (this.exc) {
            printWriter.println("\tpublic " + string + "()");
            printWriter.println("\t{");
            printWriter.println("\t\tsuper(" + string2 + "Helper.id());");
            printWriter.println("\t}");
            printWriter.println();
            if (this.memberlist == null) {
                printWriter.println("\tpublic " + string + "(String value)");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(value);");
                printWriter.println("\t}");
            }
        } else {
            printWriter.println("\tpublic " + string + "(){}");
        }
        if (this.memberlist != null) {
            Declarator declarator;
            Member member;
            Enumeration enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                ((Member)enumeration.nextElement()).member_print(printWriter, "\tpublic ");
                printWriter.println();
            }
            if (this.exc) {
                printWriter.print("\tpublic " + string + "(");
                printWriter.print("java.lang.String _reason,");
                enumeration = this.memberlist.v.elements();
                while (enumeration.hasMoreElements()) {
                    member = (Member)enumeration.nextElement();
                    declarator = member.declarator;
                    printWriter.print(member.type_spec.toString() + " " + declarator.toString());
                    if (!enumeration.hasMoreElements()) continue;
                    printWriter.print(", ");
                }
                printWriter.println(")");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(" + string2 + "Helper.id()+ \" \" + _reason);");
                enumeration = this.memberlist.v.elements();
                while (enumeration.hasMoreElements()) {
                    member = (Member)enumeration.nextElement();
                    declarator = member.declarator;
                    printWriter.print("\t\tthis.");
                    printWriter.print(declarator.name());
                    printWriter.print(" = ");
                    printWriter.println(declarator.name() + ";");
                }
                printWriter.println("\t}");
            }
            printWriter.print("\tpublic " + string + "(");
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.print(member.type_spec.toString() + " " + declarator.name());
                if (!enumeration.hasMoreElements()) continue;
                printWriter.print(", ");
            }
            printWriter.println(")");
            printWriter.println("\t{");
            if (this.exc) {
                printWriter.println("\t\tsuper(" + string2 + "Helper.id());");
            }
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.print("\t\tthis.");
                printWriter.print(declarator.name());
                printWriter.print(" = ");
                printWriter.println(declarator.name() + ";");
            }
            printWriter.println("\t}");
        }
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        this.setPrintPhaseNames();
        if (!this.parsed) {
            throw new ParseException("Unparsed Struct!");
        }
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            this.written = true;
            try {
                PrintWriter printWriter2;
                String string;
                File file;
                String string2 = this.className();
                String string3 = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File file2 = new File(string3);
                if (!file2.exists() && !file2.mkdirs()) {
                    parser.fatal_error("Unable to create " + string3, null);
                }
                if (GlobalInputStream.isMoreRecentThan(file = new File(file2, string = string2 + ".java"))) {
                    printWriter2 = new PrintWriter(new FileWriter(file));
                    this.printStructClass(string2, printWriter2);
                    printWriter2.close();
                }
                if (GlobalInputStream.isMoreRecentThan(file = new File(file2, string = string2 + "Holder.java"))) {
                    printWriter2 = new PrintWriter(new FileWriter(file));
                    this.printHolderClass(string2, printWriter2);
                    printWriter2.close();
                }
                if (GlobalInputStream.isMoreRecentThan(file = new File(file2, string = string2 + "Helper.java"))) {
                    printWriter2 = new PrintWriter(new FileWriter(file));
                    this.printHelperClass(string2, printWriter2);
                    printWriter2.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("File IO error" + iOException);
            }
        }
    }

    public void accept(IDLTreeVisitor iDLTreeVisitor) {
        iDLTreeVisitor.visitStruct(this);
    }
}

