/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal.enroller;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.DiscoveryEvent;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.internal.enroller.Enroller;
import org.ow2.jonas.discovery.internal.utils.DiscoveryHelper;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.util.Log;

public class DiscoveryListener
implements Runnable {
    public static final String DISCOVERY_TYPE = "jonas.management.discovery";
    private static int RECEIVE_BUFFER_SIZE = 1024;
    private int port;
    private InetAddress groupAddress;
    private int ttl = 1;
    private MulticastSocket multicastSocket;
    private boolean notStopped = true;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");

    public DiscoveryListener(Enroller enroller) {
        this.port = enroller.getListeningPort();
        try {
            this.groupAddress = InetAddress.getByName(enroller.getListeningIp());
            this.ttl = enroller.getTimeToLive();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    private void join() {
        try {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setTimeToLive(this.ttl);
            this.multicastSocket.joinGroup(this.groupAddress);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("multicast ip address is " + this.groupAddress));
                logger.log(BasicLevel.DEBUG, (Object)("multicast port is " + this.port));
            }
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"io problem");
            e.printStackTrace();
        }
    }

    private DatagramPacket getDatagram(int length) {
        return new DatagramPacket(new byte[length], length);
    }

    public void run() {
        this.join();
        try {
            while (this.notStopped) {
                DatagramPacket datagram = null;
                Object objReceived = null;
                try {
                    datagram = this.getDatagram(RECEIVE_BUFFER_SIZE);
                    this.multicastSocket.receive(datagram);
                    objReceived = DiscoveryHelper.bytesToObject((byte[])datagram.getData());
                }
                catch (RuntimeException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                catch (IOException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                if (objReceived != null && objReceived instanceof DiscEvent) {
                    DiscEvent event = (DiscEvent)objReceived;
                    event.setSourceAddress(datagram.getAddress().getHostAddress());
                    DomainMonitor dm = DomainMonitor.getInstance();
                    if (dm == null) {
                        logger.log(BasicLevel.WARN, (Object)"No DomainMonitor");
                    } else {
                        dm.discoveryNotification((DiscoveryEvent)event);
                    }
                }
                datagram = null;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.DEBUG, (Object)("Following exception ocuured in DiscoveryListener: " + e));
        }
    }

    public void stopListener() {
        this.notStopped = false;
    }
}

