/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.client.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.client.boot.ClassLoaderProvider;

public class Bootstrap {
    public static void main(String[] args) throws Exception {
        String jroot = System.getProperty("jonas.root");
        File root = new File(jroot);
        File lib = new File(root, "lib");
        File libBundles = new File(lib, "bundles");
        ClassLoaderProvider provider = new ClassLoaderProvider();
        provider.setParentClassLoader(Bootstrap.class.getClassLoader());
        provider.addWatchDirectory(lib);
        provider.addWatchDirectory(libBundles);
        provider.setTargetJarFile(new File(lib, "client.jar"));
        provider.addExclusionPattern("org/apache/tomcat");
        provider.addExclusionPattern("org/apache/catalina");
        provider.addExclusionPattern("org/apache/coyote");
        provider.addExclusionPattern("org/bouncycastle");
        provider.addExclusionPattern("org/mortbay");
        provider.addExclusionPattern("META-INF/maven");
        provider.addExclusionPattern("META-INF/BCKEY");
        ClassLoader loader = null;
        try {
            loader = provider.createClassLoader();
        }
        catch (Exception e) {
            System.err.println("Cannot create Client ClassLoader");
            throw e;
        }
        Method main = null;
        if (args == null || args.length == 0) {
            return;
        }
        String classname = args[0];
        try {
            Class<?> clazz = loader.loadClass(classname);
            main = clazz.getDeclaredMethod("main", String[].class);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot load class: '" + classname + "': " + e.getMessage());
            throw e;
        }
        catch (SecurityException e) {
            System.err.println("Permission denied on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        catch (NoSuchMethodException e) {
            System.err.println("No main(String[]) method on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            main.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e;
            }
        }
        catch (Exception e) {
            System.err.println("Cannot execute main(String[]) method on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

