/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.client.boot;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.url.URLUtils;

public class ClassLoaderProvider {
    private List<File> watched;
    private ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private File target;
    private List<String> content;
    private List<String> exclusions;

    public ClassLoaderProvider() {
        this.watched = new ArrayList<File>();
        this.content = new ArrayList<String>();
        this.exclusions = new ArrayList<String>();
    }

    public ClassLoader createClassLoader() throws Exception {
        if (!this.target.exists() || this.isOutOfDate()) {
            this.createTargetJarFile();
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{URLUtils.fileToURL(this.target)}, this.parent);
        return loader;
    }

    private void createTargetJarFile() throws IOException {
        System.out.println("Creating " + this.target + " from " + this.watched + " ...");
        if (this.target.exists()) {
            this.target.delete();
        }
        Manifest m = new Manifest();
        FileOutputStream os = new FileOutputStream(this.target);
        JarOutputStream jos = new JarOutputStream((OutputStream)os, m);
        this.content.add("META-INF/MANIFEST.MF");
        for (File directory : this.watched) {
            File[] childs = directory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar") && !pathname.equals(ClassLoaderProvider.this.target);
                }
            });
            for (int i = 0; i < childs.length; ++i) {
                File bundle = childs[i];
                JarFile jf = new JarFile(bundle);
                this.pack(jf, jos);
                Manifest manifest = jf.getManifest();
                String bundleClasspath = manifest.getMainAttributes().getValue("Bundle-Classpath");
                if (bundleClasspath != null) {
                    IDeployable<?> dep = null;
                    try {
                        IArchive archive = ArchiveManager.getInstance().getArchive(bundle);
                        dep = DeployableHelper.getDeployable(archive);
                        dep = UnpackDeployableHelper.unpack(dep, "unpacked");
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException("Unable to unpack " + bundle);
                        ioe.initCause(e);
                        throw ioe;
                    }
                    String[] pathElements = bundleClasspath.split(",");
                    for (int j = 0; j < pathElements.length; ++j) {
                        String path = pathElements[j];
                        if (".".equals(path)) continue;
                        URL url = null;
                        try {
                            url = dep.getArchive().getResource(path);
                        }
                        catch (ArchiveException e) {
                            IOException ioe = new IOException("Unable to get resource " + path + " from " + bundle);
                            ioe.initCause(e);
                            throw ioe;
                        }
                        this.pack(new JarFile(URLUtils.urlToFile(url)), jos);
                    }
                }
                jf.close();
            }
        }
        jos.flush();
        jos.close();
    }

    private void pack(JarFile source, JarOutputStream jos) throws IOException {
        Enumeration<JarEntry> e = source.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.getName().endsWith(".jar") || this.content.contains(entry.getName()) || this.match(entry.getName())) continue;
            InputStream is = source.getInputStream(entry);
            JarEntry je = new JarEntry(entry.getName());
            jos.putNextEntry(je);
            int read = 0;
            int MAX = 4096;
            byte[] buffer = new byte[MAX];
            while ((read = is.read(buffer)) != -1) {
                jos.write(buffer, 0, read);
            }
            this.content.add(entry.getName());
            is.close();
        }
    }

    private boolean match(String name) {
        for (String pattern : this.exclusions) {
            boolean match = name.startsWith(pattern);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean isOutOfDate() {
        final long lastTargetChange = this.target.lastModified();
        boolean aligned = true;
        for (File directory : this.watched) {
            File[] newer = directory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar") && pathname.lastModified() > lastTargetChange;
                }
            });
            if (newer.length == 0) continue;
            aligned &= false;
        }
        return !aligned;
    }

    public void setParentClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    public void addWatchDirectory(File dir) {
        this.watched.add(dir);
    }

    public void setTargetJarFile(File target) {
        this.target = target;
    }

    public void addExclusionPattern(String pattern) {
        this.exclusions.add(pattern);
    }
}

