/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator;

import org.ow2.jonas.generators.wsgen.ddmodifier.ContextDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebJettyDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityGenerator {
    private Document securityDesc = null;
    private WsEndpointDDModifier wsddm = null;
    private ContextDDModifier cddm = null;
    private WebJettyDDModifier wjddm = null;
    private static final String LOGIN_CONFIG = "endpoint-login-config";
    private static final String SECURITY_CONSTRAINT = "endpoint-security-constraint";
    private static final String REALM = "endpoint-realm";
    private static final String REALM_NAME = "endpoint-realm-name";
    private static final String SECURITY_ROLE = "endpoint-security-role";
    private String realm = null;
    private String realmName = null;

    public SecurityGenerator(Document securityDesc) {
        this.securityDesc = securityDesc;
    }

    public void generate(WsEndpointDDModifier ddm, ContextDDModifier cddm, WebJettyDDModifier wjddm) {
        this.wsddm = ddm;
        this.cddm = cddm;
        this.wjddm = wjddm;
        if (this.securityDesc != null) {
            this.realm = this.getRealm();
            this.realmName = this.getRealmName();
            if (ddm != null) {
                this.addEndpointSecurity();
            }
            if (cddm != null) {
                this.addContextRealm();
            }
            if (wjddm != null) {
                this.addWebJettyRealm();
            }
        }
    }

    private void addContextRealm() {
        if (this.realm != null) {
            this.cddm.addContextRealm(this.realm);
        }
    }

    private void addWebJettyRealm() {
        if (this.realm != null) {
            if (this.realmName != null) {
                this.wjddm.configRealm(this.realmName, this.realm);
            } else {
                this.wjddm.configRealm(this.realm);
            }
        }
    }

    private void addEndpointSecurity() {
        NodeList securityRoles;
        NodeList loginConfigs;
        NodeList securityConstraints = this.getEndpointSecurityConstraints();
        if (securityConstraints != null) {
            for (int i = 0; i < securityConstraints.getLength(); ++i) {
                this.removePrefix(securityConstraints.item(i));
                this.wsddm.addEndpointSecurityConstraint(securityConstraints.item(i));
            }
        }
        if ((loginConfigs = this.getEndpointLoginConfig()) != null) {
            for (int i = 0; i < loginConfigs.getLength(); ++i) {
                this.removePrefix(loginConfigs.item(i));
                this.wsddm.addEndpointLoginConfig((Element)loginConfigs.item(i));
            }
        }
        if ((securityRoles = this.getEndpointSecurityRole()) != null) {
            for (int i = 0; i < securityRoles.getLength(); ++i) {
                this.removePrefix(securityRoles.item(i));
                this.wsddm.addSecurityRole(securityRoles.item(i));
            }
        }
    }

    private Element getElement() {
        return this.securityDesc.getDocumentElement();
    }

    public NodeList getEndpointLoginConfig() {
        NodeList nodeList = this.getElement().getElementsByTagName(LOGIN_CONFIG);
        return nodeList;
    }

    public NodeList getEndpointSecurityConstraints() {
        NodeList nodeList = this.getElement().getElementsByTagName(SECURITY_CONSTRAINT);
        return nodeList;
    }

    public NodeList getEndpointSecurityRole() {
        NodeList nodeList = this.getElement().getElementsByTagName(SECURITY_ROLE);
        return nodeList;
    }

    public String getRealm() {
        NodeList nodeList = this.getElement().getElementsByTagName(REALM);
        Node node = nodeList.item(0);
        if (node != null && node.hasChildNodes()) {
            Node realmNode = nodeList.item(0).getFirstChild();
            this.realm = realmNode.getNodeValue();
        }
        return this.realm;
    }

    public String getRealmName() {
        String realmName = null;
        NodeList nodeList = this.getElement().getElementsByTagName(REALM_NAME);
        Node node = nodeList.item(0);
        if (node != null && node.hasChildNodes()) {
            Node realmNameNode = nodeList.item(0).getFirstChild();
            realmName = realmNameNode.getNodeValue();
        }
        return realmName;
    }

    public Document getSecurityDesc() {
        return this.securityDesc;
    }

    private void removePrefix(Node node) {
        if (node != null) {
            if (node.getPrefix() != null) {
                node.setPrefix(null);
            }
            if (node.hasChildNodes()) {
                for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                    this.removePrefix(node.getChildNodes().item(i));
                }
            }
        }
    }
}

