/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.archive;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.osgi.framework.BundleContext;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleArchive
implements IArchive {
    private BundleContext bc = null;

    public BundleArchive(BundleContext bc) {
        this.bc = bc;
    }

    public boolean close() {
        return true;
    }

    public String getName() {
        return this.bc.getBundle().getSymbolicName();
    }

    public URL getResource(String resourceName) throws ArchiveException {
        return this.bc.getBundle().getResource(resourceName);
    }

    public Iterator<URL> getResources() throws ArchiveException {
        URL url;
        Enumeration e = this.bc.getBundle().findEntries("", "*.jar", true);
        ArrayList<URL> list = new ArrayList<URL>();
        if (e != null) {
            while (e.hasMoreElements()) {
                url = (URL)e.nextElement();
                URL jarURL = null;
                try {
                    jarURL = new URL("jar:" + url + "!/");
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                JarURLConnection connection = null;
                try {
                    connection = (JarURLConnection)jarURL.openConnection();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                JarFile jf = null;
                try {
                    jf = connection.getJarFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    URL entryURL = null;
                    try {
                        entryURL = new URL(jarURL, entry.getName());
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                    list.add(entryURL);
                }
                try {
                    jf.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if ((e = this.bc.getBundle().findEntries("", "*", true)) != null) {
            while (e.hasMoreElements()) {
                url = (URL)e.nextElement();
                list.add(url);
            }
        }
        return list.iterator();
    }

    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(this.getResource(resourceName));
        return list.iterator();
    }

    public URL getURL() throws ArchiveException {
        return this.bc.getBundle().getEntry("/");
    }
}

