/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.client;

import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManager;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManagerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CMIClientClassLoader
extends ClassLoader {
    private static Log logger = LogFactory.getLog(CMIClientClassLoader.class);
    private final ClientClusterViewManager clientClusterViewManager;

    public CMIClientClassLoader(ClassLoader parent, ClientClusterViewManager clientClusterViewManager) {
        super(parent);
        this.clientClusterViewManager = clientClusterViewManager;
    }

    @Override
    protected synchronized Class<?> findClass(String binaryName) throws ClassNotFoundException {
        logger.debug((Object)"Downloading {0}...", new Object[]{binaryName});
        try {
            byte[] bytes = this.clientClusterViewManager.getBytecode(binaryName);
            return this.defineClass(binaryName, bytes, 0, bytes.length);
        }
        catch (ClientClusterViewManagerException e) {
            throw new ClassNotFoundException();
        }
    }
}

