/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.data.LBPolicyData;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ServerRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
final class ClientClusterViewCache {
    private static final Map<String, LBPolicyData> LBPOLICYDATA = new ConcurrentHashMap<String, LBPolicyData>();
    private static final Map<String, Class<?>> ITFNAMES = new ConcurrentHashMap();
    private static final Map<String, Boolean> REPLICATED_OBJECTS = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Class<? extends EJBObject>> BUSINESSNAMES = new ConcurrentHashMap<String, Class<? extends EJBObject>>();
    private static final Map<String, Class<? extends ILBPolicy>> LBPOLICYCLASSES = new ConcurrentHashMap<String, Class<? extends ILBPolicy>>();
    private static final Map<String, Class<? extends ILBStrategy>> LBSTRATEGYCLASS = new ConcurrentHashMap<String, Class<? extends ILBStrategy>>();
    private static final Map<String, List<CMIReference>> CMIREFERENCES = new ConcurrentHashMap<String, List<CMIReference>>();
    private static final Map<ServerRef, Integer> LOAD_FACTORS = new ConcurrentHashMap<ServerRef, Integer>();

    private ClientClusterViewCache() {
    }

    static void setLBPolicyData(String objectName, LBPolicyData lbPolicyData) {
        LBPOLICYDATA.put(objectName, lbPolicyData);
    }

    static LBPolicyData getLBPolicyData(String objectName) {
        return LBPOLICYDATA.get(objectName);
    }

    static void setItfName(String objectName, Class<?> itfName) {
        ITFNAMES.put(objectName, itfName);
    }

    static Class<?> getItfName(String objectName) {
        return ITFNAMES.get(objectName);
    }

    static void setBusinessName(String objectName, Class<? extends EJBObject> businessName) {
        BUSINESSNAMES.put(objectName, businessName);
    }

    public static Class<? extends EJBObject> getBusinessName(String objectName) {
        return BUSINESSNAMES.get(objectName);
    }

    static Class<? extends ILBPolicy> getLBPolicyClass(String objectName) {
        return LBPOLICYCLASSES.get(objectName);
    }

    static void setLBPolicyClass(String objectName, Class<? extends ILBPolicy> lbPolicyClass) {
        LBPOLICYCLASSES.put(objectName, lbPolicyClass);
    }

    static void setCMIReferences(String objectName, List<CMIReference> cmiReferences) {
        CMIREFERENCES.put(objectName, cmiReferences);
    }

    static List<CMIReference> getCMIReferences(String objectName) {
        return CMIREFERENCES.get(objectName);
    }

    static Class<? extends ILBStrategy> getLBStrategyClass(String objectName) {
        return LBSTRATEGYCLASS.get(objectName);
    }

    static void setLBStrategyClass(String objectName, Class<? extends ILBStrategy> lbStrategyClass) {
        LBSTRATEGYCLASS.put(objectName, lbStrategyClass);
    }

    static int getLoadFactor(ServerRef serverRef) {
        return LOAD_FACTORS.get(serverRef);
    }

    static void setLoadFactor(ServerRef serverRef, int loadFactor) {
        LOAD_FACTORS.put(serverRef, loadFactor);
    }

    static Set<ServerRef> getAddressesOfServer() {
        return LOAD_FACTORS.keySet();
    }

    static Set<String> getObjectNames() {
        return new HashSet<String>(ITFNAMES.keySet());
    }

    static boolean isReplicated(String objectName) {
        return REPLICATED_OBJECTS.get(objectName);
    }

    static void setReplicated(String objectName, boolean replicated) {
        REPLICATED_OBJECTS.put(objectName, replicated);
    }
}

