/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.provider;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.annotation.Cluster;
import org.ow2.carol.cmi.annotation.LBPolicy;
import org.ow2.carol.cmi.annotation.LBStrategy;
import org.ow2.carol.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.carol.cmi.controller.provider.ClientClusterViewProviderException;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.lb.policy.FirstAvailablePolicy;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.strategy.LocalPreference;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cluster(name="System")
@LBPolicy(value=FirstAvailablePolicy.class)
@LBStrategy(value=LocalPreference.class)
@ThreadSafe
public class ClusteredClientClusterViewProvider
extends PortableRemoteObject
implements ClientClusterViewProvider {
    private static Log logger = LogFactory.getLog(ClusteredClientClusterViewProvider.class);
    private final ServerClusterViewManager serverClusterViewManager;
    private static final int BUF_APPEND = 1000;

    public ClusteredClientClusterViewProvider(ServerClusterViewManager serverClusterViewManager) throws RemoteException {
        this.serverClusterViewManager = serverClusterViewManager;
    }

    @Override
    public Class<? extends ILBPolicy> getLBPolicyClass(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getLBPolicyClass(objectName);
    }

    @Override
    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getCMIReferences(objectName, protocolName);
    }

    @Override
    public String getItfName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getItfName(objectName);
    }

    @Override
    public String getBusinessName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getBusinessName(objectName);
    }

    @Override
    public Map<String, Object> getPropertiesForLBPolicy(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getPropertiesForLBPolicy(objectName);
    }

    @Override
    public long getDateOfProperties(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getDateOfProperties(objectName);
    }

    @Override
    public byte[] getBytecode(String binaryName) throws RemoteException, ClientClusterViewProviderException {
        String encodedClassName = binaryName.replaceAll("\\.", "/").concat(".class");
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(encodedClassName);
        byte[] bytecode = null;
        try {
            bytecode = ClusteredClientClusterViewProvider.readClass(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)"Cannot read class {0}", new Object[]{binaryName, e});
            throw new ClientClusterViewProviderException("Cannot read class " + binaryName, e);
        }
        return bytecode;
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    @Override
    public boolean isClustered(String name) throws RemoteException {
        return this.serverClusterViewManager.isClustered(name);
    }

    @Override
    public String getLBPolicyClassName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getLBPolicyClassName(objectName);
    }

    @Override
    public int getDelayToRefresh() throws RemoteException {
        return this.serverClusterViewManager.getDelayToRefresh();
    }

    @Override
    public String getClusterName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getClusterName(objectName);
    }

    @Override
    public Class<? extends ILBStrategy> getLBStrategyClass(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getLBStrategyClass(objectName);
    }

    @Override
    public int getMaxPoolSize(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getMaxPoolSize(objectName);
    }

    @Override
    public int getMinPoolSize(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getMinPoolSize(objectName);
    }

    @Override
    public String getLBStrategyClassName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getLBStrategyClassName(objectName);
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.isPoolToEmpty(objectName);
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) throws RemoteException, ServerNotFoundException {
        return this.serverClusterViewManager.getLoadFactor(serverRef);
    }

    @Override
    public void registerClient(UUID uuid) throws RemoteException {
        this.serverClusterViewManager.registerClient(uuid);
    }

    @Override
    public boolean isReplicated(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.isReplicated(objectName);
    }
}

