@Echo Off
Rem ---------------------------------------------------------------------------
Rem JOnAS: Java(TM) Open Application Server
Rem Copyright (C) 1999-2005 Bull S.A.
Rem Contact: jonas-team@objectweb.org
Rem
Rem This library is free software; you can redistribute it and/or
Rem modify it under the terms of the GNU Lesser General Public
Rem License as published by the Free Software Foundation; either
Rem version 2.1 of the License, or any later version.
Rem
Rem This library is distributed in the hope that it will be useful,
Rem but WITHOUT ANY WARRANTY; without even the implied warranty of
Rem MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Rem Lesser General Public License for more details.
Rem
Rem You should have received a copy of the GNU Lesser General Public
Rem License along with this library; if not, write to the Free Software
Rem Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
Rem USA
Rem
Rem Initial developer(s): Philippe Durieux
Rem Contributor(s): Miroslav Halas
Rem        Adriana Danes :
Rem          - Change /config en /conf
Rem          - Use JONAS_BASE
Rem        Jerome Pioux:
Rem        - Remove extra spaces in :start_jonas_bg after %JAVA% - was causing
Rem          bug #306113 - happen only if the script is used from the tarball
Rem          (UNIX format [LF]). As a side note, with 4.8.3, the script will
Rem          be saved as DOS format [CRLF] inside SVN.
Rem        eyindanga:
Rem        - Start JOnAS on OSGi.
Rem
Rem ---------------------------------------------------------------------------
Rem $Id: j5.bat 12451 2007-12-15 03:20:04Z benoitf $
Rem ---------------------------------------------------------------------------

Rem Keep variables local to this script
setlocal ENABLEDELAYEDEXPANSION

echo *******************************************************************
echo *                 JOnAS 5 - OSGi on Windows platform              *
echo *                 JOnAS 5: Java(TM) Open Application Server       *
echo *                 http://jonas.ow2.org                            *
echo *                 Contact: jonas-team@ow2.org                     *
echo *******************************************************************

Rem %~f0 is the script path
Rem ---------------------------------------------
Rem set environment
Rem ---------------------------------------------
if ["%JONAS_ROOT%"]==[""] goto setroot
if ["%JONAS_BASE%"]==[""] set JONAS_BASE="%JONAS_ROOT%"
set JONAS_LIB="%JONAS_ROOT%"\lib
Set JONAS_CLASSPATH="%JONAS_CLASSPATH%";"%JAVA_HOME%"\lib\tools.jar
Rem include jonas classes
set JONAS_CLASSPATH="%JONAS_ROOT%"\lib\bootstrap\felix-launcher.jar
set COMMANDS_CLASSPATH="%JONAS_ROOT%"\lib\jonas-commands.jar;"%JONAS_ROOT%"\lib\carol.jar;"%JONAS_ROOT%"\lib\commons-logging.jar
set CLIENT_BOOTSTRAP="%JONAS_ROOT%"\lib\bootstrap\client-bootstrap.jar

Rem ---------------------------------------------
Rem set JAVA_OPTS
Rem ---------------------------------------------
Rem JAVA_HOME must be  set since config_env.bat requires it for tools.jar
if ["%JAVA_HOME%"]==[""] goto setjava

Rem JONAS_OPTS may be already partially initialized
set JONAS_OPTS=%JONAS_OPTS% -Djonas.root=%JONAS_ROOT%
set JONAS_OPTS=%JONAS_OPTS% -Djonas.base=%JONAS_BASE%
set JONAS_OPTS=%JONAS_OPTS% -Djava.security.manager
set JONAS_OPTS=%JONAS_OPTS% -Djava.security.policy=%JONAS_ROOT%\conf\java.policy
set JONAS_OPTS=%JONAS_OPTS% -Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB
set JONAS_OPTS=%JONAS_OPTS% -Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton
set JONAS_OPTS=%JONAS_OPTS% -Dorg.omg.PortableInterceptor.ORBInitializerClass.standard_init=org.jacorb.orb.standardInterceptors.IORInterceptorInitializer
set JONAS_OPTS=%JONAS_OPTS% -Djavax.rmi.CORBA.PortableRemoteObjectClass=org.ow2.carol.rmi.multi.MultiPRODelegate
set JONAS_OPTS=%JONAS_OPTS% -Djava.naming.factory.initial=org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory
set JONAS_OPTS=%JONAS_OPTS% -Djavax.rmi.CORBA.UtilClass=org.ow2.carol.util.delegate.UtilDelegateImpl
set JONAS_OPTS=%JONAS_OPTS% -Djava.security.auth.login.config=%JONAS_BASE%\conf\jaas.config
set JONAS_OPTS=%JONAS_OPTS% -Djava.endorsed.dirs=%JONAS_ROOT%\lib\endorsed

Rem ---------------------------------------------
Rem Get args
Rem ---------------------------------------------

if [%1]==[]   goto no_arg

set ARGS=
set MODE=
set JONASNAME="jonas"
set PINGTIMEOUT=
set NAME_OPT=
set PINGTIMEOUT_OPT=
set ANNOTATE=
set WHERE=background
set HEADLESS=-Djava.awt.headless=true
set START_OPTS="-Djonas.cache.clean=true"
set JAVA="%JAVA_HOME%\bin\java.exe"
:loop_on_args
set VALUE=%~1
if [%1]==[start]     goto start_arg
if [%1]==[stop]      goto stop_arg
if [%1]==[halt]      goto halt_arg
if [%1]==[admin]     goto admin_arg
if [%1]==[version]   goto version_arg
if [%1]==[check]     goto check_arg
if [%1]==[bootstrap] goto bootstrap_arg
if [%1]==[-fg]       goto fg_arg
if [%1]==[-bg]       goto bg_arg
if [%1]==[-win]      goto win_arg
if [%1]==[-n]        goto n_arg
if [%1]==[-timeout]  goto timeout_arg
if [%1]==[-cp]       goto cp_arg
if [%1]==[-debug]    goto debug_arg
if [%1]==[-target]   goto target_arg
if [%1]==[-gui]      goto gui_arg
if [%1]==[-tui]      goto tui_arg
if [%1]==[-dev]      goto dev_arg
if %VALUE:~0,2%==-D  goto java_opts
set ARGS=%ARGS% %1
goto next_arg

Rem Add -D System Properties
:java_opts
Set PROP=%~1
shift
Set PROP=%PROP%=%1
Set JONAS_OPTS=%JONAS_OPTS% %PROP%
Set START_OPTS=%START_OPTS% %PROP%
goto next_arg

:gui_arg
echo Start Felix GUI with JOnAS.
set START_OPTS=%START_OPTS% -Djonas.felix.gui.enabled=true
set HEADLESS=
goto next_arg

:tui_arg
echo Start Felix TUI with JOnAS.
set START_OPTS=%START_OPTS% -Djonas.felix.tui.enabled=true
goto next_arg

:dev_arg
echo "JOnAS Starts in developer mode."
set START_OPTS=%START_OPTS% -Djonas.developer=true
goto next_arg

:start_arg
Rem ---------------------------------------------
rem Proxy parameters
Rem ---------------------------------------------
set MODE=start
set CLASS_TO_RUN=org.ow2.jonas.launcher.felix.JOnAS
set JONAS_CLASSPATH=%JONAS_BASE%\conf;%JONAS_CLASSPATH%
goto next_arg


:stop_arg
set MODE=stop
set JONAS_CLASSPATH=%JONAS_BASE%\conf;%JONAS_CLASSPATH%
set CLASS_TO_RUN=org.ow2.jonas.commands.admin.ClientAdmin -s
goto next_arg

:halt_arg
set MODE=halt
set JONAS_CLASSPATH=%JONAS_BASE%\conf;%JONAS_CLASSPATH%
set CLASS_TO_RUN=org.ow2.jonas.commands.admin.ClientAdmin -halt
goto next_arg

:admin_arg
set MODE=admin
set CLASS_TO_RUN=org.ow2.jonas.commands.admin.ClientAdmin
echo JONAS_BASE is set to %JONAS_BASE%
goto next_arg

:version_arg
set MODE=version
set CLASS_TO_RUN=org.ow2.jonas.Version
goto next_arg

:check_arg
set MODE=check
set CLASS_TO_RUN=org.ow2.jonas.commands.check.CheckEnv
echo JONAS_BASE is set to %JONAS_BASE%
goto next_arg


:fg_arg
set WHERE=foreground
goto next_arg

:bootstrap_arg
echo Start bootstrap only.
set START_OPTS=%START_OPTS% -Djonas.bootstrap=true
goto start_arg

:bg_arg
set WHERE=background
goto next_arg

:win_arg
set WHERE=window
goto next_arg

:n_arg
shift
set JONASNAME=%1
set NAME_OPT=-n %JONASNAME%
set JONAS_OPTS=%JONAS_OPTS% -Djonas.name="%JONASNAME%"
set START_OPTS=%START_OPTS% -Djonas.name="%JONASNAME%"
goto next_arg

:timeout_arg
shift
set PINGTIMEOUT=%1
set PINGTIMEOUT_OPT=-timeout %PINGTIMEOUT%
goto next_arg

:cp_arg
shift
set JONAS_CLASSPATH=%JONAS_CLASSPATH%;%~1
goto next_arg

:debug_arg
shift
if not [%1]==[-p] goto debug_usage
shift
set JONAS_DEBUG_PORT=%1
set JONAS_DEBUG_SUSPEND=n
if not [%2]==[-s] goto set_debug_opts
shift
shift
set JONAS_DEBUG_SUSPEND=%1

:set_debug_opts
echo JOnAS Debug Info :
echo  listening on port : %JONAS_DEBUG_PORT%
echo  suspend mode : %JONAS_DEBUG_SUSPEND%
set JONAS_DEBUG_OPTS=-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=%JONAS_DEBUG_PORT%,suspend=%JONAS_DEBUG_SUSPEND%
goto next_arg

:target_arg
if [%MODE%]==[start] set ARGS=%ARGS% -start
# -------------------------------------
# Not supported argument
# if [%MODE%]==[stop] set ARGS=%ARGS% -stop
# -------------------------------------
if [%MODE%]==[halt] set ARGS=%ARGS% -halt
set MODE=admin
set ARGS=%ARGS% -target
goto next_arg

:next_arg
shift
if not [%1]==[] goto loop_on_args

if [%MODE%]==[] goto no_mode

Rem ---------------------------------------------
Rem Remove RMI Annotation
Rem ---------------------------------------------
Rem set JONAS_OPTS=%JONAS_OPTS% -Djava.rmi.server.RMIClassLoaderSpi=org.ow2.jonas.lib.bootstrap.RemoteClassLoaderSpi

Rem ---------------------------------------------
Rem Set tomcat/jetty base directory
Rem ---------------------------------------------
set TOMCAT_OPTS=
set JETTY_OPTS=
if not ["%TOMCAT_BASE%"]==[""] set TOMCAT_OPTS=%TOMCAT_OPTS% -Dtomcat.base="%TOMCAT_BASE%"
if not ["%CATALINA_HOME%"]==[""] set TOMCAT_OPTS=%TOMCAT_OPTS% -Dcatalina.home="%CATALINA_HOME%"
if not ["%CATALINA_BASE%"]==[""] set TOMCAT_OPTS=%TOMCAT_OPTS% -Dcatalina.base="%CATALINA_BASE%"
if not ["%JETTY_HOME%"]==[""] set JETTY_OPTS=-Djetty.home="%JETTY_HOME%"

Rem ---------------------------------------------
Rem Run java command
Rem ---------------------------------------------

if not [%MODE%]==[start] goto admin
if %WHERE%==foreground goto start_jonas_fg
if %WHERE%==background goto start_jonas_bg
if %WHERE%==window     goto start_jonas_window
goto :EOF

set START_OPTS=%STAT_OPTS% %HEADLESS%

:start_jonas_fg
REM start JOnAS in foreground
%JAVA% %JAVA_OPTS% %START_OPTS% %JONAS_OPTS% -cp %JONAS_CLASSPATH% %JONAS_DEBUG_OPTS% %ARGS% %CLASS_TO_RUN%
goto :EOF

:start_jonas_bg
REM start JOnAS in Background mode
start /B "JOnAS" %JAVA% %JAVA_OPTS% %START_OPTS% %JONAS_OPTS% -cp %JONAS_CLASSPATH% %JONAS_DEBUG_OPTS% %ARGS% %CLASS_TO_RUN%
start /B "Client" %JAVA% %JONAS_OPTS% -jar %CLIENT_BOOTSTRAP%
REM %JAVA% %JAVA_OPTS% %JONAS_OPTS% -cp %JONAS_CLASSPATH% org.ow2.jonas.commands.admin.ClientAdmin -ping %PINGTIMEOUT_OPT%
goto :EOF

:start_jonas_window
set WINDOW_TITLE="%HOSTNAME%:%JONASNAME%"
if %WINDOW_TITLE%==":" set WINDOW_TITLE="JOnAS Server"
start %WINDOW_TITLE% j5 start -fg
goto :EOF

:admin
set ADMIN_CLASSPATH=%COMMANDS_CLASSPATH%;%JONAS_CLASSPATH%
%JAVA% -cp %ADMIN_CLASSPATH% %JONAS_OPTS% %TOMCAT_OPTS% %JETTY_OPTS% %CLASS_TO_RUN% %NAME_OPT% %PINGTIMEOUT_OPT% %ARGS%
goto :EOF

:setjava
echo JAVA_HOME not set.
goto :EOF

:no_mode
echo "No startup mode specified, specify start | stop | halt | admin | version | check | reboot | "
goto usage

:no_arg
echo No arguments specified.
goto usage

:usage
echo "j5 start | stop | halt | admin | version | check | ntservice | bootstrap | -fg | -bg | -win | -n | -debug | -cnhost | -cnport | -gui | -tui | -dev "
echo "Debug mode : j5 start -debug -p <debug-port> [-s <suspend:y/n>]"
REM TODO: Add here explanation for the arguments
goto :EOF

:setroot
echo JONAS_ROOT not set.
goto :EOF


:debug_usage
echo -debug option parameters are : "-debug -p <debug-port> [-s <suspend:y/n>]"
goto :EOF


