/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Logger;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;

public class ComponentFactory
implements Factory,
ManagedServiceFactory,
TrackerCustomizer {
    protected static List m_instancesName = new ArrayList();
    protected ComponentDescription m_componentDesc;
    protected Map m_componentInstances = new HashMap();
    protected Element m_componentMetadata;
    protected BundleContext m_context = null;
    protected String m_factoryName;
    protected List m_handlerIdentifiers = new ArrayList();
    protected List m_listeners = new ArrayList(5);
    protected Logger m_logger;
    protected int m_state = 0;
    protected Tracker m_tracker;
    protected boolean m_isPublic;
    private FactoryClassloader m_classLoader = null;
    private byte[] m_clazz = null;
    private String m_componentClassName = null;
    private long m_index = 0L;
    private ServiceRegistration m_sr;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public ComponentFactory(BundleContext bc, byte[] clazz, Element cm) {
        this(bc, cm);
        this.m_clazz = clazz;
    }

    public ComponentFactory(BundleContext bc, Element cm) {
        this.m_context = bc;
        this.m_componentMetadata = cm;
        if (!this.check(cm)) {
            return;
        }
        this.computeFactoryName();
        this.m_logger = new Logger(this.m_context, this.m_factoryName, 2);
        String fac = cm.getAttribute("factory");
        this.m_isPublic = fac == null || !fac.equalsIgnoreCase("false");
        this.computeRequiredHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFactoryStateListener(FactoryStateListener l) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(l);
        }
    }

    public boolean addingService(ServiceReference reference) {
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            if (hi.m_reference != null || !this.match(hi, reference)) continue;
            int oldP = hi.m_level;
            hi.setReference(reference);
            if (oldP != hi.m_level) {
                Collections.sort(this.m_handlerIdentifiers);
            }
            return true;
        }
        return false;
    }

    public void addedService(ServiceReference reference) {
        if (this.m_state == 0) {
            try {
                this.computeFactoryState();
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "The component type metadata are not correct : " + e.getMessage());
                this.stop();
            }
        }
    }

    public boolean check(Element cm) {
        this.m_componentClassName = cm.getAttribute("className");
        if (this.m_componentClassName == null) {
            System.err.println("A component needs a class name : " + cm);
            return false;
        }
        return true;
    }

    public ComponentInstance createComponentInstance(Dictionary configuration) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        return this.createComponentInstance(configuration, null);
    }

    public synchronized ComponentInstance createComponentInstance(Dictionary configuration, ServiceContext serviceContext) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        if (configuration == null) {
            configuration = new Properties();
        }
        try {
            this.checkAcceptability(configuration);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new UnacceptableConfiguration("The configuration " + configuration + " is not acceptable for " + this.m_factoryName + ": " + e.getMessage());
        }
        String n = null;
        if (configuration.get("name") != null) {
            n = (String)configuration.get("name");
            if (m_instancesName.contains(n)) {
                throw new UnacceptableConfiguration("Name already used : " + n);
            }
        } else {
            n = this.generateName();
            configuration.put("name", n);
        }
        m_instancesName.add(n);
        IPojoContext context = null;
        context = serviceContext == null ? new IPojoContext(this.m_context) : new IPojoContext(this.m_context, serviceContext);
        ArrayList<HandlerManager> handlers = new ArrayList<HandlerManager>();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            handlers.add(this.getHandlerInstance(hi, serviceContext));
        }
        InstanceManager instance = new InstanceManager(this, context, handlers.toArray(new HandlerManager[this.m_handlerIdentifiers.size()]));
        try {
            instance.configure(this.m_componentMetadata, configuration);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException(e.getMessage(), this.m_factoryName);
        }
        this.m_componentInstances.put(n, instance);
        instance.start();
        return instance;
    }

    public Class defineClass(String name, byte[] b, ProtectionDomain domain) {
        if (this.m_classLoader == null) {
            this.m_classLoader = new FactoryClassloader();
        }
        return this.m_classLoader.defineClass(name, b, domain);
    }

    public synchronized void deleted(String in) {
        m_instancesName.remove(in);
        ComponentInstance cm = (ComponentInstance)this.m_componentInstances.remove(in);
        if (cm == null) {
            return;
        }
        cm.dispose();
    }

    public ComponentDescription getComponentDescription() {
        return this.m_componentDesc;
    }

    public Element getDescription() {
        if (this.m_componentDesc == null) {
            return new Element("No description available for " + this.m_factoryName, "");
        }
        return this.m_componentDesc.getDescription();
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public List getMissingHandlers() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            if (hi.m_reference != null) continue;
            l.add(hi.getFullName());
        }
        return l;
    }

    public String getName() {
        return this.m_factoryName;
    }

    public List getRequiredHandlers() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            l.add(hi.getFullName());
        }
        return l;
    }

    public String getClassName() {
        return this.m_componentClassName;
    }

    public int getState() {
        return this.m_state;
    }

    public URL getResource(String resName) {
        return this.m_context.getBundle().getResource(resName);
    }

    public boolean isAcceptable(Dictionary conf) {
        try {
            this.checkAcceptability(conf);
        }
        catch (UnacceptableConfiguration e) {
            return false;
        }
        catch (MissingHandlerException e) {
            return false;
        }
        return true;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.m_clazz != null && className.equals(this.m_componentClassName)) {
            if (this.m_classLoader == null) {
                this.m_classLoader = new FactoryClassloader();
            }
            try {
                return this.m_classLoader.defineClass(this.m_componentClassName, this.m_clazz, null);
            }
            catch (Exception e) {
                throw new ClassNotFoundException("[Bundle " + this.m_context.getBundle().getBundleId() + "] Cannot define the class : " + className, e);
            }
        }
        return this.m_context.getBundle().loadClass(className);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        if (properties == null || properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"name\" property");
        }
        String name = (String)properties.get("name");
        InstanceManager cm = (InstanceManager)this.m_componentInstances.get(name);
        if (cm == null) {
            return;
        }
        this.checkAcceptability(properties);
        cm.reconfigure(properties);
    }

    public void removedService(ServiceReference reference, Object service) {
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            if (!reference.equals(hi.getReference())) continue;
            hi.unRef();
            try {
                this.computeFactoryState();
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "The component type metadata are not correct : " + e.getMessage());
                this.stop();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFactoryStateListener(FactoryStateListener l) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(l);
        }
    }

    public synchronized void start() {
        if (this.m_componentDesc != null) {
            return;
        }
        if (this.m_handlerIdentifiers.size() != 0) {
            try {
                String filter = "(&(objectClass=" + (class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = ComponentFactory.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName() + ")" + "(" + "handler.type" + "=" + "primitive" + ")" + "(factory.state=1)" + ")";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
                return;
            }
        }
        try {
            this.computeFactoryState();
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The component type metadata are not correct : " + e.getMessage());
            this.stop();
            return;
        }
        if (this.m_isPublic) {
            this.m_sr = this.m_context.registerService(new String[]{(class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = ComponentFactory.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName(), (class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ComponentFactory.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName()}, (Object)this, (Dictionary)this.getProperties());
        }
    }

    public synchronized void stop() {
        if (this.m_sr != null) {
            this.m_sr.unregister();
            this.m_sr = null;
        }
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
        Collection col = this.m_componentInstances.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            InstanceManager ci = (InstanceManager)it.next();
            if (ci.getState() != -1) {
                ci.kill();
            }
            m_instancesName.remove(ci.getInstanceName());
        }
        this.m_componentInstances.clear();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            ((HandlerIdentifier)this.m_handlerIdentifiers.get(i)).unRef();
        }
        this.m_tracker = null;
        this.m_componentDesc = null;
        this.m_classLoader = null;
        this.m_clazz = null;
        this.m_state = 0;
    }

    public synchronized void updated(String in, Dictionary properties) throws org.osgi.service.cm.ConfigurationException {
        InstanceManager cm = (InstanceManager)this.m_componentInstances.get(in);
        if (cm == null) {
            try {
                properties.put("name", in);
                this.createComponentInstance(properties);
            }
            catch (UnacceptableConfiguration e) {
                this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
            catch (MissingHandlerException e) {
                this.m_logger.log(1, "Handler not available : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "The Component Type metadata are not correct : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
            }
        }
        try {
            properties.put("name", in);
            this.reconfigure(properties);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The facotry is not valid, at least one handler is missing : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage());
        }
    }

    protected void checkAcceptability(Dictionary conf) throws UnacceptableConfiguration, MissingHandlerException {
        if (this.m_state == 0) {
            throw new MissingHandlerException(this.getMissingHandlers());
        }
        List props = this.m_componentDesc.getRequiredProperties();
        for (int i = 0; i < props.size(); ++i) {
            if (conf.get(props.get(i)) != null) continue;
            throw new UnacceptableConfiguration("The configuration does not contains the \"" + props.get(i) + "\" property");
        }
    }

    protected void computeDescription() throws ConfigurationException {
        this.m_componentDesc = new ComponentDescription(this);
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            HandlerManager hm = this.getHandlerInstance(hi, null);
            Handler ch = hm.getHandler();
            try {
                ch.setLogger(this.getLogger());
                ch.initializeComponentFactory(this.m_componentDesc, this.m_componentMetadata);
                ((Pojo)((Object)ch)).getComponentInstance().dispose();
                continue;
            }
            catch (ConfigurationException e) {
                ((Pojo)((Object)ch)).getComponentInstance().dispose();
                throw new ConfigurationException(e.getMessage(), this.m_factoryName);
            }
        }
    }

    protected void computeFactoryName() {
        this.m_factoryName = this.m_componentMetadata.getAttribute("name");
        if (this.m_factoryName == null) {
            this.m_factoryName = this.m_componentMetadata.getAttribute("factory");
            if (this.m_factoryName == null || this.m_factoryName.equalsIgnoreCase("true") || this.m_factoryName.equalsIgnoreCase("false")) {
                this.m_factoryName = this.m_componentMetadata.getAttribute("className");
            }
        }
    }

    protected void computeFactoryState() throws ConfigurationException {
        int i;
        boolean isValid = true;
        for (i = 0; isValid && i < this.m_handlerIdentifiers.size(); ++i) {
            HandlerIdentifier hi = (HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            isValid = hi.m_reference != null;
        }
        if (isValid) {
            if (this.m_state == 0) {
                if (this.m_componentDesc == null) {
                    this.computeDescription();
                }
                this.m_state = 1;
                if (this.m_sr != null) {
                    this.m_sr.setProperties((Dictionary)this.getProperties());
                }
                for (i = 0; i < this.m_listeners.size(); ++i) {
                    ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 1);
                }
                return;
            }
        } else if (this.m_state == 1) {
            this.m_state = 0;
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 0);
            }
            Collection col = this.m_componentInstances.values();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                InstanceManager ci = (InstanceManager)it.next();
                if (ci.getState() != -1) {
                    ci.kill();
                }
                m_instancesName.remove(ci.m_name);
            }
            this.m_componentInstances.clear();
            if (this.m_sr != null) {
                this.m_sr.setProperties((Dictionary)this.getProperties());
            }
            return;
        }
    }

    protected void computeRequiredHandlers() {
        Element[] elems = this.m_componentMetadata.getElements();
        for (int i = 0; i < elems.length; ++i) {
            HandlerIdentifier hi;
            Element current = elems[i];
            if (current.getName().equals("manipulation") || this.m_handlerIdentifiers.contains(hi = new HandlerIdentifier(current.getName(), current.getNameSpace()))) continue;
            this.m_handlerIdentifiers.add(hi);
        }
        HandlerIdentifier hi = new HandlerIdentifier("architecture", null);
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if (arch == null || arch.equalsIgnoreCase("true")) {
            this.m_handlerIdentifiers.add(hi);
        }
        HandlerIdentifier hi2 = new HandlerIdentifier("callback", null);
        String imm = this.m_componentMetadata.getAttribute("immediate");
        if (!this.m_handlerIdentifiers.contains(hi2) && imm != null && imm.equalsIgnoreCase("true")) {
            this.m_handlerIdentifiers.add(hi2);
        }
    }

    protected void disposed(ComponentInstance ci) {
        String name = ci.getInstanceName();
        m_instancesName.remove(name);
        this.m_componentInstances.remove(name);
    }

    protected synchronized String generateName() {
        String name = this.m_factoryName + "-" + this.m_index;
        while (m_instancesName.contains(name)) {
            ++this.m_index;
            name = this.m_factoryName + "-" + this.m_index;
        }
        return name;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    protected String getComponentClassName() {
        return this.m_componentClassName;
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.put("component.class", this.m_componentClassName);
        props.put("factory.name", this.m_factoryName);
        props.put("service.pid", this.m_factoryName);
        if (this.m_componentDesc != null) {
            props.put("component.providedServiceSpecifications", this.m_componentDesc.getprovidedServiceSpecification());
            props.put("component.properties", this.m_componentDesc.getProperties());
            props.put("component.description", this.m_componentDesc);
        }
        props.put("factory.state", "" + this.m_state);
        return props;
    }

    protected boolean match(HandlerIdentifier hi, ServiceReference ref) {
        String name = (String)ref.getProperty("handler.name");
        String ns = (String)ref.getProperty("handler.namespace");
        if ("org.apache.felix.ipojo".equals(ns)) {
            return name.equals(hi.m_name) && hi.m_namespace == null;
        }
        return name.equals(hi.m_name) && ns.equals(hi.m_namespace);
    }

    private HandlerManager getHandlerInstance(HandlerIdentifier hi, ServiceContext sc) {
        try {
            return (HandlerManager)hi.getFactory().createComponentInstance(null, sc);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The creation of the handler " + hi.getFullName() + " has failed: " + e.getMessage());
            this.stop();
            return null;
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The creation of the handler " + hi.getFullName() + " has failed (UnacceptableConfiguration): " + e.getMessage());
            this.stop();
            return null;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The configuration of the handler " + hi.getFullName() + " has failed (ConfigurationException): " + e.getMessage());
            this.stop();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FactoryClassloader
    extends ClassLoader {
        private Map m_definedClasses = new HashMap();

        private FactoryClassloader() {
        }

        public Class defineClass(String name, byte[] b, ProtectionDomain domain) {
            if (this.m_definedClasses.containsKey(name)) {
                return (Class)this.m_definedClasses.get(name);
            }
            Class<?> c = super.defineClass(name, b, 0, b.length, domain);
            this.m_definedClasses.put(name, c);
            return c;
        }

        public URL getResource(String arg) {
            return ComponentFactory.this.m_context.getBundle().getResource(arg);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return ComponentFactory.this.m_context.getBundle().loadClass(name);
        }
    }

    class HandlerIdentifier
    implements Comparable {
        private HandlerFactory m_factory;
        private String m_name;
        private int m_level = Integer.MAX_VALUE;
        private String m_namespace;
        private ServiceReference m_reference;

        public HandlerIdentifier(String n, String ns) {
            this.m_name = n;
            this.m_namespace = ns;
        }

        public boolean equals(Object o) {
            if (this.m_namespace == null) {
                return ((HandlerIdentifier)o).m_name.equalsIgnoreCase(this.m_name) && ((HandlerIdentifier)o).m_namespace == null;
            }
            return ((HandlerIdentifier)o).m_name.equalsIgnoreCase(this.m_name) && this.m_namespace.equalsIgnoreCase(((HandlerIdentifier)o).m_namespace);
        }

        public HandlerFactory getFactory() {
            if (this.m_reference == null) {
                return null;
            }
            if (this.m_factory == null) {
                this.m_factory = (HandlerFactory)ComponentFactory.this.m_tracker.getService(this.getReference());
            }
            return this.m_factory;
        }

        public String getFullName() {
            if (this.m_namespace == null) {
                return "org.apache.felix.ipojo:" + this.m_name;
            }
            return this.m_namespace + ":" + this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getNamespace() {
            return this.m_namespace;
        }

        public ServiceReference getReference() {
            return this.m_reference;
        }

        public int getLevel() {
            return this.m_level;
        }

        public void unRef() {
            if (this.m_reference != null) {
                ComponentFactory.this.m_tracker.ungetService(this.m_reference);
                this.m_factory = null;
                this.m_reference = null;
            }
        }

        public void setReference(ServiceReference ref) {
            this.m_reference = ref;
            Integer p = (Integer)this.m_reference.getProperty("handler.level");
            if (p != null) {
                this.m_level = p;
            }
        }

        public int compareTo(Object o) {
            if (o instanceof HandlerIdentifier) {
                HandlerIdentifier hi = (HandlerIdentifier)o;
                if (this.m_level == hi.m_level) {
                    return 0;
                }
                if (this.m_level < hi.m_level) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

