/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class HandlerFactory
extends ComponentFactory
implements Factory {
    private ServiceRegistration m_sr;
    private String m_type = "primitive";
    private String m_namespace = "org.apache.felix.ipojo";
    private int m_level = Integer.MAX_VALUE;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;

    public HandlerFactory(BundleContext bc, Element cm) {
        super(bc, cm);
        String ns;
        String l;
        this.m_factoryName = cm.getAttribute("name").toLowerCase();
        if (this.m_factoryName == null) {
            System.err.println("An Handler needs a name");
            return;
        }
        String t = cm.getAttribute("type");
        if (t != null) {
            this.m_type = t;
        }
        if ((l = cm.getAttribute("level")) != null) {
            this.m_level = new Integer(l);
        }
        if ((ns = cm.getAttribute("namespace")) != null) {
            this.m_namespace = ns.toLowerCase();
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getHandlerName() {
        return this.m_namespace + ":" + this.getName();
    }

    public String getType() {
        return this.m_type;
    }

    public int getStartLevel() {
        return this.m_level;
    }

    public synchronized void start() {
        if (this.m_sr != null) {
            return;
        }
        if (this.m_handlerIdentifiers.size() != 0) {
            try {
                String filter = "(&(handler.type=primitive)(factory.state=1))";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
                return;
            }
        }
        try {
            this.computeFactoryState();
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "Cannot initilize the factory " + e.getMessage());
            this.stop();
            return;
        }
        this.m_sr = this.m_context.registerService(new String[]{(class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = HandlerFactory.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName()}, (Object)this, (Dictionary)this.getProperties());
    }

    public synchronized void stop() {
        if (this.m_sr != null) {
            this.m_sr.unregister();
            this.m_sr = null;
        }
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            ((ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i)).unRef();
        }
        this.m_handlerIdentifiers.clear();
        this.m_listeners.clear();
        this.m_state = 0;
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.put("factory.state", "" + this.m_state);
        props.put("handler.name", this.m_factoryName);
        props.put("handler.namespace", this.m_namespace);
        props.put("handler.type", this.m_type);
        if (this.m_level != Integer.MAX_VALUE) {
            props.put("handler.level", new Integer(this.m_level));
        }
        return props;
    }

    protected void computeFactoryState() throws ConfigurationException {
        ComponentFactory.HandlerIdentifier hi;
        int i;
        boolean isValid = true;
        for (i = 0; isValid && i < this.m_handlerIdentifiers.size(); ++i) {
            hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            isValid = hi.getReference() != null;
        }
        if (isValid) {
            if (this.m_state == 0) {
                this.m_state = 1;
                if (this.m_sr == null) {
                    this.m_componentDesc = new ComponentDescription(this);
                    for (i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
                        hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
                        HandlerManager hm = this.getHandlerInstance(hi, null);
                        hm.getHandler();
                        Handler ch = hm.getHandler();
                        ch.setLogger(this.getLogger());
                        ch.initializeComponentFactory(this.m_componentDesc, this.m_componentMetadata);
                        ((Pojo)((Object)ch)).getComponentInstance().dispose();
                    }
                }
                if (this.m_sr != null) {
                    this.m_sr.setProperties((Dictionary)this.getProperties());
                }
                for (i = 0; i < this.m_listeners.size(); ++i) {
                    ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 1);
                }
                return;
            }
        } else if (this.m_state == 1) {
            this.m_state = 0;
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((FactoryStateListener)this.m_listeners.get(i)).stateChanged(this, 0);
            }
            Collection col = this.m_componentInstances.values();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                InstanceManager ci = (InstanceManager)it.next();
                if (ci.getState() != -1) {
                    ci.kill();
                }
                m_instancesName.remove(ci.m_name);
            }
            this.m_componentInstances.clear();
            if (this.m_sr != null) {
                this.m_sr.setProperties((Dictionary)this.getProperties());
            }
            return;
        }
    }

    public synchronized ComponentInstance createComponentInstance(Dictionary configuration, ServiceContext serviceContext) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        if (this.m_state == 0) {
            throw new MissingHandlerException(this.getMissingHandlers());
        }
        if (configuration == null) {
            configuration = new Properties();
        }
        String in = null;
        if (configuration.get("name") != null) {
            in = (String)configuration.get("name");
        } else {
            in = this.generateName();
            configuration.put("name", in);
        }
        if (m_instancesName.contains(in)) {
            throw new UnacceptableConfiguration("Name already used : " + in);
        }
        m_instancesName.add(in);
        IPojoContext context = null;
        context = serviceContext == null ? new IPojoContext(this.m_context) : new IPojoContext(this.m_context, serviceContext);
        ArrayList<HandlerManager> handlers = new ArrayList<HandlerManager>();
        for (int i = 0; i < this.m_handlerIdentifiers.size(); ++i) {
            ComponentFactory.HandlerIdentifier hi = (ComponentFactory.HandlerIdentifier)this.m_handlerIdentifiers.get(i);
            handlers.add(this.getHandlerInstance(hi, serviceContext));
        }
        HandlerManager instance = new HandlerManager(this, context, handlers.toArray(new HandlerManager[handlers.size()]));
        instance.configure(this.m_componentMetadata, configuration);
        this.m_componentInstances.put(in, instance);
        return instance;
    }

    private HandlerManager getHandlerInstance(ComponentFactory.HandlerIdentifier hi, ServiceContext sc) {
        try {
            return (HandlerManager)hi.getFactory().createComponentInstance(null, sc);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The creation of the handler " + hi.getFullName() + " has failed: " + e.getMessage());
            this.stop();
            return null;
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The creation of the handler " + hi.getFullName() + " has failed (UnacceptableConfiguration): " + e.getMessage());
            this.stop();
            return null;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The configuration of the handler " + hi.getFullName() + " has failed (ConfigurationException): " + e.getMessage());
            this.stop();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

