/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.Dictionary;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.CompositeHandler;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class HandlerManager
extends InstanceManager {
    private Handler m_handler;

    public HandlerManager(ComponentFactory factory, BundleContext bc, HandlerManager[] handlers) {
        super(factory, bc, handlers);
    }

    public Handler getHandler() {
        if (this.m_handler == null) {
            this.createHandlerObject();
        }
        return this.m_handler;
    }

    public void init(ComponentInstance ci, Element cm, Dictionary configuration) throws ConfigurationException {
        this.createHandlerObject();
        this.m_handler.attach(ci);
        this.m_handler.configure(cm, configuration);
    }

    private void createHandlerObject() {
        if (this.m_handler != null) {
            return;
        }
        Handler h = (Handler)this.createPojoObject();
        this.m_handler = h instanceof PrimitiveHandler ? (PrimitiveHandler)h : (CompositeHandler)h;
    }

    public synchronized void start() {
        int i;
        if (this.m_state != 0) {
            return;
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].addInstanceStateListener(this);
            this.m_handlers[i].start();
        }
        this.m_handler.start();
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getHandler().isValid()) continue;
            this.setState(1);
            return;
        }
        this.setState(2);
    }

    public synchronized void stop() {
        int i;
        if (this.m_state == 0) {
            return;
        }
        this.setState(1);
        if (this.m_handler != null) {
            this.m_handler.stop();
        }
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener(this);
            this.m_handlers[i].stop();
        }
        this.m_state = 0;
        if (this.m_instanceListeners != null) {
            for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, 0);
            }
        }
    }

    public synchronized void dispose() {
        super.dispose();
        this.m_handler = null;
    }

    protected void kill() {
        super.dispose();
        this.m_handler = null;
    }
}

