/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.configuration;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.handlers.configuration.ConfigurationHandler;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.Callback;

public class ConfigurableProperty {
    private String m_name;
    private String m_field;
    private Callback m_method;
    private Object m_value;
    private Class m_type;
    private ConfigurationHandler m_handler;
    static /* synthetic */ Class class$java$lang$String;

    public ConfigurableProperty(String name, String field, String method, String value, String type, ConfigurationHandler ch) throws ConfigurationException {
        this.m_handler = ch;
        this.m_field = field;
        this.m_name = name != null ? name : (this.m_field != null ? field : method);
        this.m_field = field;
        if (value != null) {
            this.setValue(value, type);
        } else {
            this.setType(type);
        }
        if (method != null) {
            this.m_method = new Callback(method, new String[]{this.m_type.getName()}, false, this.m_handler.getInstanceManager());
        }
    }

    private void setType(String type) throws ConfigurationException {
        if ("string".equals(type) || "String".equals(type)) {
            this.m_type = class$java$lang$String == null ? (class$java$lang$String = ConfigurableProperty.class$("java.lang.String")) : class$java$lang$String;
            return;
        }
        if (type.equals("boolean")) {
            this.m_type = Boolean.TYPE;
            return;
        }
        if ("byte".equals(type)) {
            this.m_type = Byte.TYPE;
            return;
        }
        if ("short".equals(type)) {
            this.m_type = Short.TYPE;
            return;
        }
        if ("int".equals(type)) {
            this.m_type = Integer.TYPE;
            return;
        }
        if ("long".equals(type)) {
            this.m_type = Long.TYPE;
            return;
        }
        if ("float".equals(type)) {
            this.m_type = Float.TYPE;
            return;
        }
        if ("double".equals(type)) {
            this.m_type = Double.TYPE;
            return;
        }
        if ("char".equals(type)) {
            this.m_type = Character.TYPE;
            return;
        }
        if (type.endsWith("[]")) {
            String internalType = type.substring(0, type.length() - 2);
            if ("string".equals(internalType) || "String".equals(internalType)) {
                this.m_type = new String[0].getClass();
                return;
            }
            if ("boolean".equals(internalType)) {
                this.m_type = new boolean[0].getClass();
                return;
            }
            if ("byte".equals(internalType)) {
                this.m_type = new byte[0].getClass();
                return;
            }
            if ("short".equals(internalType)) {
                this.m_type = new short[0].getClass();
                return;
            }
            if ("int".equals(internalType)) {
                this.m_type = new int[0].getClass();
                return;
            }
            if ("long".equals(internalType)) {
                this.m_type = new long[0].getClass();
                return;
            }
            if ("float".equals(internalType)) {
                this.m_type = new float[0].getClass();
                return;
            }
            if ("double".equals(internalType)) {
                this.m_type = new double[0].getClass();
                return;
            }
            if ("char".equals(internalType)) {
                this.m_type = new char[0].getClass();
                return;
            }
            try {
                Class c = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(internalType);
                Object[] ob = (Object[])Array.newInstance(c, 0);
                this.m_type = ob.getClass();
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class not found exception in setValue on " + internalType);
            }
            catch (SecurityException e) {
                throw new ConfigurationException("Secutiry Exception in setValue on " + internalType);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Argument problem to call the constructor of the type " + internalType);
            }
        }
        try {
            this.m_type = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class not found exception in setValue on " + type + " : " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Security excption in setValue on " + type + " : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument problem to call the constructor of the type " + type);
        }
    }

    private void setValue(String strValue, String type) throws ConfigurationException {
        Object value = null;
        if ("string".equals(type) || "String".equals(type)) {
            value = new String(strValue);
            Class clazz = this.m_type = class$java$lang$String == null ? (class$java$lang$String = ConfigurableProperty.class$("java.lang.String")) : class$java$lang$String;
        }
        if (type.equals("boolean")) {
            value = new Boolean(strValue);
            this.m_type = Boolean.TYPE;
        }
        if ("byte".equals(type)) {
            value = new Byte(strValue);
            this.m_type = Byte.TYPE;
        }
        if ("short".equals(type)) {
            value = new Short(strValue);
            this.m_type = Short.TYPE;
        }
        if ("int".equals(type)) {
            value = new Integer(strValue);
            this.m_type = Integer.TYPE;
        }
        if ("long".equals(type)) {
            value = new Long(strValue);
            this.m_type = Long.TYPE;
        }
        if ("float".equals(type)) {
            value = new Float(strValue);
            this.m_type = Float.TYPE;
        }
        if ("double".equals(type)) {
            value = new Double(strValue);
            this.m_type = Double.TYPE;
        }
        if ("char".equals(type)) {
            value = new Character(strValue.charAt(0));
            this.m_type = Character.TYPE;
        }
        if (type.endsWith("[]")) {
            String internalType = type.substring(0, type.length() - 2);
            this.setArrayValue(internalType, ParseUtils.parseArrays(strValue));
            return;
        }
        if (value == null) {
            try {
                this.m_type = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(type);
                Constructor cst = this.m_type.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurableProperty.class$("java.lang.String")) : class$java$lang$String);
                value = cst.newInstance(strValue);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class not found exception in setValue on " + type + " : " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new ConfigurationException("Security excption in setValue on " + type + " : " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Constructor not found exeption in setValue on " + type + " : " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Argument problem to call the constructor of the type " + type);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Instantiation problem  " + type);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal Access " + type);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Invocation problem " + type + " : " + e.getTargetException().getMessage());
            }
        }
        this.m_value = value;
    }

    private void setArrayValue(String internalType, String[] values) throws ConfigurationException {
        if ("string".equals(internalType) || "String".equals(internalType)) {
            String[] str = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                str[i] = new String(values[i]);
            }
            this.m_value = str;
            this.m_type = new String[0].getClass();
            return;
        }
        if ("boolean".equals(internalType)) {
            boolean[] bool = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                bool[i] = new Boolean(values[i]);
            }
            this.m_value = bool;
            this.m_type = new boolean[0].getClass();
            return;
        }
        if ("byte".equals(internalType)) {
            byte[] byt = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                byt[i] = new Byte(values[i]);
            }
            this.m_value = byt;
            this.m_type = new byte[0].getClass();
            return;
        }
        if ("short".equals(internalType)) {
            short[] shor = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                shor[i] = new Short(values[i]);
            }
            this.m_value = shor;
            this.m_type = new short[0].getClass();
            return;
        }
        if ("int".equals(internalType)) {
            int[] in = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                in[i] = new Integer(values[i]);
            }
            this.m_value = in;
            this.m_type = new int[0].getClass();
            return;
        }
        if ("long".equals(internalType)) {
            long[] ll = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ll[i] = new Long(values[i]);
            }
            this.m_value = ll;
            this.m_type = new long[0].getClass();
            return;
        }
        if ("float".equals(internalType)) {
            float[] fl = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                fl[i] = new Float(values[i]).floatValue();
            }
            this.m_value = fl;
            this.m_type = new float[0].getClass();
            return;
        }
        if ("double".equals(internalType)) {
            double[] dl = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                dl[i] = new Double(values[i]);
            }
            this.m_value = dl;
            this.m_type = new double[0].getClass();
            return;
        }
        if ("char".equals(internalType)) {
            char[] dl = new char[values.length];
            for (int i = 0; i < values.length; ++i) {
                dl[i] = values[i].toCharArray()[0];
            }
            this.m_value = dl;
            this.m_type = new char[0].getClass();
            return;
        }
        try {
            Class c = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(internalType);
            Constructor cst = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurableProperty.class$("java.lang.String")) : class$java$lang$String);
            Object[] ob = (Object[])Array.newInstance(c, values.length);
            for (int i = 0; i < values.length; ++i) {
                ob[i] = cst.newInstance(values[i].trim());
            }
            this.m_value = ob;
            this.m_type = ob.getClass();
            return;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class not found exception in setValue on " + internalType);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Secutiry Exception in setValue on " + internalType);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Constructor not found exception in setValue on " + internalType);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument problem to call the constructor of the type " + internalType);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Instantiation problem  " + internalType);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Illegal Access Exception in  " + internalType);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Invocation problem " + internalType + " : " + e.getTargetException().getMessage());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getField() {
        return this.m_field;
    }

    public String getMethod() {
        if (this.m_method == null) {
            return null;
        }
        return this.m_method.getMethod();
    }

    public boolean hasMethod() {
        return this.m_method != null;
    }

    public boolean hasField() {
        return this.m_field != null;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        this.m_value = value;
    }

    public void invoke() {
        try {
            this.m_method.call(new Object[]{this.m_value});
        }
        catch (NoSuchMethodException e) {
            this.m_handler.log(1, "The method " + this.m_method + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_handler.log(1, "The method " + this.m_method + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_handler.log(1, "The method " + this.m_method + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
            this.m_handler.getInstanceManager().setState(1);
        }
    }

    public void invoke(Object instance) {
        try {
            this.m_method.call(instance, new Object[]{this.m_value});
        }
        catch (NoSuchMethodException e) {
            this.m_handler.getInstanceManager().getFactory().getLogger().log(1, "The method " + this.m_method + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_handler.getInstanceManager().getFactory().getLogger().log(1, "The method " + this.m_method + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
            this.m_handler.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_handler.getInstanceManager().getFactory().getLogger().log(1, "The method " + this.m_method + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
            this.m_handler.getInstanceManager().setState(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

