/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class DependencyHandlerDescription
extends HandlerDescription {
    private DependencyDescription[] m_dependencies = new DependencyDescription[0];

    public DependencyHandlerDescription(Handler h) {
        super(h);
    }

    public DependencyDescription[] getDependencies() {
        return this.m_dependencies;
    }

    public void addDependency(DependencyDescription dep) {
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            if (this.m_dependencies[i] != dep) continue;
            return;
        }
        DependencyDescription[] newDep = new DependencyDescription[this.m_dependencies.length + 1];
        System.arraycopy(this.m_dependencies, 0, newDep, 0, this.m_dependencies.length);
        newDep[this.m_dependencies.length] = dep;
        this.m_dependencies = newDep;
    }

    public Element getHandlerInfo() {
        Element deps = super.getHandlerInfo();
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            String state = "resolved";
            if (this.m_dependencies[i].getState() == 2) {
                state = "unresolved";
            }
            if (this.m_dependencies[i].getState() == 3) {
                state = "broken";
            }
            Element dep = new Element("Requires", "");
            dep.addAttribute(new Attribute("Specification", this.m_dependencies[i].getInterface()));
            if (!"".equals(this.m_dependencies[i].getFilter())) {
                dep.addAttribute(new Attribute("Filter", this.m_dependencies[i].getFilter()));
            }
            if (this.m_dependencies[i].isOptional()) {
                dep.addAttribute(new Attribute("Optional", "true"));
            } else {
                dep.addAttribute(new Attribute("Optional", "false"));
            }
            if (this.m_dependencies[i].isMultiple()) {
                dep.addAttribute(new Attribute("Aggregate", "true"));
            } else {
                dep.addAttribute(new Attribute("Aggregate", "false"));
            }
            dep.addAttribute(new Attribute("State", state));
            List set = this.m_dependencies[i].getUsedServices();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Element use = new Element("Uses", "");
                ServiceReference ref = (ServiceReference)it.next();
                use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
                String in = (String)ref.getProperty("instance.name");
                if (in != null) {
                    use.addAttribute(new Attribute("instance.name", in));
                }
                dep.addElement(use);
            }
            deps.addElement(dep);
        }
        return deps;
    }
}

