/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedService;
import org.apache.felix.ipojo.parser.ParseUtils;

public class Property {
    private ProvidedService m_providedService;
    private Object m_value;
    private String m_field;
    private String m_name;
    private String m_type;
    private String m_initialValue;
    static /* synthetic */ Class class$java$lang$String;

    public Property(ProvidedService ps, String name, String field, String type, String value) {
        this.m_providedService = ps;
        this.m_name = name;
        this.m_field = field;
        this.m_type = type;
        this.m_initialValue = value;
        if (this.m_field != null && this.m_name == null) {
            this.m_name = this.m_field;
        }
        if (this.m_initialValue != null) {
            this.setValue(this.m_initialValue);
        }
    }

    public Property(ProvidedService ps, String name, Object value) {
        this.m_providedService = ps;
        this.m_name = name;
        this.m_type = value.getClass().getName();
        this.m_value = value;
    }

    protected Object get() {
        return this.m_value;
    }

    protected void set(String s) {
        this.setValue(s);
    }

    protected void set(Object o) {
        this.m_value = o;
    }

    void setProvidedService(ProvidedService ps) {
        this.m_providedService = ps;
    }

    private void setValue(String value) {
        if (this.m_type.endsWith("[]")) {
            String internalType = this.m_type.substring(0, this.m_type.length() - 2);
            this.setArrayValue(internalType, ParseUtils.parseArrays(value));
            return;
        }
        if ("string".equals(this.m_type) || "String".equals(this.m_type)) {
            this.m_value = new String(value);
            return;
        }
        if ("boolean".equals(this.m_type)) {
            this.m_value = new Boolean(value);
            return;
        }
        if ("byte".equals(this.m_type)) {
            this.m_value = new Byte(value);
            return;
        }
        if ("short".equals(this.m_type)) {
            this.m_value = new Short(value);
            return;
        }
        if ("int".equals(this.m_type)) {
            this.m_value = new Integer(value);
            return;
        }
        if ("long".equals(this.m_type)) {
            this.m_value = new Long(value);
            return;
        }
        if ("float".equals(this.m_type)) {
            this.m_value = new Float(value);
            return;
        }
        if ("double".equals(this.m_type)) {
            this.m_value = new Double(value);
            return;
        }
        try {
            Class c = this.m_providedService.getInstanceManager().getContext().getBundle().loadClass(this.m_type);
            Constructor cst = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Property.class$("java.lang.String")) : class$java$lang$String);
            this.m_value = cst.newInstance(value);
        }
        catch (ClassNotFoundException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Class not found exception in setValue on " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (SecurityException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Security Exception in setValue on " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (NoSuchMethodException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Constructor not found exeption in setValue on " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (IllegalArgumentException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Argument problem to call the constructor of the type " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (InstantiationException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Instantiation problem  " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Illegal Access Exception in setValue on " + this.m_type);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Invocation problem " + this.m_type + " : " + e.getTargetException().getMessage());
            this.m_providedService.getInstanceManager().setState(1);
        }
    }

    private void setArrayValue(String internalType, String[] values) {
        if ("string".equals(internalType) || "String".equals(internalType)) {
            this.m_value = values;
            return;
        }
        if ("boolean".equals(internalType)) {
            boolean[] bool = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                bool[i] = new Boolean(values[i]);
            }
            this.m_value = bool;
            return;
        }
        if ("byte".equals(internalType)) {
            byte[] byt = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                byt[i] = new Byte(values[i]);
            }
            this.m_value = byt;
            return;
        }
        if ("short".equals(internalType)) {
            short[] shor = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                shor[i] = new Short(values[i]);
            }
            this.m_value = shor;
            return;
        }
        if ("int".equals(internalType)) {
            int[] in = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                in[i] = new Integer(values[i]);
            }
            this.m_value = in;
            return;
        }
        if ("long".equals(internalType)) {
            long[] ll = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ll[i] = new Long(values[i]);
            }
            this.m_value = ll;
            return;
        }
        if ("float".equals(internalType)) {
            float[] fl = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                fl[i] = new Float(values[i]).floatValue();
            }
            this.m_value = fl;
            return;
        }
        if ("double".equals(internalType)) {
            double[] dl = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                dl[i] = new Double(values[i]);
            }
            this.m_value = dl;
            return;
        }
        try {
            Class c = this.m_providedService.getInstanceManager().getContext().getBundle().loadClass(internalType);
            Constructor cst = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Property.class$("java.lang.String")) : class$java$lang$String);
            Object[] ob = (Object[])Array.newInstance(c, values.length);
            for (int i = 0; i < values.length; ++i) {
                ob[i] = cst.newInstance(values[i]);
            }
            this.m_value = ob;
            return;
        }
        catch (ClassNotFoundException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Class not found exception in setArrayValue on " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (SecurityException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Security Exception in setArrayValue on " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (NoSuchMethodException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Constructor not found exception in setArrayValue on " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (IllegalArgumentException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Argument problem to call the constructor of the type " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (InstantiationException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Instantiation problem  " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Illegal Access Exception in setArrayValue on " + internalType);
            this.m_providedService.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_providedService.getInstanceManager().getFactory().getLogger().log(1, "Invocation problem " + internalType + " : " + e.getTargetException().getMessage());
            this.m_providedService.getInstanceManager().setState(1);
        }
    }

    public Object getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    protected String getField() {
        return this.m_field;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public String getInitialValue() {
        return this.m_initialValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

