/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;

public class MethodMetadata {
    private String m_name;
    private String[] m_arguments = new String[0];
    private String m_return = "void";

    MethodMetadata(Element metadata) {
        this.m_name = metadata.getAttribute("name");
        String arg = metadata.getAttribute("arguments");
        String rt = metadata.getAttribute("return");
        if (arg != null) {
            this.m_arguments = ParseUtils.parseArrays(arg);
        }
        if (rt != null) {
            this.m_return = rt;
        }
    }

    public String getMethodName() {
        return this.m_name;
    }

    public String[] getMethodArguments() {
        return this.m_arguments;
    }

    public String getMethodReturn() {
        return this.m_return;
    }

    public String getMethodIdentifier() {
        String id = this.m_name;
        for (int i = 0; i < this.m_arguments.length; ++i) {
            String cn = this.m_arguments[i];
            if (cn.endsWith("[]")) {
                cn = cn.replace('[', '$');
                cn = cn.substring(0, cn.length() - 1);
            }
            cn = cn.replace('.', '_');
            id = id + cn;
        }
        return id;
    }
}

