/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.configuration;

import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.util.Property;
import org.ow2.easybeans.osgi.configuration.ComponentConfiguration;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.xmlconfig.XMLConfiguration;
import org.ow2.easybeans.xmlconfig.XMLConfigurationException;
import org.ow2.easybeans.xmlconfig.mapping.ClassMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigurationExtractor
extends XMLConfiguration {
    public static final String XML_CONFIG_PROPERTY = "xmlconfig";
    public static final String CLASS_NAME_CONFIG_PROPERTY = "classname";
    public static final String INDEX_CONFIG_PROPERTY = "index";
    private static Class<?> defaultParentComponentClass = EZBComponent.class;
    private Collection<ComponentConfiguration> componentConfigurations = new ArrayList<ComponentConfiguration>();
    private Map<String, Integer> componentTypesToIndexesMap = new HashMap<String, Integer>();

    public static void setDefaultParentComponentClass(Class<?> anotherDefaultCompoentClass) {
        defaultParentComponentClass = anotherDefaultCompoentClass;
    }

    public XMLConfigurationExtractor(URL xmlConfigurationURL) throws XMLConfigurationException {
        super(xmlConfigurationURL);
        Embedded embedded = new Embedded();
        this.configure(embedded);
    }

    protected void setAttributes(Element node, Object object, ClassMapping classMapping) throws XMLConfigurationException {
        if (!defaultParentComponentClass.isInstance(object)) {
            return;
        }
        ComponentConfiguration componentConfiguration = new ComponentConfiguration(object);
        String componentConfigurationXml = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Node parentNode = node.getParentNode();
            Node grandParentNode = parentNode.getParentNode();
            Element componentNode = node;
            Document document = documentBuilder.newDocument();
            Node newEasybeansNode = document.importNode(grandParentNode, false);
            document.appendChild(newEasybeansNode);
            Node newComponentsNode = document.importNode(parentNode, false);
            newEasybeansNode.appendChild(newComponentsNode);
            Node newComponentNode = document.importNode(componentNode, true);
            newComponentsNode.appendChild(newComponentNode);
            DOMSource domSource = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(domSource, result);
            componentConfigurationXml = stringWriter.toString().trim();
        }
        catch (Exception e) {
            throw new XMLConfigurationException("Could not parse XMl configuration file", (Throwable)e);
        }
        Property classname = new Property();
        classname.setName(CLASS_NAME_CONFIG_PROPERTY);
        classname.setValue(object.getClass().getName());
        componentConfiguration.addProperty(classname);
        Property xmlConfiguration = new Property();
        xmlConfiguration.setName(XML_CONFIG_PROPERTY);
        xmlConfiguration.setValue(componentConfigurationXml);
        componentConfiguration.addProperty(xmlConfiguration);
        Integer index = this.componentTypesToIndexesMap.get(componentConfiguration.getComponentClass().getName());
        index = index == null ? new Integer(0) : (index = Integer.valueOf(index + 1));
        Property indexProperty = new Property();
        indexProperty.setName(INDEX_CONFIG_PROPERTY);
        indexProperty.setValue(index + "");
        this.componentTypesToIndexesMap.put(componentConfiguration.getComponentClass().getName(), index);
        componentConfiguration.setIndex(index);
        this.componentConfigurations.add(componentConfiguration);
    }

    public Collection<ComponentConfiguration> getComponentConfigurations() {
        return this.componentConfigurations;
    }

    public Collection<ComponentConfiguration> getComponentConfigurationsForSymbolicName(String symbolicName) {
        ArrayList<ComponentConfiguration> thisComponentConfigurations = new ArrayList<ComponentConfiguration>();
        for (ComponentConfiguration componentConfiguration : this.componentConfigurations) {
            if (!componentConfiguration.getComponentSymbolicName().equals(symbolicName)) continue;
            thisComponentConfigurations.add(componentConfiguration);
        }
        return thisComponentConfigurations;
    }
}

