/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.clusterd.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfiguration;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfigurationException;
import org.ow2.jonas.lib.bootstrap.JClassLoader;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.util.Log;

public class ClusterDaemonConfigurationManagerWrapper {
    private static final String CLUSTER_DAEMON_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.clusterd.lib.ClusterDaemonConfigurationManager";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.cluster.daemon");

    private ClusterDaemonConfigurationManagerWrapper() {
    }

    public static ClusterDaemonConfiguration getClusterDaemonConfiguration(String fileName, ClassLoader cl) throws ClusterDaemonConfigurationException {
        LoaderManager lm = LoaderManager.getInstance();
        ClusterDaemonConfiguration conf = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(CLUSTER_DAEMON_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getClusterDaemonConfiguration", String.class, ClassLoader.class);
            conf = (ClusterDaemonConfiguration)m.invoke(null, fileName, cl);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (ClusterDaemonConfigurationException.class.isInstance(t)) {
                throw (ClusterDaemonConfigurationException)ite.getTargetException();
            }
            throw new ClusterDaemonConfigurationException("ClusterDaemonManager.getClusterDaemonConfiguration fails", t);
        }
        catch (Exception e) {
            throw new ClusterDaemonConfigurationException("Problems when using reflection on ClusterDaemonManager", e);
        }
        return conf;
    }

    public static String getClusterDaemonFileName(String fileName) throws ClusterDaemonConfigurationException {
        LoaderManager lm = LoaderManager.getInstance();
        String clusterdFileName = null;
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(CLUSTER_DAEMON_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getClusterDaemonFileName", String.class);
            clusterdFileName = (String)m.invoke(null, fileName);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (ClusterDaemonConfigurationException.class.isInstance(t)) {
                throw (ClusterDaemonConfigurationException)ite.getTargetException();
            }
            throw new ClusterDaemonConfigurationException("ClusterDaemonManager.getClusterDaemonFileName fails", t);
        }
        catch (Exception e) {
            throw new ClusterDaemonConfigurationException("Problems when using reflection on ClusterDaemonManager", e);
        }
        return clusterdFileName;
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> manager = tools.loadClass(CLUSTER_DAEMON_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", Boolean.TYPE);
            m.invoke(null, new Boolean(b));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }
}

