/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.jonas.deployment.web.MethodDesc;

public class MethodsDesc {
    private Map httpMethods = new HashMap();
    public static final String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private static final int ALL_ACTIONS_LENGTH = 38;

    public MethodsDesc() {
        for (int m = 0; m < METHODS.length; ++m) {
            this.httpMethods.put(METHODS[m], new MethodDesc(METHODS[m]));
        }
    }

    public void addMethods(String[] methods, String transportGuarantee, boolean isExcluded) {
        MethodDesc method = null;
        for (int m = 0; m < methods.length; ++m) {
            method = this.getMethod(methods[m]);
            method.addTransportGuarantee(transportGuarantee);
            if (isExcluded) {
                method.setExcluded();
                continue;
            }
            method.setUnchecked();
        }
    }

    public void addMethodsOnRole(String[] methods, String role, String transportGuarantee) {
        for (int m = 0; m < methods.length; ++m) {
            this.getMethod(methods[m]).addRole(role, transportGuarantee);
        }
    }

    private MethodDesc getMethod(String methodName) {
        MethodDesc m = (MethodDesc)this.httpMethods.get(methodName.toUpperCase());
        if (m == null) {
            throw new IllegalStateException("No such method named '" + methodName + "'.");
        }
        return m;
    }

    public String getExcludedActions() {
        StringBuffer actions = new StringBuffer();
        MethodDesc method2 = null;
        for (MethodDesc method2 : this.httpMethods.values()) {
            if (!method2.isExcluded() || method2.hasRole()) continue;
            if (actions.length() > 0) {
                actions.append(",");
            }
            actions.append(method2.getName());
        }
        return actions.toString();
    }

    public String getUncheckedActions() {
        StringBuffer actions = new StringBuffer();
        MethodDesc method2 = null;
        for (MethodDesc method2 : this.httpMethods.values()) {
            if (!method2.isUnchecked() || method2.hasRole()) continue;
            if (actions.length() > 0) {
                actions.append(",");
            }
            actions.append(method2.getName());
        }
        if (actions.length() == 38) {
            return null;
        }
        return actions.toString();
    }

    public Map getRoleMapActions() {
        MethodDesc method2 = null;
        HashMap<String, String> rolesMap = new HashMap<String, String>();
        for (MethodDesc method2 : this.httpMethods.values()) {
            if (!method2.hasRole()) continue;
            Iterator itRoles = method2.getRolesIterator();
            while (itRoles.hasNext()) {
                String roleName = (String)itRoles.next();
                String actions = (String)rolesMap.get(roleName);
                if (actions == null) {
                    actions = method2.getName();
                } else {
                    actions = actions + ",";
                    actions = actions + method2.getName();
                }
                rolesMap.put(roleName, actions);
            }
        }
        return rolesMap;
    }

    public List getUncheckedWebUserDataActionsRoleList() {
        MethodDesc method2 = null;
        StringBuffer nones = null;
        StringBuffer confidentials = null;
        StringBuffer integrals = null;
        for (MethodDesc method2 : this.httpMethods.values()) {
            String methodName = method2.getName();
            if (!method2.isUnchecked() || !method2.hasRole()) continue;
            if (method2.getTransportGuarantee().hasNone()) {
                if (nones == null) {
                    nones = new StringBuffer(methodName);
                } else {
                    nones.append(",");
                    nones.append(methodName);
                }
            }
            if (method2.getTransportGuarantee().isIntegral()) {
                if (integrals == null) {
                    integrals = new StringBuffer(methodName);
                } else {
                    integrals.append(",");
                    integrals.append(methodName);
                }
            }
            if (!method2.getTransportGuarantee().isConfidential()) continue;
            if (confidentials == null) {
                confidentials = new StringBuffer(methodName);
                continue;
            }
            confidentials.append(",");
            confidentials.append(methodName);
        }
        ArrayList<String> unchecked = new ArrayList<String>();
        if (nones != null) {
            unchecked.add(nones.toString());
        }
        if (integrals != null) {
            integrals.append(":");
            integrals.append("INTEGRAL");
            unchecked.add(integrals.toString());
        }
        if (confidentials != null) {
            confidentials.append(":");
            confidentials.append("CONFIDENTIAL");
            unchecked.add(confidentials.toString());
        }
        return unchecked;
    }
}

