/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.DiscoveryEvent;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.internal.client.DiscoveryClient;
import org.ow2.jonas.discovery.internal.utils.DiscoveryHelper;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public class DiscoveryClientListener
implements Runnable {
    public static final String DISCOVERY_TYPE = "jonas.management.discovery";
    private static int RECEIVE_BUFFER_SIZE = 1024;
    private MulticastSocket multicastSocket;
    private int port;
    private InetAddress groupAddress;
    private int ttl;
    private DatagramSocket unicastSocket;
    private String sourceIp;
    private int sourcePort;
    private boolean notStopped = true;
    private long timeout = 1000L;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");

    public DiscoveryClientListener(DiscoveryClient discoveryClient) {
        this.port = discoveryClient.getListeningPort();
        try {
            this.groupAddress = InetAddress.getByName(discoveryClient.getListeningIp());
            this.ttl = discoveryClient.getTimeToLive();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)"Invalid host", (Throwable)e);
        }
        this.timeout = discoveryClient.getTimeout();
        this.sourcePort = discoveryClient.getSourcePort();
        this.sourceIp = discoveryClient.getSourceIp();
        try {
            this.unicastSocket = new DatagramSocket(this.sourcePort);
        }
        catch (SocketException e2) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryClient : Unable to create a Datagram socket", (Throwable)e2);
            throw new ServiceException("Could not create socket to listen for discovery messages at port: " + this.sourcePort + ". The port might be in use.");
        }
    }

    public void sendDiscoveryMessage(DiscMessage msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DiscoveryClient : The message to send is " + msg));
        }
        byte[] messageBytes = null;
        try {
            messageBytes = DiscoveryHelper.objectToBytes((Object)msg);
            if (messageBytes != null) {
                this.multicastSocket.send(new DatagramPacket(messageBytes, messageBytes.length, this.groupAddress, this.port));
            }
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryClient :  Error to send discovery message", (Throwable)e);
        }
    }

    public void run() {
        try {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setTimeToLive(this.ttl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DiscMessage msg = new DiscMessage(this.sourceIp, this.sourcePort);
        this.sendDiscoveryMessage(msg);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" DiscoveryClient: Sent Message is" + msg));
        }
        long lastTime = this.timeout + System.currentTimeMillis();
        DiscEvent event = null;
        try {
            while (this.notStopped && System.currentTimeMillis() <= lastTime) {
                DatagramPacket datagram = null;
                Object objReceived = null;
                try {
                    datagram = this.getDatagram(RECEIVE_BUFFER_SIZE);
                    this.multicastSocket.receive(datagram);
                    objReceived = DiscoveryHelper.bytesToObject((byte[])datagram.getData());
                }
                catch (RuntimeException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                catch (IOException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                if (objReceived != null && objReceived instanceof DiscEvent && (event = (DiscEvent)objReceived).getDomainName().equals(JonasObjectName.getDomain())) {
                    event.setSourceAddress(datagram.getAddress().getHostAddress());
                    DomainMonitor dm = DomainMonitor.getInstance();
                    if (dm == null) {
                        logger.log(BasicLevel.WARN, (Object)"No DomainMonitor");
                    } else {
                        dm.discoveryNotification((DiscoveryEvent)event);
                    }
                }
                datagram = null;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryClient ClassNotFoundException ", (Throwable)e);
        }
    }

    protected DatagramPacket getDatagram(int length) {
        return new DatagramPacket(new byte[length], length);
    }

    public void stop() {
        this.notStopped = false;
        Thread.interrupted();
    }
}

