/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.generator;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.ow2.jonas.lib.bootstrap.JClassLoader;
import org.ow2.jonas.lib.util.Env;

public class Config {
    public static final int PACKED = 0;
    public static final int UNPACKED = 1;
    private String nameJava = "java";
    private String nameJavac = "javac";
    private String nameRmic = "rmic";
    private Vector javacOpts = new Vector();
    private String javaHomeBin = null;
    private boolean noConfig = false;
    private boolean verbose = false;
    private boolean debug = false;
    private String classpath = ".";
    private File out = new File(".");
    private boolean keepGenerated = false;
    private boolean parseWithValidation = true;
    private boolean error = false;
    private String inputname;
    private boolean help = false;
    private int saveMode = 0;
    private boolean dtdsAllowed = false;

    public Config() {
        this.setJavaHomeBin(System.getProperty("java.home", ""));
        if (!"".equals(this.getJavaHomeBin())) {
            if (Env.isOsMacOsX()) {
                this.setJavaHomeBin(this.getJavaHomeBin() + File.separator + "bin" + File.separator);
            } else {
                this.setJavaHomeBin(this.getJavaHomeBin() + File.separator + ".." + File.separator + "bin" + File.separator);
            }
        }
        URLClassLoader ucl = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        boolean inClientContainer = false;
        try {
            ucl.loadClass("org.ow2.jonas.lib.bootstrap.Bootstrap");
        }
        catch (ClassNotFoundException cnfe) {
            inClientContainer = true;
        }
        if (inClientContainer) {
            this.setClasspath(this.extractURLs(ucl));
        } else {
            this.setClasspath(((JClassLoader)ucl).getClassPath());
        }
    }

    private String extractURLs(URLClassLoader ucl) {
        URL[] urls = ucl.getURLs();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < urls.length; ++i) {
            String file = urls[i].getFile();
            if ("".equals(file)) continue;
            if (first) {
                sb.append(file);
                first = false;
                continue;
            }
            sb.append(File.pathSeparator + file);
        }
        return sb.toString();
    }

    public void setNameJavac(String nameJavac) {
        this.nameJavac = nameJavac;
    }

    public String getNameJavac() {
        return this.nameJavac;
    }

    public void setJavacOpts(Vector javacOpts) {
        this.javacOpts = javacOpts;
    }

    public Vector getJavacOpts() {
        return this.javacOpts;
    }

    public void setJavaHomeBin(String javaHomeBin) {
        this.javaHomeBin = javaHomeBin;
    }

    public String getJavaHomeBin() {
        return this.javaHomeBin;
    }

    public void setNoConfig(boolean noConfig) {
        this.noConfig = noConfig;
    }

    public boolean isNoConfig() {
        return this.noConfig;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setOut(File out) {
        this.out = out;
    }

    public File getOut() {
        return this.out;
    }

    public void setKeepGenerated(boolean keepGenerated) {
        this.keepGenerated = keepGenerated;
    }

    public boolean isKeepGenerated() {
        return this.keepGenerated;
    }

    public void setParseWithValidation(boolean parseWithValidation) {
        this.parseWithValidation = parseWithValidation;
    }

    public boolean isParseWithValidation() {
        return this.parseWithValidation;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }

    public void setInputname(String inputname) {
        this.inputname = inputname;
    }

    public String getInputname() {
        return this.inputname;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setSavePacked() {
        this.saveMode = 0;
    }

    public void setSaveUnpacked() {
        this.saveMode = 1;
    }

    public int getSaveMode() {
        return this.saveMode;
    }

    public String getNameRmic() {
        return this.nameRmic;
    }

    public void setNameRmic(String nameRmic) {
        this.nameRmic = nameRmic;
    }

    public String getNameJava() {
        return this.nameJava;
    }

    public boolean isDTDsAllowed() {
        return this.dtdsAllowed;
    }

    public void setDTDsAllowed(boolean dTDsAllowed) {
        this.dtdsAllowed = dTDsAllowed;
    }
}

