/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha.interceptors.jrmp;

import java.io.IOException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.cmi.ha.interceptor.HAContext;
import org.ow2.carol.cmi.ha.interceptor.HACurrent;
import org.ow2.carol.rmi.jrmp.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServiceContext;
import org.ow2.jonas.lib.ejb21.ha.interceptors.jrmp.HAServiceContext;
import org.ow2.jonas.lib.util.Log;

public class HAServerInterceptor
implements JServerRequestInterceptor {
    private String interceptorName = "HAServerInterceptor";
    private static Logger logger = Log.getLogger((String)"org.ow2.carol.cmi.ha");

    public String name() {
        return this.interceptorName;
    }

    public void receive_request(JServerRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        HAServiceContext receivedCtx = (HAServiceContext)jri.get_request_service_context(HAServiceContext.HA_CTX_ID);
        if (receivedCtx == null) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)receivedCtx.toString());
        }
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = receivedCtx.getHaContext();
        Stack requests = haContext.getRequests();
        current.setRequests(requests);
        boolean onFailover = haContext.isOnFailover();
        current.setOnFailover(onFailover);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"HACtx asocciated to Thread");
        }
    }

    public void send_reply(JServerRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    public void send_exception(JServerRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    public void send_other(JServerRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    private void putHAContext(JServerRequestInfo jri) {
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = new HAContext();
        Stack requests = current.getRequests();
        haContext.setRequests(requests);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("newHACtx: " + haContext));
        }
        HAServiceContext haServiceContext = new HAServiceContext(haContext);
        jri.add_reply_service_context((JServiceContext)haServiceContext);
    }
}

