/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.jms.JmsManager;
import org.ow2.jonas.lib.jms.JConnection;
import org.ow2.jonas.lib.jms.JmsManagerImpl;
import org.ow2.jonas.lib.jms.TraceJms;

public class JConnectionFactory
implements ConnectionFactory,
Referenceable,
Serializable {
    protected JmsManager jms;
    protected String name;
    protected XAConnectionFactory xacf;
    private LinkedList connectionpool = new LinkedList();

    public JConnectionFactory(String name) {
        this.name = name;
        this.jms = JmsManagerImpl.getJmsManager();
        this.xacf = this.jms.getXAConnectionFactory();
    }

    protected JConnectionFactory() {
    }

    public Connection createConnection() throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        JConnection c = this.getJConnection();
        if (c == null) {
            c = new JConnection(this, this.xacf);
        }
        return c;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        JConnection c = this.getJConnection(userName);
        if (c == null) {
            c = new JConnection(this, this.xacf, userName, password);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeJConnection(JConnection con) {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        LinkedList linkedList = this.connectionpool;
        synchronized (linkedList) {
            this.connectionpool.addLast(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanPool() {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        JConnection con2 = null;
        LinkedList linkedList = this.connectionpool;
        synchronized (linkedList) {
            for (JConnection con2 : this.connectionpool) {
                try {
                    con2.finalClose();
                }
                catch (JMSException e) {}
            }
        }
    }

    public JConnection getJConnection() {
        return this.getJConnection("anInternalNameUsedOnlyByJOnAS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JConnection getJConnection(String user) {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        JConnection con = null;
        LinkedList linkedList = this.connectionpool;
        synchronized (linkedList) {
            Iterator i = this.connectionpool.iterator();
            while (i.hasNext()) {
                con = (JConnection)i.next();
                if (!con.getUser().equals(user)) continue;
                i.remove();
                break;
            }
        }
        return con;
    }

    public Reference getReference() throws NamingException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return new Reference(this.getClass().getName(), "org.ow2.jonas.lib.jms.JObjectFactory", null);
    }
}

