/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.jms.JConnection;
import org.ow2.jonas.lib.jms.JSession;
import org.ow2.jonas.lib.jms.TraceJms;

public class JQueueSession
extends JSession
implements QueueSession {
    protected XAQueueConnection xaqc;
    protected QueueSession qs = null;
    protected XAQueueSession xaqs = null;

    public JQueueSession(JConnection jconn, XAQueueConnection xaqc) {
        super(jconn);
        this.xaqc = xaqc;
    }

    protected Session getMOMSession() throws JMSException {
        return this.getMOMQueueSession();
    }

    protected QueueSession getMOMQueueSession() throws JMSException {
        Transaction tx = null;
        try {
            tx = tm.getTransaction();
        }
        catch (SystemException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"cannot get Transaction");
        }
        if (tx == null) {
            if (this.qs == null) {
                this.qs = this.xaqc.createQueueSession(false, 1);
                this.jconn.sessionOpen(this);
            }
            return this.qs;
        }
        if (this.xaqs == null) {
            this.xaqs = this.xaqc.createXAQueueSession();
            if (this.currtx != null) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)"mixed transactions");
            }
            this.currtx = tx;
            this.xares = this.xaqs.getXAResource();
            try {
                tx.enlistResource(this.getXAResource());
                this.txover = false;
            }
            catch (SystemException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot enlist session:" + (Object)((Object)e)));
                throw new JMSException(e.toString());
            }
            catch (RollbackException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)"transaction rolled back");
                throw new JMSException(e.toString());
            }
        }
        return this.xaqs.getQueueSession();
    }

    protected void MOMSessionClose() {
        try {
            if (this.xaqs != null) {
                this.xaqs.close();
                this.xaqs = null;
            }
            if (this.qs != null) {
                this.qs.close();
                this.qs = null;
                this.jconn.sessionClose(this);
            }
        }
        catch (JMSException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("exception:" + (Object)((Object)e)));
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createBrowser(queue, messageSelector);
    }

    public Queue createQueue(String queueName) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createReceiver(queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createSender(queue);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMQueueSession().createTemporaryQueue();
    }
}

