/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import fr.dyade.aaa.agent.AgentServer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.client.jms.XAQueueConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XAQueueLocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XATopicLocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XAQueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATopicTcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.jonas.jms.JmsAdministration;
import org.ow2.jonas.lib.jms.TraceJms;
import org.ow2.jonas.lib.util.Env;

public class JmsAdminForJoram
implements JmsAdministration {
    private static String QUEUE_CONN_FACT_NAME = "JQCF";
    private static String TOPIC_CONN_FACT_NAME = "JTCF";
    private static String CONN_FACT_NAME = "JCF";
    private boolean collocatedmom = false;
    private InitialContext ictx = null;
    private Vector namelist = new Vector();
    private javax.jms.XAConnectionFactory xacf = null;
    private XATopicConnectionFactory xatcf = null;
    private javax.jms.XAQueueConnectionFactory xaqcf = null;
    private ConnectionFactory jcf = null;
    private TopicConnectionFactory jtcf = null;
    private QueueConnectionFactory jqcf = null;
    private User user = null;
    private User jonasUser = null;
    private String host = null;
    private int port;

    private void startMOM() throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            String A3CONF_DIR_PROP;
            String a3config_dir;
            String TRANSACTION_PROP = "Transaction";
            String s1 = System.getProperty(TRANSACTION_PROP);
            if (s1 == null) {
                System.setProperty(TRANSACTION_PROP, "fr.dyade.aaa.util.NullTransaction");
            }
            if ((a3config_dir = System.getProperty(A3CONF_DIR_PROP = "fr.dyade.aaa.agent.A3CONF_DIR")) == null) {
                System.setProperty(A3CONF_DIR_PROP, System.getProperty("jonas.base") + System.getProperty("file.separator") + "conf");
            }
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("a3config_dir= " + a3config_dir));
            }
            short serverId = 0;
            AgentServer.init((short)serverId, (String)"s0", (LoggerFactory)TraceJms.getLoggerFactory());
            AgentServer.start();
            Thread.sleep(10L);
            short sid = AgentServer.getServerId();
            this.host = AgentServer.getHostname((short)sid);
            this.port = 16010;
            try {
                String s = AgentServer.getServiceArgs((short)sid, (String)"org.objectweb.joram.mom.proxies.tcp.TcpProxyService");
                StringTokenizer st = new StringTokenizer(s);
                this.port = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException exc) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("exception: " + exc));
            }
            catch (Exception e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("MOM exception:" + e));
                throw e;
            }
            TraceJms.logger.log(BasicLevel.INFO, (Object)("starting MOM on host " + this.host + ", port " + this.port));
        }
        catch (Exception ex) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("exception: " + ex));
            throw ex;
        }
    }

    public void start(boolean collocated, String url) throws Exception {
        if (collocated) {
            this.collocatedmom = true;
            this.startMOM();
        }
        this.ictx = new InitialContext();
        if (this.host != null) {
            TraceJms.logger.log(BasicLevel.INFO, (Object)("starting JmsAdmin with host " + this.host + ", port " + this.port));
            AdminModule.collocatedConnect((String)"root", (String)"root");
        } else if (url != null && url.length() > 0) {
            int indexOfHost = url.indexOf("//") + 2;
            int indexOfPort = url.indexOf(":", indexOfHost) + 1;
            this.host = url.substring(indexOfHost, indexOfPort - 1);
            this.port = Integer.parseInt(url.substring(indexOfPort));
            TraceJms.logger.log(BasicLevel.WARN, (Object)("starting JmsAdmin with host " + this.host + ", port " + this.port));
            AdminModule.connect((String)this.host, (int)this.port, (String)"root", (String)"root", (int)100);
        } else {
            TraceJms.logger.log(BasicLevel.WARN, (Object)"starting JmsAdmin with default url");
            AdminModule.connect((String)"root", (String)"root", (int)100);
        }
        this.user = User.create((String)"anonymous", (String)"anonymous");
        this.jonasUser = User.create((String)"jonas", (String)"jonas");
        if (collocated) {
            this.xacf = XALocalConnectionFactory.create();
            ((XAConnectionFactory)this.xacf).getParameters().queueMessageReadMax = 2;
            this.xatcf = XATopicLocalConnectionFactory.create();
            ((org.objectweb.joram.client.jms.XATopicConnectionFactory)this.xatcf).getParameters().queueMessageReadMax = 2;
            this.xaqcf = XAQueueLocalConnectionFactory.create();
            ((XAQueueConnectionFactory)this.xaqcf).getParameters().queueMessageReadMax = 2;
        } else {
            this.xacf = XATcpConnectionFactory.create((String)this.host, (int)this.port);
            ((XAConnectionFactory)this.xacf).getParameters().queueMessageReadMax = 2;
            this.xatcf = XATopicTcpConnectionFactory.create((String)this.host, (int)this.port);
            ((org.objectweb.joram.client.jms.XATopicConnectionFactory)this.xatcf).getParameters().queueMessageReadMax = 2;
            this.xaqcf = XAQueueTcpConnectionFactory.create((String)this.host, (int)this.port);
            ((XAQueueConnectionFactory)this.xaqcf).getParameters().queueMessageReadMax = 2;
        }
        String name = CONN_FACT_NAME;
        try {
            this.jcf = TcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)this.jcf);
            this.namelist.addElement(name);
        }
        catch (NamingException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot register " + name));
        }
        name = QUEUE_CONN_FACT_NAME;
        try {
            this.jqcf = QueueTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)this.jqcf);
            this.namelist.addElement(name);
        }
        catch (NamingException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot register " + name));
        }
        name = TOPIC_CONN_FACT_NAME;
        try {
            this.jtcf = TopicTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)this.jtcf);
            this.namelist.addElement(name);
        }
        catch (NamingException e) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot register " + name));
        }
    }

    public void stop() {
        if (Env.isJAVA4()) {
            try {
                AdminModule.disconnect();
            }
            catch (Exception ex) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("problem for closing admin object " + ex));
            }
            if (this.collocatedmom) {
                AgentServer.stop();
                if (TraceJms.isDebug()) {
                    TraceJms.logger.log(BasicLevel.DEBUG, (Object)"agentServer stopped");
                }
            }
        }
        try {
            this.ictx.unbind(CONN_FACT_NAME);
            this.ictx.unbind(QUEUE_CONN_FACT_NAME);
            this.ictx.unbind(TOPIC_CONN_FACT_NAME);
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)"unbind connection factories");
            }
        }
        catch (Exception ex) {
            TraceJms.logger.log(BasicLevel.ERROR, (Object)"cannot unbind connection factories");
        }
    }

    public javax.jms.XAConnectionFactory getXAConnectionFactory() {
        return this.xacf;
    }

    public XATopicConnectionFactory getXATopicConnectionFactory() {
        return this.xatcf;
    }

    public javax.jms.XAQueueConnectionFactory getXAQueueConnectionFactory() {
        return this.xaqcf;
    }

    public Queue createQueue(String name) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        org.objectweb.joram.client.jms.Queue queue = null;
        try {
            queue = (org.objectweb.joram.client.jms.Queue)this.ictx.lookup(name);
        }
        catch (Exception e) {
            queue = org.objectweb.joram.client.jms.Queue.create((String)name);
            this.ictx.rebind(name, (Object)queue);
        }
        queue.setWriter(this.user);
        queue.setReader(this.user);
        queue.setWriter(this.jonasUser);
        queue.setReader(this.jonasUser);
        return queue;
    }

    public javax.jms.Topic createTopic(String name) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        Topic topic = null;
        try {
            topic = (Topic)this.ictx.lookup(name);
        }
        catch (Exception e) {
            topic = Topic.create((String)name);
            this.ictx.rebind(name, (Object)topic);
        }
        topic.setWriter(this.user);
        topic.setReader(this.user);
        topic.setWriter(this.jonasUser);
        topic.setReader(this.jonasUser);
        return topic;
    }

    public void deleteDestination(String name) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            Destination dest = (Destination)this.ictx.lookup(name);
            dest.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPendingMessages(Queue queue) throws Exception {
        return ((org.objectweb.joram.client.jms.Queue)queue).getPendingMessages();
    }

    public int getPendingRequests(Queue queue) throws Exception {
        return ((org.objectweb.joram.client.jms.Queue)queue).getPendingRequests();
    }

    public int getSubscriptions(javax.jms.Topic topic) throws Exception {
        return ((Topic)topic).getSubscriptions();
    }
}

