/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.jms.JmsAdministration;
import org.ow2.jonas.jms.JmsManager;
import org.ow2.jonas.lib.jms.JConnectionFactory;
import org.ow2.jonas.lib.jms.JQueueConnectionFactory;
import org.ow2.jonas.lib.jms.JTopicConnectionFactory;
import org.ow2.jonas.lib.jms.JmsJmxManagement;
import org.ow2.jonas.lib.jms.TraceJms;
import org.ow2.jonas.tm.TransactionManager;

public class JmsManagerImpl
implements JmsManager,
JmsJmxManagement {
    private JmsAdministration momadmin = null;
    private InitialContext ictx = null;
    private ConnectionFactory cf = null;
    private TopicConnectionFactory tcf = null;
    private QueueConnectionFactory qcf = null;
    private Hashtable queues = new Hashtable();
    private Hashtable topics = new Hashtable();
    private Vector namelist = new Vector();
    private static TransactionManager tm = null;
    private static JmsManagerImpl unique = null;

    private JmsManagerImpl() {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
    }

    public static JmsManager getJmsManager() {
        if (unique == null) {
            unique = new JmsManagerImpl();
        }
        return unique;
    }

    public static JmsJmxManagement getJmsJmxManagement() {
        if (unique == null) {
            unique = new JmsManagerImpl();
        }
        return unique;
    }

    public static TransactionManager getTransactionManager() {
        return tm;
    }

    public void init(Class cl, boolean collocated, String url, TransactionManager trm) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        tm = trm;
        int maxloops = collocated ? 1 : 5;
        for (int i = 0; i < maxloops; ++i) {
            try {
                this.ictx = new InitialContext();
                this.momadmin = (JmsAdministration)cl.newInstance();
                this.momadmin.start(collocated, url);
                break;
            }
            catch (NamingException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)"cannot get Initial Context", (Throwable)e);
                throw e;
            }
            catch (NullPointerException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)"exception: ", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                if (i < maxloops) {
                    if (TraceJms.isDebug()) {
                        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"cannot reach the MOM - retrying...");
                    }
                    try {
                        Thread.sleep(2000 * (i + 1));
                        continue;
                    }
                    catch (InterruptedException e2) {
                        throw new JMSException("Cannot reach the MOM");
                    }
                }
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot load admin class " + e));
                throw e;
            }
        }
        this.getConnectionFactory();
        this.getTopicConnectionFactory();
        this.getQueueConnectionFactory();
    }

    public Queue createQueue(String name) throws Exception {
        Queue queue = null;
        try {
            queue = (Queue)this.ictx.lookup(name);
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("queue " + name + " already found"));
            }
            return queue;
        }
        catch (NamingException namingException) {
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("creating and registering queue " + name));
            }
            queue = this.momadmin.createQueue(name);
            this.namelist.addElement(name);
            this.queues.put(name, queue);
            return queue;
        }
    }

    public Topic createTopic(String name) throws Exception {
        Topic topic = null;
        try {
            topic = (Topic)this.ictx.lookup(name);
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("topic " + name + " already found"));
            }
            return topic;
        }
        catch (NamingException namingException) {
            if (TraceJms.isDebug()) {
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("creating and registering topic " + name));
            }
            topic = this.momadmin.createTopic(name);
            this.namelist.addElement(name);
            this.topics.put(name, topic);
            return topic;
        }
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.cf == null) {
            String name = "CF";
            this.cf = new JConnectionFactory(name);
            try {
                if (TraceJms.isDebug()) {
                    TraceJms.logger.log(BasicLevel.DEBUG, (Object)("creating and registering " + name));
                }
                this.ictx.rebind(name, (Object)this.cf);
            }
            catch (NamingException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot rebind " + name + " :" + e));
            }
        }
        return this.cf;
    }

    public TopicConnectionFactory getTopicConnectionFactory() {
        if (this.tcf == null) {
            String name = "TCF";
            this.tcf = new JTopicConnectionFactory(name);
            try {
                if (TraceJms.isDebug()) {
                    TraceJms.logger.log(BasicLevel.DEBUG, (Object)("creating and registering " + name));
                }
                this.ictx.rebind(name, (Object)this.tcf);
            }
            catch (NamingException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot rebind " + name + " :" + e));
            }
        }
        return this.tcf;
    }

    public QueueConnectionFactory getQueueConnectionFactory() {
        if (this.qcf == null) {
            String name = "QCF";
            this.qcf = new JQueueConnectionFactory(name);
            try {
                if (TraceJms.isDebug()) {
                    TraceJms.logger.log(BasicLevel.DEBUG, (Object)("creating and registering " + name));
                }
                this.ictx.rebind(name, (Object)this.qcf);
            }
            catch (NamingException e) {
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot rebind " + name + " :" + e));
            }
        }
        return this.qcf;
    }

    public XAConnectionFactory getXAConnectionFactory() {
        return this.momadmin.getXAConnectionFactory();
    }

    public XATopicConnectionFactory getXATopicConnectionFactory() {
        return this.momadmin.getXATopicConnectionFactory();
    }

    public XAQueueConnectionFactory getXAQueueConnectionFactory() {
        return this.momadmin.getXAQueueConnectionFactory();
    }

    public Queue getQueue(String name) throws Exception {
        Queue q = (Queue)this.queues.get(name);
        if (q == null) {
            q = this.createQueue(name);
        }
        return q;
    }

    public Topic getTopic(String name) throws Exception {
        Topic t = (Topic)this.topics.get(name);
        if (t == null) {
            t = this.createTopic(name);
        }
        return t;
    }

    public Enumeration getTopicsNames() {
        return this.topics.keys();
    }

    public Enumeration getQueuesNames() {
        return this.queues.keys();
    }

    public void stop() throws Exception {
        if (this.cf != null) {
            ((JConnectionFactory)this.cf).cleanPool();
        }
        if (this.tcf != null) {
            ((JConnectionFactory)this.tcf).cleanPool();
        }
        if (this.qcf != null) {
            ((JConnectionFactory)this.qcf).cleanPool();
        }
        if (this.momadmin != null) {
            this.momadmin.stop();
        }
        Enumeration ln = this.namelist.elements();
        while (ln.hasMoreElements()) {
            String name = (String)ln.nextElement();
            try {
                this.ictx.unbind(name);
                if (!TraceJms.isDebug()) continue;
                TraceJms.logger.log(BasicLevel.DEBUG, (Object)("unbind " + name));
            }
            catch (NamingException e) {
                if (!TraceJms.isDebug()) continue;
                TraceJms.logger.log(BasicLevel.ERROR, (Object)("cannot unbind " + name));
            }
        }
    }

    public int getCurrentNumberOfJmsConnectionFactory() {
        int result = 0;
        if (this.cf != null) {
            ++result;
        }
        return result;
    }

    public int getCurrentNumberOfJmsTopicConnectionFactory() {
        int result = 0;
        if (this.tcf != null) {
            ++result;
        }
        return result;
    }

    public int getCurrentNumberOfJmsQueueConnectionFactory() {
        int result = 0;
        if (this.qcf != null) {
            ++result;
        }
        return result;
    }

    public int getCurrentNumberOfJmsTopicDestination() {
        return this.topics.size();
    }

    public int getCurrentNumberOfJmsQueueDestination() {
        return this.queues.size();
    }

    public String removeJmsDestination(String jndiName) throws Exception {
        this.momadmin.deleteDestination(jndiName);
        String destType = null;
        if (this.queues.containsKey(jndiName) || this.topics.containsKey(jndiName)) {
            try {
                InitialContext ictx = new InitialContext();
                ictx.unbind(jndiName);
                Object o = null;
                o = this.queues.remove(jndiName);
                destType = o == null ? ((o = this.topics.remove(jndiName)) != null ? "topic" : "unknown") : "queue";
                return destType;
            }
            catch (Exception ex) {
                throw new Exception("JmsManagerImpl remove destination : cannot unbind " + jndiName);
            }
        }
        throw new Exception("Unexisting jms destination :" + jndiName + " remove abord");
    }

    public String getDefaultConnectionFactoryName() {
        return "CF";
    }

    public String getDefaultQueueConnectionFactoryName() {
        return "QCF";
    }

    public String getDefaultTopicConnectionFactoryName() {
        return "TCF";
    }

    public String getConnectionFactoryMode(String jndiName) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        if (jndiName.equals("CF")) {
            return "Point-To-Point and Publish/Subscribe";
        }
        if (jndiName.equals("QCF")) {
            return "Point-To-Point";
        }
        if (jndiName.equals("TCF")) {
            return "Publish/Subscribe";
        }
        throw new IllegalStateException("Unknown factory.");
    }

    public int getPendingMessages(String jndiName) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        Queue queue = (Queue)this.queues.get(jndiName);
        if (queue == null) {
            throw new IllegalStateException(jndiName + " not a queue created by the jms service");
        }
        int n = this.momadmin.getPendingMessages(queue);
        return n;
    }

    public int getPendingRequests(String jndiName) throws Exception {
        TraceJms.logger.log(BasicLevel.DEBUG, (Object)"");
        Queue queue = (Queue)this.queues.get(jndiName);
        if (queue == null) {
            throw new IllegalStateException(jndiName + " not a queue created by the jms service");
        }
        int n = this.momadmin.getPendingRequests(queue);
        return n;
    }

    public int getSubscriptions(String jndiName) throws Exception {
        Topic topic = (Topic)this.topics.get(jndiName);
        if (topic == null) {
            throw new IllegalStateException(jndiName + " not a topic created by the jms service");
        }
        int n = this.momadmin.getSubscriptions(topic);
        return n;
    }
}

