/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ear.EarService;
import org.ow2.jonas.lib.work.AbsCleanTask;
import org.ow2.jonas.lib.work.CleanerException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.FileManager;
import org.ow2.jonas.lib.work.FileManagerException;
import org.ow2.jonas.lib.work.LogEntry;

public class EarCleanTask
extends AbsCleanTask {
    private static DeployerLog earDeployerLog = null;
    private static URL earAppsUrl = null;
    private EarService earService;

    public EarCleanTask(EarService earService, URL earApps, DeployerLog earDeployerLog) {
        this.earService = earService;
        earAppsUrl = earApps;
        EarCleanTask.earDeployerLog = earDeployerLog;
    }

    protected boolean isValidLogEntry(LogEntry logEntry) throws CleanerException {
        String fTimeStamp = null;
        File earLogEntryFile = logEntry.getOriginal();
        String earLogEntryUnpackedDir = logEntry.getCopy().getName();
        if (EarCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
            EarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry <" + earLogEntryFile.getName() + "> exist :" + earLogEntryFile.exists()));
        }
        if (!earLogEntryFile.exists()) {
            return false;
        }
        try {
            fTimeStamp = FileManager.fileToTimeStampDir((URL)earLogEntryFile.toURL());
        }
        catch (FileManagerException efme) {
            throw new CleanerException("Can't get the timestamp of the file " + earLogEntryFile + " : " + efme.getMessage());
        }
        catch (MalformedURLException mue) {
            throw new CleanerException("Can't get the timestamp of the file " + earLogEntryFile + " : " + mue.getMessage());
        }
        if (EarCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
            EarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry fTimeStamp :" + fTimeStamp));
            EarCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry isValid :" + fTimeStamp.equalsIgnoreCase(earLogEntryUnpackedDir)));
        }
        return fTimeStamp.equalsIgnoreCase(earLogEntryUnpackedDir);
    }

    protected void removeLogEntry(LogEntry logEntry) throws CleanerException {
        String earLogEntryUnpackedDir = logEntry.getCopy().getName();
        File dirEar = new File(earAppsUrl.getFile() + File.separator + earLogEntryUnpackedDir);
        this.removeRecursiveDirectory(dirEar);
        try {
            earDeployerLog.removeEntry(logEntry);
        }
        catch (DeployerLogException edle) {
            throw new CleanerException("Can't remove an entry" + edle.getMessage());
        }
    }

    protected Vector getLogEntries() {
        return earDeployerLog.getEntries();
    }

    protected boolean isDeployLogEntry(LogEntry logEntry) throws CleanerException {
        return this.earService.isEarDeployedByUnpackName(logEntry.getCopy().getName());
    }
}

