/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.common;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManager;
import org.ow2.carol.cmi.controller.common.CMIThreadFactory;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.common.LocalObjectData;
import org.ow2.carol.cmi.ha.SessionId;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.util.LBPolicyFactory;
import org.ow2.carol.cmi.lb.util.LBPolicyFactoryException;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsClusterViewManager
implements ClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsClusterViewManager.class);
    private static volatile ClusterViewManager clusterViewManager;
    private final Map<String, LocalObjectData> LOCAL_OBJECT_DATA = new ConcurrentHashMap<String, LocalObjectData>();
    private final CMIThreadFactory cmiThreadFactory;
    private final UUID uuid;
    private final AtomicLong sessionNb = new AtomicLong(0L);

    protected AbsClusterViewManager() {
        String managerName = this instanceof ClientClusterViewManager ? "ClientClusterViewManager" : "ServerClusterViewManager";
        this.cmiThreadFactory = new CMIThreadFactory(managerName);
        this.uuid = UUID.randomUUID();
    }

    protected static final void setClusterViewManager(ClusterViewManager clusterViewManager) {
        if (clusterViewManager == null || AbsClusterViewManager.clusterViewManager == null) {
            AbsClusterViewManager.clusterViewManager = clusterViewManager;
        } else {
            LOGGER.warn((Object)"The cluster view manager is already initialized", new Object[0]);
        }
    }

    @Override
    public final ILBPolicy<CMIReference> getLBPolicy(String objectName) throws ObjectNotFoundException {
        try {
            return this.LOCAL_OBJECT_DATA.get(objectName).getLBPolicy();
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"Cannot find object with name {0}", new Object[]{objectName, e});
            throw new ObjectNotFoundException("Cannot find object with name " + objectName, e);
        }
    }

    private void setLBPolicy(String objectName, ILBPolicy<CMIReference> lbPolicy) throws ObjectNotFoundException {
        try {
            this.LOCAL_OBJECT_DATA.get(objectName).setLBPolicy(lbPolicy);
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"Cannot find object with name {0}", new Object[]{objectName, e});
            throw new ObjectNotFoundException("Cannot find object with name " + objectName, e);
        }
    }

    @Override
    public final Pool<CMIReferenceable, CMIReference> getPool(String objectName) throws ObjectNotFoundException {
        try {
            return this.LOCAL_OBJECT_DATA.get(objectName).getPool();
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"Cannot find object with name {0}", new Object[]{objectName, e});
            throw new ObjectNotFoundException("Cannot find object with name " + objectName, e);
        }
    }

    @Override
    public final void setPool(String objectName, Pool<CMIReferenceable, CMIReference> pool) throws ObjectNotFoundException {
        try {
            this.LOCAL_OBJECT_DATA.get(objectName).setPool(pool);
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"Cannot find object with name {0}", new Object[]{objectName, e});
            throw new ObjectNotFoundException("Cannot find object with name " + objectName, e);
        }
    }

    protected final void updateLBPolicy(String objectName) throws ObjectNotFoundException, LBPolicyFactoryException {
        if (this.LOCAL_OBJECT_DATA.containsKey(objectName)) {
            LOGGER.debug((Object)"Updating LB policy for {0}", new Object[]{objectName});
            LBPolicyFactory lbPolicyFactory = new LBPolicyFactory(this);
            ILBPolicy<CMIReference> lbPolicy = lbPolicyFactory.getLBPolicy(objectName);
            this.setLBPolicy(objectName, lbPolicy);
        }
    }

    protected final void initLocalData(String objectName) {
        this.LOCAL_OBJECT_DATA.put(objectName, new LocalObjectData(objectName));
    }

    protected final boolean isLocalDataInitialized(String objectName) {
        return this.LOCAL_OBJECT_DATA.containsKey(objectName);
    }

    protected final Set<String> getNamesOfInitializedObjects() {
        return this.LOCAL_OBJECT_DATA.keySet();
    }

    public static final ClusterViewManager getClusterViewManager() {
        return clusterViewManager;
    }

    protected final int getLocalMinPoolSize(String objectName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    protected final void setLocalMinSize(String objectName, int minSize) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    protected final int getLocalMaxPoolSize(String objectName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    protected final void setLocalMaxSize(String objectName, int maxSize) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    protected final boolean hasPool(String objectName) throws ObjectNotFoundException {
        try {
            return this.LOCAL_OBJECT_DATA.get(objectName).getPool() != null;
        }
        catch (NullPointerException e) {
            LOGGER.debug((Object)"Cannot find object with name {0}", new Object[]{objectName, e});
            throw new ObjectNotFoundException("Cannot find object with name " + objectName, e);
        }
    }

    protected final CMIThreadFactory getCmiThreadFactory() {
        return this.cmiThreadFactory;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public SessionId getSessionId() {
        return new SessionId(AbsClusterViewManager.getClusterViewManager().getUUID(), this.sessionNb.incrementAndGet());
    }
}

