/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.mbean;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.management.MBeanException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.modeler.BaseModelMBean;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.lib.JLSResourceResolver;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class ArchiveConfigMBean
extends BaseModelMBean {
    private static String serializeDocument(Document doc) {
        XMLSerializer ser = new XMLSerializer(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ser.serialize((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ((Object)out).toString();
    }

    public void createArchiveWithXmlFile(String archiveName, String xmlFilePath, String doc) throws IOException {
        JarOutputStream tempJar;
        JarEntry newEntry;
        try {
            newEntry = new JarEntry(xmlFilePath);
            File tempJarFile = new File(archiveName);
            if (tempJarFile.exists()) {
                throw new Exception("File already exists.");
            }
            tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        try {
            byte[] bytes = doc.getBytes();
            tempJar.putNextEntry(newEntry);
            tempJar.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        finally {
            tempJar.close();
        }
    }

    public void addXML(String archiveName, String xmlFilePath, String docString) throws IOException {
        JarOutputStream tempJar;
        File tempJarFile;
        JarEntry newEntry;
        JarFile rarFile;
        File jarFile;
        boolean updated = false;
        try {
            jarFile = new File(archiveName);
            rarFile = new JarFile(jarFile);
            newEntry = new JarEntry(xmlFilePath);
            tempJarFile = new File(archiveName + ".tmp");
            tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        try {
            byte[] buffer = new byte[1024];
            byte[] bytes = docString.getBytes();
            tempJar.putNextEntry(newEntry);
            tempJar.write(bytes, 0, bytes.length);
            Enumeration<JarEntry> entries = rarFile.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                if (entry.getName().equals(xmlFilePath)) continue;
                InputStream entryStream = rarFile.getInputStream(entry);
                tempJar.putNextEntry(entry);
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    tempJar.write(buffer, 0, bytesRead);
                }
            }
            updated = true;
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        finally {
            rarFile.close();
            tempJar.close();
            if (updated) {
                jarFile.delete();
                tempJarFile.renameTo(jarFile);
            }
        }
    }

    public void saveXML(String archiveName, String xmlFilePath, Document doc) throws IOException {
        JarOutputStream tempJar;
        File tempJarFile;
        JarEntry newEntry;
        JarFile rarFile;
        File jarFile;
        boolean updated = false;
        try {
            jarFile = new File(archiveName);
            rarFile = new JarFile(jarFile);
            newEntry = new JarEntry(xmlFilePath);
            tempJarFile = new File(archiveName + ".tmp");
            tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        try {
            byte[] buffer = new byte[1024];
            String docString = ArchiveConfigMBean.serializeDocument(doc);
            byte[] bytes = docString.getBytes();
            tempJar.putNextEntry(newEntry);
            tempJar.write(bytes, 0, bytes.length);
            Enumeration<JarEntry> entries = rarFile.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                if (entry.getName().equals(xmlFilePath)) continue;
                InputStream entryStream = rarFile.getInputStream(entry);
                tempJar.putNextEntry(entry);
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    tempJar.write(buffer, 0, bytesRead);
                }
            }
            updated = true;
        }
        catch (Exception e) {
            throw new IOException("Unable to update archive: " + archiveName + "\n" + e.getMessage());
        }
        finally {
            rarFile.close();
            tempJar.close();
            if (updated) {
                jarFile.delete();
                tempJarFile.renameTo(jarFile);
            }
        }
    }

    public void verifyDocument(Document doc) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver((LSResourceResolver)new JLSResourceResolver(this.getEntityResolver()));
        String schemaPath = this.getSchema(doc);
        if (schemaPath != null) {
            URL url = new URL(schemaPath);
            Schema schema = factory.newSchema(url);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(doc));
        }
    }

    protected EntityResolver getEntityResolver() {
        return null;
    }

    public Document extractDocument(String archiveName, String xmlFilePath) throws Exception {
        Document result = null;
        InputStream raInputStream = null;
        ZipEntry raZipEntry = null;
        try {
            JarFile rarFile = new JarFile(archiveName);
            raZipEntry = rarFile.getEntry(xmlFilePath);
            if (raZipEntry == null) {
                throw new FileNotFoundException("Could not find " + xmlFilePath + " in " + archiveName);
            }
            raInputStream = rarFile.getInputStream(raZipEntry);
            result = this.newDocument(raInputStream, xmlFilePath);
        }
        catch (Exception e) {
            Logger logger = Log.getLogger((String)"org.ow2.jonas.admin");
            logger.log(BasicLevel.WARN, (Object)("Could not load XML file '" + xmlFilePath + "' from '" + archiveName + "': " + e.getMessage()));
            throw e;
        }
        return result;
    }

    public String extractXML(String archiveName, String xmlFilePath) throws Exception {
        String result = null;
        InputStream inputStream = null;
        ZipEntry zipEntry = null;
        try {
            StringBuffer sb;
            JarFile rarFile = new JarFile(archiveName);
            zipEntry = rarFile.getEntry(xmlFilePath);
            if (zipEntry != null) {
                inputStream = rarFile.getInputStream(zipEntry);
                InputStreamReader reader = new InputStreamReader(inputStream);
                BufferedReader br = new BufferedReader(reader);
                sb = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
            } else {
                throw new FileNotFoundException("Could not find " + xmlFilePath + " in " + archiveName);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            Logger logger = Log.getLogger((String)"org.ow2.jonas.admin");
            logger.log(BasicLevel.WARN, (Object)("Could not load XML file '" + xmlFilePath + "' from '" + archiveName + "': " + e.getMessage()));
            throw e;
        }
        return result;
    }

    private Document newDocument(InputStream is, String name) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (this.getEntityResolver() != null) {
            builder.setEntityResolver(this.getEntityResolver());
        }
        Document doc = builder.parse(is);
        is.close();
        return doc;
    }

    private String getSchema(Document doc) {
        String schemaPath = null;
        if (doc.getDocumentElement().getAttribute("xsi:schemaLocation") != null) {
            String[] parts = doc.getDocumentElement().getAttribute("xsi:schemaLocation").trim().split(" ");
            String schemaURL = parts[parts.length - 1];
            String schemaName = schemaURL.substring(schemaURL.lastIndexOf(47) + 1);
            if (this.getSchemaList() != null) {
                for (String schema : this.getSchemaList()) {
                    String file = schema.substring(schema.lastIndexOf(47) + 1);
                    if (!file.equals(schemaName)) continue;
                    schemaPath = schema;
                }
            }
        }
        return schemaPath;
    }

    protected List getSchemaList() {
        return null;
    }
}

